/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.apply;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r5.model.Parameters;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;
import org.opencds.cqf.fhir.cr.common.IInputParameterResolver;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Constants;
import org.opencds.cqf.fhir.utility.adapter.IPlanDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireAdapter;
import org.opencds.cqf.fhir.utility.dstu3.Parameters;

public class ApplyRequest
implements ICpgRequest {
    private static final String ACTIVITY_DEFINITION = "ActivityDefinition";
    private final IPlanDefinitionAdapter planDefinitionAdapter;
    private final IIdType subjectId;
    private final IIdType encounterId;
    private final IIdType practitionerId;
    private final IIdType organizationId;
    private final IBaseDatatype userType;
    private final IBaseDatatype userLanguage;
    private final IBaseDatatype userTaskContext;
    private final IBaseDatatype setting;
    private final IBaseDatatype settingContext;
    private final IBaseParameters parameters;
    private IBaseBundle data;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirVersionEnum fhirVersion;
    private final Map<String, String> referencedLibraries;
    private final IInputParameterResolver inputParameterResolver;
    private final Collection<IBaseResource> requestResources;
    private final Collection<IBaseResource> extractedResources;
    private IBaseOperationOutcome operationOutcome;
    private IBaseResource questionnaire;
    private IQuestionnaireAdapter questionnaireAdapter;
    private Boolean containResources;

    public ApplyRequest(IBaseResource planDefinition, IIdType subjectId, IIdType encounterId, IIdType practitionerId, IIdType organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, IBaseBundle data, List<? extends IBaseBackboneElement> prefetchData, LibraryEngine libraryEngine, ModelResolver modelResolver, IInputParameterResolver inputParameterResolver) {
        Preconditions.checkNotNull((Object)planDefinition, (Object)"expected non-null value for planDefinition");
        Preconditions.checkNotNull((Object)libraryEngine, (Object)"expected non-null value for libraryEngine");
        Preconditions.checkNotNull((Object)modelResolver, (Object)"expected non-null value for modelResolver");
        this.fhirVersion = planDefinition.getStructureFhirVersionEnum();
        this.planDefinitionAdapter = this.getAdapterFactory().createPlanDefinition(planDefinition);
        this.subjectId = subjectId;
        this.encounterId = encounterId;
        this.practitionerId = practitionerId;
        this.organizationId = organizationId;
        this.userType = userType;
        this.userLanguage = userLanguage;
        this.userTaskContext = userTaskContext;
        this.setting = setting;
        this.settingContext = settingContext;
        this.parameters = parameters;
        if (prefetchData != null && !prefetchData.isEmpty()) {
            if (data == null) {
                data = BundleHelper.newBundle((FhirVersionEnum)this.fhirVersion);
            }
            this.resolvePrefetchData(data, prefetchData);
        }
        this.data = data;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
        this.inputParameterResolver = inputParameterResolver != null ? inputParameterResolver : IInputParameterResolver.createResolver(libraryEngine.getRepository(), this.subjectId, this.encounterId, this.practitionerId, this.parameters, this.data);
        this.referencedLibraries = this.planDefinitionAdapter.getReferencedLibraries();
        this.requestResources = new ArrayList<IBaseResource>();
        this.extractedResources = new ArrayList<IBaseResource>();
        this.containResources = false;
    }

    public ApplyRequest copy(IBaseResource planDefinition) {
        return new ApplyRequest(planDefinition, this.subjectId, this.encounterId, this.practitionerId, this.organizationId, this.userType, this.userLanguage, this.userTaskContext, this.setting, this.settingContext, this.parameters, this.data, null, this.libraryEngine, this.modelResolver, this.inputParameterResolver).setQuestionnaire(this.questionnaire).setContainResources(this.containResources);
    }

    public org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyRequest toActivityRequest(IBaseResource activityDefinition) {
        return new org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyRequest(activityDefinition, this.getSubjectId(), this.getEncounterId(), this.getPractitionerId(), this.getOrganizationId(), this.getUserType(), this.getUserLanguage(), this.getUserTaskContext(), this.getSetting(), this.getSettingContext(), this.getParameters(), this.getData(), this.libraryEngine, this.modelResolver);
    }

    public GenerateRequest toGenerateRequest(IBaseResource profile) {
        return new GenerateRequest(profile, false, true, this.libraryEngine, this.modelResolver).setReferencedLibraries(this.referencedLibraries).setQuestionnaire(this.questionnaire);
    }

    public PopulateRequest toPopulateRequest() {
        ArrayList context = new ArrayList();
        List launchContextExts = this.getQuestionnaireAdapter().getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext");
        launchContextExts.forEach(lc -> {
            String code = lc.getExtension().stream().map(c -> (IBaseExtension)c).filter(c -> c.getUrl().equals("name")).map(c -> this.resolvePathString((IBase)c.getValue(), "code").toUpperCase()).findFirst().orElse(null);
            String value = null;
            switch (Constants.SDC_QUESTIONNAIRE_LAUNCH_CONTEXT_CODE.valueOf((String)code)) {
                case PATIENT: {
                    value = this.subjectId.getValue();
                    break;
                }
                case ENCOUNTER: {
                    value = this.encounterId.getValue();
                    break;
                }
                case USER: {
                    value = this.practitionerId.getValue();
                    break;
                }
            }
            context.add((IBaseBackboneElement)org.opencds.cqf.fhir.utility.Parameters.newPart((FhirContext)this.getFhirContext(), (String)"context", (IBase[])new IBase[]{org.opencds.cqf.fhir.utility.Parameters.newStringPart((FhirContext)this.getFhirContext(), (String)"name", (String)code, (IBase[])new IBase[0]), org.opencds.cqf.fhir.utility.Parameters.newPart((FhirContext)this.getFhirContext(), (String)"Reference", (String)"content", (Object)value, (IBase[])new IBase[0])}));
        });
        return new PopulateRequest(this.questionnaire, this.subjectId, context, null, this.parameters, this.data, this.libraryEngine, this.modelResolver);
    }

    public IBaseResource getPlanDefinition() {
        return this.planDefinitionAdapter.get();
    }

    @Override
    public IIdType getSubjectId() {
        return this.subjectId;
    }

    @Override
    public IIdType getPractitionerId() {
        return this.practitionerId;
    }

    @Override
    public IIdType getEncounterId() {
        return this.encounterId;
    }

    @Override
    public IIdType getOrganizationId() {
        return this.organizationId;
    }

    @Override
    public IBaseDatatype getUserType() {
        return this.userType;
    }

    @Override
    public IBaseDatatype getUserLanguage() {
        return this.userLanguage;
    }

    @Override
    public IBaseDatatype getUserTaskContext() {
        return this.userTaskContext;
    }

    @Override
    public IBaseDatatype getSetting() {
        return this.setting;
    }

    @Override
    public IBaseDatatype getSettingContext() {
        return this.settingContext;
    }

    @Override
    public IBaseBundle getData() {
        return this.data;
    }

    @Override
    public IBaseParameters getParameters() {
        return this.inputParameterResolver.getParameters();
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public Map<String, String> getReferencedLibraries() {
        return this.referencedLibraries;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        return this.operationOutcome;
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        this.operationOutcome = operationOutcome;
    }

    @Override
    public String getOperationName() {
        return "apply";
    }

    @Override
    public IBase getContextVariable() {
        return this.getPlanDefinition();
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return this.questionnaire;
    }

    @Override
    public IQuestionnaireAdapter getQuestionnaireAdapter() {
        if (this.questionnaireAdapter == null && this.questionnaire != null) {
            this.questionnaireAdapter = (IQuestionnaireAdapter)this.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)this.questionnaire);
        }
        return this.questionnaireAdapter;
    }

    public ApplyRequest setQuestionnaire(IBaseResource questionnaire) {
        this.questionnaire = questionnaire;
        return this;
    }

    public ApplyRequest setData(IBaseBundle bundle) {
        this.data = bundle;
        return this;
    }

    public ApplyRequest setContainResources(Boolean value) {
        this.containResources = value;
        return this;
    }

    public Boolean getContainResources() {
        return this.containResources;
    }

    public Collection<IBaseResource> getRequestResources() {
        return this.requestResources;
    }

    public Collection<IBaseResource> getExtractedResources() {
        return this.extractedResources;
    }

    public <T extends ICompositeType> IBaseParameters resolveInputParameters(List<T> input) {
        return this.inputParameterResolver.resolveInputParameters(input);
    }

    public IBaseParameters transformRequestParameters(IBaseResource resource) {
        return switch (this.getFhirVersion()) {
            case FhirVersionEnum.DSTU3 -> this.transformRequestParametersDstu3(resource);
            case FhirVersionEnum.R4 -> this.transformRequestParametersR4(resource);
            case FhirVersionEnum.R5 -> this.transformRequestParametersR5(resource);
            default -> null;
        };
    }

    protected IBaseParameters transformRequestParametersDstu3(IBaseResource resource) {
        String resourceParameter = resource.fhirType().equals(ACTIVITY_DEFINITION) ? "activityDefinition" : "planDefinition";
        org.hl7.fhir.dstu3.model.Parameters params = Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]).addParameter(Parameters.part((String)resourceParameter, (Resource)((Resource)resource), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])).addParameter(Parameters.part((String)"subject", (String)this.getSubjectId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        if (this.hasEncounterId()) {
            params.addParameter(Parameters.part((String)"encounter", (String)this.getEncounterId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.hasPractitionerId()) {
            params.addParameter(Parameters.part((String)"practitioner", (String)this.getPractitionerId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.hasOrganizationId()) {
            params.addParameter(Parameters.part((String)"organization", (String)this.getOrganizationId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.getParameters() != null) {
            params.addParameter(Parameters.part((String)"parameters", (Resource)((org.hl7.fhir.dstu3.model.Parameters)this.getParameters()), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.getData() != null) {
            params.addParameter(Parameters.part((String)"data", (Resource)((Resource)this.getData()), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        return params;
    }

    protected IBaseParameters transformRequestParametersR4(IBaseResource resource) {
        String resourceParameter = resource.fhirType().equals(ACTIVITY_DEFINITION) ? "activityDefinition" : "planDefinition";
        org.hl7.fhir.r4.model.Parameters params = org.opencds.cqf.fhir.utility.r4.Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]).addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)resourceParameter, (org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Resource)resource), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])).addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)"subject", (String)this.getSubjectId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        if (this.hasEncounterId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)"encounter", (String)this.getEncounterId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.hasPractitionerId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)"practitioner", (String)this.getPractitionerId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.hasOrganizationId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)"organization", (String)this.getOrganizationId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.getParameters() != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)"parameters", (org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Parameters)this.getParameters()), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.getData() != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.r4.Parameters.part((String)"data", (org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Resource)this.getData()), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        return params;
    }

    protected IBaseParameters transformRequestParametersR5(IBaseResource resource) {
        String resourceParameter = resource.fhirType().equals(ACTIVITY_DEFINITION) ? "activityDefinition" : "planDefinition";
        org.hl7.fhir.r5.model.Parameters params = org.opencds.cqf.fhir.utility.r5.Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]).addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)resourceParameter, (org.hl7.fhir.r5.model.Resource)((org.hl7.fhir.r5.model.Resource)resource), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])).addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"subject", (String)this.getSubjectId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        if (this.hasEncounterId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"encounter", (String)this.getEncounterId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.hasPractitionerId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"practitioner", (String)this.getPractitionerId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.hasOrganizationId()) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"organization", (String)this.getOrganizationId().getValue(), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.getParameters() != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"parameters", (org.hl7.fhir.r5.model.Resource)((org.hl7.fhir.r5.model.Parameters)this.getParameters()), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.getData() != null) {
            params.addParameter(org.opencds.cqf.fhir.utility.r5.Parameters.part((String)"data", (org.hl7.fhir.r5.model.Resource)((org.hl7.fhir.r5.model.Resource)this.getData()), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        return params;
    }
}

