/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.repository.IRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.RequestGroup;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.RequestGroup;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.opencds.cqf.fhir.cr.common.DynamicValueProcessor;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.ExtensionProcessor;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyProcessor;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ProcessDefinition;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.utility.Constants;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessAction {
    private static final Logger logger = LoggerFactory.getLogger(ProcessAction.class);
    final IRepository repository;
    final ProcessDefinition processDefinition;
    final GenerateProcessor generateProcessor;
    final ExtensionProcessor extensionProcessor;
    final ExpressionProcessor expressionProcessor;
    final DynamicValueProcessor dynamicValueProcessor;

    public ProcessAction(IRepository repository, ApplyProcessor applyProcessor, GenerateProcessor generateProcessor) {
        this.repository = repository;
        this.generateProcessor = generateProcessor;
        this.processDefinition = new ProcessDefinition(repository, applyProcessor);
        this.extensionProcessor = new ExtensionProcessor();
        this.expressionProcessor = new ExpressionProcessor();
        this.dynamicValueProcessor = new DynamicValueProcessor();
    }

    public IBaseBackboneElement processAction(ApplyRequest request, IBaseResource requestOrchestration, Map<String, IBaseBackboneElement> metConditions, IBaseBackboneElement action) {
        if (!request.getFhirVersion().equals((Object)FhirVersionEnum.DSTU3) && request.getQuestionnaire() != null) {
            this.addQuestionnaireItemForInput(request, action);
        }
        if (Boolean.TRUE.equals(this.meetsConditions(request, action))) {
            metConditions.put(request.resolvePathString((IBase)action, "id"), action);
            IBaseBackboneElement requestAction = this.generateRequestAction(request.getFhirVersion(), action);
            this.extensionProcessor.processExtensions(request, (IBase)requestAction, (IElement)action, new ArrayList<String>());
            this.processChildActions(request, requestOrchestration, metConditions, action, requestAction);
            IBaseResource resource = this.processDefinition.resolveDefinition(request, requestOrchestration, action, requestAction);
            this.dynamicValueProcessor.processDynamicValues(request, request.getPlanDefinition(), resource, (IElement)action, (IElement)requestAction);
            return requestAction;
        }
        return null;
    }

    protected void processChildActions(ApplyRequest request, IBaseResource requestOrchestration, Map<String, IBaseBackboneElement> metConditions, IBaseBackboneElement action, IBaseBackboneElement requestAction) {
        Object object;
        List<IBaseBackboneElement> childActions = request.resolvePathList((IBase)action, "action", IBaseBackboneElement.class);
        if (childActions.isEmpty()) {
            return;
        }
        Constants.CqfApplicabilityBehavior applicabilityBehavior = Constants.CqfApplicabilityBehavior.ALL;
        Object applicabilityBehaviorExt = request.getExtensionByUrl((IBase)action, "http://hl7.org/fhir/StructureDefinition/cqf-applicabilityBehavior");
        if (applicabilityBehaviorExt != null && (object = applicabilityBehaviorExt.getValue()) instanceof IPrimitiveType) {
            IPrimitiveType primitiveType = (IPrimitiveType)object;
            try {
                applicabilityBehavior = Constants.CqfApplicabilityBehavior.valueOf((String)primitiveType.getValueAsString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                String message = "Encountered invalid value for applicabilityBehavior extension %s.  Expected `all` or `any`.".formatted(primitiveType.getValueAsString());
                logger.error(message);
                request.logException(message);
            }
        }
        int metConditionsCount = metConditions.size();
        for (IBaseBackboneElement childAction : childActions) {
            IBaseBackboneElement childRequestAction = this.processAction(request, requestOrchestration, metConditions, childAction);
            if (childRequestAction != null) {
                request.getModelResolver().setValue((Object)requestAction, "action", Collections.singletonList(childRequestAction));
            }
            if (!applicabilityBehavior.equals((Object)Constants.CqfApplicabilityBehavior.ANY) || metConditionsCount >= metConditions.size()) continue;
            break;
        }
    }

    protected void addQuestionnaireItemForInput(ApplyRequest request, IBaseBackboneElement action) {
        try {
            List<IElement> actionInput = request.resolvePathList((IBase)action, "input", IElement.class);
            for (IElement input : actionInput) {
                ICompositeType dataReqElement = this.getDataRequirementElement(request, input);
                List<IPrimitiveType> profiles = request.resolvePathList((IBase)dataReqElement, "profile", IPrimitiveType.class);
                if (profiles.isEmpty()) {
                    return;
                }
                IBaseResource profile = SearchHelper.searchRepositoryByCanonical((IRepository)this.repository, (IPrimitiveType)profiles.get(0));
                GenerateRequest generateRequest = request.toGenerateRequest(profile);
                Pair item = this.generateProcessor.generateItem(generateRequest);
                if (item == null) continue;
                if (request.hasExtension((IBase)input, "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-input-text")) {
                    IPrimitiveType itemText = (IPrimitiveType)request.getExtensionByUrl((IBase)input, "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-input-text").getValue();
                    request.getModelResolver().setValue(item.getLeft(), "text", (Object)itemText);
                }
                request.addQuestionnaireItem((IBaseBackboneElement)item.getLeft());
                request.addLaunchContextExtensions((List)item.getRight());
            }
        }
        catch (Exception e) {
            String message = "An error occurred while generating Questionnaire items for action input: %s".formatted(e.getMessage());
            request.logException(message);
        }
    }

    protected ICompositeType getDataRequirementElement(ApplyRequest request, IElement input) {
        return (ICompositeType)(request.getFhirVersion().isEqualOrNewerThan(FhirVersionEnum.R5) ? request.resolvePath((IBase)input, "requirement") : input);
    }

    protected IBaseParameters resolveInputParameters(ApplyRequest request, IBaseBackboneElement action) {
        List<IElement> actionInput = request.resolvePathList((IBase)action, "input", IElement.class);
        return request.resolveInputParameters(actionInput.stream().map(input -> this.getDataRequirementElement(request, (IElement)input)).collect(Collectors.toList()));
    }

    protected Boolean meetsConditions(ApplyRequest request, IBaseBackboneElement action) {
        List<IBaseBackboneElement> conditions = request.resolvePathList((IBase)action, "condition", IBaseBackboneElement.class).stream().filter(c -> "applicability".equals(request.resolvePathString((IBase)c, "kind"))).toList();
        if (conditions.isEmpty()) {
            return true;
        }
        IBaseParameters inputParams = this.resolveInputParameters(request, action);
        for (IBaseBackboneElement condition : conditions) {
            CqfExpression conditionExpression = this.expressionProcessor.getCqfExpressionForElement(request, condition);
            if (conditionExpression == null) continue;
            IBase result = null;
            try {
                List<IBase> expressionResult = this.expressionProcessor.getExpressionResult(request, conditionExpression, inputParams, null);
                result = expressionResult.isEmpty() ? null : expressionResult.get(0);
            }
            catch (Exception e) {
                String message = "Condition expression %s encountered exception: %s".formatted(conditionExpression.getExpression(), e.getMessage());
                logger.error(message);
                request.logException(message);
            }
            boolean valid = this.validateResult(result, conditionExpression.getExpression());
            if (!valid) {
                return false;
            }
            logger.debug("The result of condition expression {} is true", (Object)conditionExpression.getExpression());
        }
        return true;
    }

    protected boolean validateResult(IBase result, String expression) {
        if (result == null) {
            logger.warn("Condition expression {} returned null", (Object)expression);
            return false;
        }
        if (!(result instanceof IBaseBooleanDatatype)) {
            logger.warn("Condition expression {} returned a non-boolean value: {}", (Object)expression, (Object)result.getClass().getSimpleName());
            return false;
        }
        if (Boolean.FALSE.equals(((IBaseBooleanDatatype)result).getValue())) {
            logger.debug("The result of condition expression {} is false", (Object)expression);
            return false;
        }
        return true;
    }

    protected IBaseBackboneElement generateRequestAction(FhirVersionEnum fhirVersion, IBaseBackboneElement action) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> this.generateRequestActionDstu3(action);
            case FhirVersionEnum.R4 -> this.generateRequestActionR4(action);
            case FhirVersionEnum.R5 -> this.generateRequestActionR5(action);
            default -> null;
        };
    }

    protected IBaseBackboneElement generateRequestActionDstu3(IBaseBackboneElement a) {
        PlanDefinition.PlanDefinitionActionComponent action = (PlanDefinition.PlanDefinitionActionComponent)a;
        RequestGroup.RequestGroupActionComponent requestAction = new RequestGroup.RequestGroupActionComponent().setTitle(action.getTitle()).setDescription(action.getDescription()).setTextEquivalent(action.getTextEquivalent()).setCode(action.getCode()).setDocumentation(action.getDocumentation()).setTiming(action.getTiming()).setType(action.getType());
        requestAction.setId(action.getId());
        if (action.hasCondition()) {
            action.getCondition().forEach(c -> requestAction.addCondition(new RequestGroup.RequestGroupActionConditionComponent().setKind(RequestGroup.ActionConditionKind.fromCode((String)c.getKind().toCode())).setExpression(c.getExpression())));
        }
        if (action.hasRelatedAction()) {
            action.getRelatedAction().forEach(ra -> requestAction.addRelatedAction(new RequestGroup.RequestGroupActionRelatedActionComponent().setActionId(ra.getActionId()).setRelationship(RequestGroup.ActionRelationshipType.fromCode((String)ra.getRelationship().toCode())).setOffset(ra.getOffset())));
        }
        if (action.hasSelectionBehavior()) {
            requestAction.setSelectionBehavior(RequestGroup.ActionSelectionBehavior.fromCode((String)action.getSelectionBehavior().toCode()));
        }
        return requestAction;
    }

    protected IBaseBackboneElement generateRequestActionR4(IBaseBackboneElement a) {
        PlanDefinition.PlanDefinitionActionComponent action = (PlanDefinition.PlanDefinitionActionComponent)a;
        RequestGroup.RequestGroupActionComponent requestAction = new RequestGroup.RequestGroupActionComponent().setTitle(action.getTitle()).setDescription(action.getDescription()).setTextEquivalent(action.getTextEquivalent()).setCode(action.getCode()).setDocumentation(action.getDocumentation()).setTiming(action.getTiming()).setType(action.getType());
        requestAction.setId(action.getId());
        if (action.hasCondition()) {
            action.getCondition().forEach(c -> requestAction.addCondition(new RequestGroup.RequestGroupActionConditionComponent().setKind(RequestGroup.ActionConditionKind.fromCode((String)c.getKind().toCode())).setExpression(c.getExpression())));
        }
        if (action.hasPriority()) {
            requestAction.setPriority(RequestGroup.RequestPriority.fromCode((String)action.getPriority().toCode()));
        }
        if (action.hasRelatedAction()) {
            action.getRelatedAction().forEach(ra -> requestAction.addRelatedAction(new RequestGroup.RequestGroupActionRelatedActionComponent().setActionId(ra.getActionId()).setRelationship(RequestGroup.ActionRelationshipType.fromCode((String)ra.getRelationship().toCode())).setOffset(ra.getOffset())));
        }
        if (action.hasSelectionBehavior()) {
            requestAction.setSelectionBehavior(RequestGroup.ActionSelectionBehavior.fromCode((String)action.getSelectionBehavior().toCode()));
        }
        return requestAction;
    }

    protected IBaseBackboneElement generateRequestActionR5(IBaseBackboneElement a) {
        PlanDefinition.PlanDefinitionActionComponent action = (PlanDefinition.PlanDefinitionActionComponent)a;
        RequestOrchestration.RequestOrchestrationActionComponent requestAction = new RequestOrchestration.RequestOrchestrationActionComponent().setTitle(action.getTitle()).setDescription(action.getDescription()).setTextEquivalent(action.getTextEquivalent()).addCode(action.getCode()).setDocumentation(action.getDocumentation()).setTiming(action.getTiming()).setType(action.getType());
        requestAction.setId(action.getId());
        if (action.hasCondition()) {
            action.getCondition().forEach(c -> requestAction.addCondition(new RequestOrchestration.RequestOrchestrationActionConditionComponent().setKind(Enumerations.ActionConditionKind.fromCode((String)c.getKind().toCode())).setExpression(c.getExpression())));
        }
        if (action.hasPriority()) {
            requestAction.setPriority(Enumerations.RequestPriority.fromCode((String)action.getPriority().toCode()));
        }
        if (action.hasRelatedAction()) {
            action.getRelatedAction().forEach(ra -> requestAction.addRelatedAction(new RequestOrchestration.RequestOrchestrationActionRelatedActionComponent().setTargetId(ra.getTargetId()).setRelationship(Enumerations.ActionRelationshipType.fromCode((String)ra.getRelationship().toCode())).setOffset(ra.getOffset())));
        }
        if (action.hasSelectionBehavior()) {
            requestAction.setSelectionBehavior(Enumerations.ActionSelectionBehavior.fromCode((String)action.getSelectionBehavior().toCode()));
        }
        return requestAction;
    }
}

