/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Enumerations;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ActionResolver;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyProcessor;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinition {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDefinition.class);
    final IRepository repository;
    final ApplyProcessor applyProcessor;
    final ActionResolver actionResolver;

    public ProcessDefinition(IRepository repository, ApplyProcessor applyProcessor) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(applyProcessor);
        this.repository = repository;
        this.applyProcessor = applyProcessor;
        this.actionResolver = new ActionResolver();
    }

    public IBaseResource resolveDefinition(ApplyRequest request, IBaseResource requestOrchestration, IBaseBackboneElement action, IBaseBackboneElement requestAction) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(requestOrchestration);
        Objects.requireNonNull(action);
        Objects.requireNonNull(requestAction);
        IBaseResource resource = null;
        IPrimitiveType<String> definition = this.getDefinition(request, action);
        if (Boolean.TRUE.equals(this.isDefinitionCanonical(request, (IBase)definition))) {
            resource = this.resolveDefinition(request, definition);
            if (resource != null) {
                String actionId = request.resolvePathString((IBase)action, "id");
                if (actionId != null) {
                    resource.setId("%s-%s".formatted(actionId, resource.getIdElement().getIdPart()));
                }
                this.actionResolver.resolveAction(request, requestOrchestration, resource, action);
                String reference = Boolean.TRUE.equals(request.getContainResources()) ? "#%s".formatted(resource.getIdElement().getIdPart()) : resource.getIdElement().getValue();
                request.getModelResolver().setValue((Object)requestAction, "resource", (Object)ExtensionBuilders.buildReference(request.getFhirVersion(), reference));
                if (Boolean.TRUE.equals(request.getContainResources())) {
                    request.getModelResolver().setValue((Object)requestOrchestration, "contained", Collections.singletonList(resource));
                } else {
                    request.getRequestResources().add(resource);
                }
            }
        } else if (Boolean.TRUE.equals(this.isDefinitionUri(request, (IBase)definition))) {
            request.getModelResolver().setValue((Object)requestAction, "resource", (Object)ExtensionBuilders.buildReference(request.getFhirVersion(), (String)definition.getValue()));
        }
        return resource;
    }

    protected IPrimitiveType<String> getDefinition(ApplyRequest request, IBaseBackboneElement action) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(action);
        return request.getFhirVersion().isOlderThan(FhirVersionEnum.R4) ? request.resolvePath(request.resolvePath((IBase)action, "definition"), "reference", IPrimitiveType.class) : request.resolvePath((IBase)action, "definition", IPrimitiveType.class);
    }

    protected IBaseResource resolveDefinition(ApplyRequest request, IPrimitiveType<String> definition) {
        Objects.requireNonNull(definition);
        logger.debug("Resolving definition {}", definition.getValue());
        String resourceName = this.resolveResourceName(request, definition);
        return switch (Enumerations.FHIRTypes.fromCode((String)Objects.requireNonNull(resourceName))) {
            case Enumerations.FHIRTypes.PLANDEFINITION -> this.applyNestedPlanDefinition(request, definition);
            case Enumerations.FHIRTypes.ACTIVITYDEFINITION -> this.applyActivityDefinition(request, definition);
            case Enumerations.FHIRTypes.QUESTIONNAIRE -> this.applyQuestionnaireDefinition(request, definition);
            default -> throw new FHIRException("Unknown action definition: %s".formatted(definition.getValue()));
        };
    }

    protected Boolean isDefinitionCanonical(ApplyRequest request, IBase definition) {
        Objects.requireNonNull(request);
        return switch (request.getFhirVersion()) {
            case FhirVersionEnum.R4 -> definition instanceof CanonicalType;
            case FhirVersionEnum.R5 -> definition instanceof org.hl7.fhir.r5.model.CanonicalType;
            default -> definition != null;
        };
    }

    protected Boolean isDefinitionUri(ApplyRequest request, IBase definition) {
        Objects.requireNonNull(request);
        return switch (request.getFhirVersion()) {
            case FhirVersionEnum.R4 -> definition instanceof UriType;
            case FhirVersionEnum.R5 -> definition instanceof org.hl7.fhir.r5.model.UriType;
            default -> Boolean.FALSE;
        };
    }

    protected IBaseResource applyQuestionnaireDefinition(ApplyRequest request, IPrimitiveType<String> definition) {
        Objects.requireNonNull(definition);
        IBaseResource result = null;
        try {
            boolean referenceToContained = ((String)definition.getValue()).startsWith("#");
            result = referenceToContained ? this.resolveContained(request, (String)definition.getValue()) : this.resolveRepository(definition);
        }
        catch (Exception e) {
            String message = "ERROR: Questionnaire %s could not be applied and threw exception %s".formatted(definition.getValue(), e.toString());
            logger.error(message);
            request.logException(message);
        }
        return result;
    }

    protected IBaseResource applyActivityDefinition(ApplyRequest request, IPrimitiveType<String> definition) {
        Objects.requireNonNull(definition);
        IBaseResource result = null;
        try {
            boolean referenceToContained = ((String)definition.getValue()).startsWith("#");
            IBaseResource activityDefinition = referenceToContained ? this.resolveContained(request, (String)definition.getValue()) : this.resolveRepository(definition);
            org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyRequest activityRequest = request.toActivityRequest(activityDefinition);
            result = this.applyProcessor.applyActivityDefinition(activityRequest);
            IIdType activityDefinitionId = referenceToContained ? Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)result.fhirType(), (String)activityDefinition.getIdElement().getIdPart().replaceFirst("#", "")) : activityDefinition.getIdElement().withResourceType(result.fhirType());
            result.setId(activityDefinitionId);
            activityRequest.resolveOperationOutcome(result);
        }
        catch (Exception e) {
            String message = "ERROR: ActivityDefinition %s could not be applied and threw exception %s".formatted(definition.getValue(), e.toString());
            logger.error(message);
            request.logException(message);
        }
        return result;
    }

    protected IBaseResource applyNestedPlanDefinition(ApplyRequest request, IPrimitiveType<String> definition) {
        Objects.requireNonNull(definition);
        try {
            boolean referenceToContained = ((String)definition.getValue()).startsWith("#");
            IBaseResource nextPlanDefinition = referenceToContained ? this.resolveContained(request, (String)definition.getValue()) : this.resolveRepository(definition);
            ApplyRequest nestedRequest = request.copy(nextPlanDefinition);
            IBaseResource result = this.applyProcessor.applyPlanDefinition(nestedRequest);
            nestedRequest.resolveOperationOutcome(result);
            request.getRequestResources().addAll(nestedRequest.getRequestResources());
            request.getExtractedResources().addAll(nestedRequest.getExtractedResources());
            request.setQuestionnaire(nestedRequest.getQuestionnaire());
            return result;
        }
        catch (Exception e) {
            String message = "ERROR: PlanDefinition %s could not be applied and threw exception %s".formatted(definition.getValue(), e.toString());
            logger.error(message);
            request.logException(message);
            return null;
        }
    }

    protected IBaseResource resolveRepository(IPrimitiveType<String> definition) {
        return SearchHelper.searchRepositoryByCanonical((IRepository)this.repository, definition);
    }

    protected String resolveResourceName(ApplyRequest request, IPrimitiveType<String> canonical) {
        Objects.requireNonNull(canonical);
        if (canonical.hasValue()) {
            String id = (String)canonical.getValue();
            if (id.contains("/")) {
                return (id = id.replace(id.substring(id.lastIndexOf("/")), "")).contains("/") ? id.substring(id.lastIndexOf("/") + 1) : id;
            }
            if (id.startsWith("#")) {
                return this.resolveContained(request, id).fhirType();
            }
            return null;
        }
        throw new FHIRException("CanonicalType must have a value for resource name extraction");
    }

    protected IBaseResource resolveContained(ApplyRequest request, String id) {
        Objects.requireNonNull(id);
        List<IBaseResource> contained = request.resolvePathList((IBase)request.getPlanDefinition(), "contained", IBaseResource.class);
        String containedId = this.getContainedId(id);
        Optional<IBaseResource> first = contained.stream().filter(r -> this.getContainedId(r.getIdElement().getIdPart()).equals(containedId)).findFirst();
        return first.orElse(null);
    }

    private String getContainedId(String id) {
        return id.replaceFirst("#", "");
    }
}

