/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.RequestGroup;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.RequestGroup;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.cr.questionnaire.populate.IPopulateProcessor;
import org.opencds.cqf.fhir.utility.Ids;

public class ResponseBuilder {
    protected final IPopulateProcessor populateProcessor;

    public ResponseBuilder(IPopulateProcessor populateProcessor) {
        this.populateProcessor = populateProcessor;
    }

    public IBaseResource generateRequestOrchestration(ApplyRequest request) {
        return switch (request.getFhirVersion()) {
            case FhirVersionEnum.DSTU3 -> this.generateOrchestrationDstu3(request);
            case FhirVersionEnum.R4 -> this.generateOrchestrationR4(request);
            case FhirVersionEnum.R5 -> this.generateOrchestrationR5(request);
            default -> null;
        };
    }

    protected String getCanonical(String url, String version) {
        return StringUtils.isBlank((CharSequence)version) ? url : "%s|%s".formatted(url, version);
    }

    protected IBaseResource generateOrchestrationDstu3(ApplyRequest request) {
        IBaseDatatype iBaseDatatype;
        org.hl7.fhir.dstu3.model.PlanDefinition planDefinition = (org.hl7.fhir.dstu3.model.PlanDefinition)request.getPlanDefinition();
        String canonical = this.getCanonical(planDefinition.getUrl(), planDefinition.getVersion());
        org.hl7.fhir.dstu3.model.RequestGroup requestOrchestration = new org.hl7.fhir.dstu3.model.RequestGroup().setStatus(RequestGroup.RequestStatus.ACTIVE).setIntent(RequestGroup.RequestIntent.PROPOSAL).addDefinition(new org.hl7.fhir.dstu3.model.Reference(canonical)).setSubject(new org.hl7.fhir.dstu3.model.Reference(request.getSubjectId()));
        IIdType requestId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)requestOrchestration.fhirType(), (String)planDefinition.getIdElement().getIdPart());
        requestOrchestration.setId(requestId);
        if (request.hasEncounterId()) {
            requestOrchestration.setContext(new org.hl7.fhir.dstu3.model.Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId()) {
            requestOrchestration.setAuthor(new org.hl7.fhir.dstu3.model.Reference(request.getPractitionerId()));
        }
        if (request.hasOrganizationId()) {
            requestOrchestration.setAuthor(new org.hl7.fhir.dstu3.model.Reference(request.getOrganizationId()));
        }
        if ((iBaseDatatype = request.getUserLanguage()) instanceof org.hl7.fhir.dstu3.model.CodeableConcept) {
            org.hl7.fhir.dstu3.model.CodeableConcept userLanguage = (org.hl7.fhir.dstu3.model.CodeableConcept)iBaseDatatype;
            requestOrchestration.setLanguage(userLanguage.getCodingFirstRep().getCode());
        }
        return requestOrchestration;
    }

    protected IBaseResource generateOrchestrationR4(ApplyRequest request) {
        IBaseDatatype iBaseDatatype;
        org.hl7.fhir.r4.model.PlanDefinition planDefinition = (org.hl7.fhir.r4.model.PlanDefinition)request.getPlanDefinition();
        String canonical = this.getCanonical(planDefinition.getUrl(), planDefinition.getVersion());
        RequestGroup requestOrchestration = new RequestGroup().setStatus(RequestGroup.RequestStatus.ACTIVE).setIntent(RequestGroup.RequestIntent.PROPOSAL).addInstantiatesCanonical(canonical).setSubject(new org.hl7.fhir.r4.model.Reference(request.getSubjectId()));
        IIdType requestId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)requestOrchestration.fhirType(), (String)planDefinition.getIdElement().getIdPart());
        requestOrchestration.setId(requestId);
        if (request.hasEncounterId()) {
            requestOrchestration.setEncounter(new org.hl7.fhir.r4.model.Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId()) {
            requestOrchestration.setAuthor(new org.hl7.fhir.r4.model.Reference(request.getPractitionerId()));
        }
        if (request.hasOrganizationId()) {
            requestOrchestration.setAuthor(new org.hl7.fhir.r4.model.Reference(request.getOrganizationId()));
        }
        if ((iBaseDatatype = request.getUserLanguage()) instanceof org.hl7.fhir.r4.model.CodeableConcept) {
            org.hl7.fhir.r4.model.CodeableConcept userLanguage = (org.hl7.fhir.r4.model.CodeableConcept)iBaseDatatype;
            requestOrchestration.setLanguage(userLanguage.getCodingFirstRep().getCode());
        }
        return requestOrchestration;
    }

    protected IBaseResource generateOrchestrationR5(ApplyRequest request) {
        IBaseDatatype iBaseDatatype;
        PlanDefinition planDefinition = (PlanDefinition)request.getPlanDefinition();
        String canonical = this.getCanonical(planDefinition.getUrl(), planDefinition.getVersion());
        RequestOrchestration requestOrchestration = new RequestOrchestration().setStatus(Enumerations.RequestStatus.ACTIVE).setIntent(Enumerations.RequestIntent.PROPOSAL).addInstantiatesCanonical(canonical).setSubject(new Reference(request.getSubjectId()));
        IIdType requestId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)requestOrchestration.fhirType(), (String)planDefinition.getIdElement().getIdPart());
        requestOrchestration.setId(requestId);
        if (request.hasEncounterId()) {
            requestOrchestration.setEncounter(new Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId()) {
            requestOrchestration.setAuthor(new Reference(request.getPractitionerId()));
        }
        if (request.hasOrganizationId()) {
            requestOrchestration.setAuthor(new Reference(request.getOrganizationId()));
        }
        if ((iBaseDatatype = request.getUserLanguage()) instanceof CodeableConcept) {
            CodeableConcept userLanguage = (CodeableConcept)iBaseDatatype;
            requestOrchestration.setLanguage(userLanguage.getCodingFirstRep().getCode());
        }
        return requestOrchestration;
    }

    public IBaseResource generateCarePlan(ApplyRequest request, IBaseResource requestOrchestration) {
        return switch (request.getFhirVersion()) {
            case FhirVersionEnum.DSTU3 -> this.generateCarePlanDstu3(request, requestOrchestration);
            case FhirVersionEnum.R4 -> this.generateCarePlanR4(request, requestOrchestration);
            case FhirVersionEnum.R5 -> this.generateCarePlanR5(request, requestOrchestration);
            default -> null;
        };
    }

    protected IBaseResource generateCarePlanDstu3(ApplyRequest request, IBaseResource ro) {
        org.hl7.fhir.dstu3.model.RequestGroup requestOrchestration = (org.hl7.fhir.dstu3.model.RequestGroup)ro;
        org.hl7.fhir.dstu3.model.CarePlan carePlan = new org.hl7.fhir.dstu3.model.CarePlan().setDefinition(requestOrchestration.getDefinition()).setSubject(requestOrchestration.getSubject()).setStatus(CarePlan.CarePlanStatus.ACTIVE).setIntent(CarePlan.CarePlanIntent.PROPOSAL);
        IIdType carePlanId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)carePlan.fhirType(), (String)requestOrchestration.getIdElement().getIdPart());
        carePlan.setId(carePlanId);
        if (request.hasEncounterId()) {
            carePlan.setContext(requestOrchestration.getContext());
        }
        if (request.hasPractitionerId()) {
            carePlan.setAuthor(Collections.singletonList(requestOrchestration.getAuthor()));
        }
        if (requestOrchestration.getLanguage() != null) {
            carePlan.setLanguage(requestOrchestration.getLanguage());
        }
        for (IBaseResource goal : request.getRequestResources()) {
            if (!goal.fhirType().equals(org.hl7.fhir.dstu3.model.ResourceType.Goal.name())) continue;
            carePlan.addGoal(new org.hl7.fhir.dstu3.model.Reference((IAnyResource)((org.hl7.fhir.dstu3.model.Resource)goal)));
        }
        List<IBaseResource> operationOutcomes = request.getContained((IBaseResource)requestOrchestration).stream().filter(r -> r.fhirType().equals(org.hl7.fhir.dstu3.model.ResourceType.OperationOutcome.name())).toList();
        for (IBaseResource operationOutcome : operationOutcomes) {
            carePlan.addExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages", (Type)new org.hl7.fhir.dstu3.model.Reference("#" + operationOutcome.getIdElement().getIdPart()));
        }
        carePlan.addActivity().setReference(new org.hl7.fhir.dstu3.model.Reference("#" + requestOrchestration.getIdPart()));
        carePlan.addContained((org.hl7.fhir.dstu3.model.Resource)requestOrchestration);
        for (IBaseResource resource : request.getExtractedResources()) {
            carePlan.addSupportingInfo(new org.hl7.fhir.dstu3.model.Reference((IAnyResource)((org.hl7.fhir.dstu3.model.Resource)resource)));
            carePlan.addContained((org.hl7.fhir.dstu3.model.Resource)resource);
        }
        return carePlan;
    }

    protected IBaseResource generateCarePlanR4(ApplyRequest request, IBaseResource ro) {
        RequestGroup requestOrchestration = (RequestGroup)ro;
        org.hl7.fhir.r4.model.CarePlan carePlan = new org.hl7.fhir.r4.model.CarePlan().setInstantiatesCanonical(requestOrchestration.getInstantiatesCanonical()).setSubject(requestOrchestration.getSubject()).setStatus(CarePlan.CarePlanStatus.ACTIVE).setIntent(CarePlan.CarePlanIntent.PROPOSAL);
        IIdType carePlanId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)carePlan.fhirType(), (String)requestOrchestration.getIdElement().getIdPart());
        carePlan.setId(carePlanId);
        if (request.hasEncounterId()) {
            carePlan.setEncounter(requestOrchestration.getEncounter());
        }
        if (request.hasPractitionerId()) {
            carePlan.setAuthor(requestOrchestration.getAuthor());
        }
        if (requestOrchestration.getLanguage() != null) {
            carePlan.setLanguage(requestOrchestration.getLanguage());
        }
        for (IBaseResource iBaseResource : request.getRequestResources()) {
            if (!iBaseResource.fhirType().equals(ResourceType.Goal.name())) continue;
            carePlan.addGoal(new org.hl7.fhir.r4.model.Reference((IAnyResource)((org.hl7.fhir.r4.model.Resource)iBaseResource)));
        }
        List<IBaseResource> operationOutcomes = request.getContained((IBaseResource)requestOrchestration).stream().filter(r -> r.fhirType().equals(ResourceType.OperationOutcome.name())).toList();
        for (IBaseResource operationOutcome : operationOutcomes) {
            carePlan.addExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages", (org.hl7.fhir.r4.model.Type)new org.hl7.fhir.r4.model.Reference("#" + operationOutcome.getIdElement().getIdPart()));
        }
        carePlan.addActivity().setReference(new org.hl7.fhir.r4.model.Reference("#" + requestOrchestration.getIdPart()));
        carePlan.addContained((org.hl7.fhir.r4.model.Resource)requestOrchestration);
        for (IBaseResource resource : request.getExtractedResources()) {
            carePlan.addSupportingInfo(new org.hl7.fhir.r4.model.Reference((IAnyResource)((org.hl7.fhir.r4.model.Resource)resource)));
            carePlan.addContained((org.hl7.fhir.r4.model.Resource)resource);
        }
        Questionnaire questionnaire = (Questionnaire)request.getQuestionnaire();
        if (questionnaire != null && questionnaire.hasItem()) {
            carePlan.addContained((org.hl7.fhir.r4.model.Resource)questionnaire);
        }
        return carePlan;
    }

    protected IBaseResource generateCarePlanR5(ApplyRequest request, IBaseResource ro) {
        RequestOrchestration requestOrchestration = (RequestOrchestration)ro;
        CarePlan carePlan = new CarePlan().setInstantiatesCanonical(requestOrchestration.getInstantiatesCanonical()).setSubject(requestOrchestration.getSubject()).setStatus(Enumerations.RequestStatus.ACTIVE).setIntent(CarePlan.CarePlanIntent.PROPOSAL);
        IIdType carePlanId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)carePlan.fhirType(), (String)requestOrchestration.getIdElement().getIdPart());
        carePlan.setId(carePlanId);
        if (request.hasEncounterId()) {
            carePlan.setEncounter(requestOrchestration.getEncounter());
        }
        if (request.hasPractitionerId()) {
            carePlan.setCustodian(requestOrchestration.getAuthor());
        }
        if (requestOrchestration.getLanguage() != null) {
            carePlan.setLanguage(requestOrchestration.getLanguage());
        }
        for (IBaseResource iBaseResource : request.getRequestResources()) {
            if (!iBaseResource.fhirType().equals(org.hl7.fhir.r5.model.ResourceType.Goal.name())) continue;
            carePlan.addGoal(new Reference((IAnyResource)((Resource)iBaseResource)));
        }
        List<IBaseResource> operationOutcomes = request.getContained((IBaseResource)requestOrchestration).stream().filter(r -> r.fhirType().equals(org.hl7.fhir.r5.model.ResourceType.OperationOutcome.name())).toList();
        for (IBaseResource operationOutcome : operationOutcomes) {
            carePlan.addExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages", (DataType)new Reference("#" + operationOutcome.getIdElement().getIdPart()));
        }
        carePlan.addActivity().setPlannedActivityReference(new Reference("#" + requestOrchestration.getIdPart()));
        carePlan.addContained((Resource)requestOrchestration);
        for (IBaseResource resource : request.getExtractedResources()) {
            carePlan.addSupportingInfo(new Reference((IAnyResource)((Resource)resource)));
            carePlan.addContained((Resource)resource);
        }
        org.hl7.fhir.r5.model.Questionnaire questionnaire = (org.hl7.fhir.r5.model.Questionnaire)request.getQuestionnaire();
        if (questionnaire != null && questionnaire.hasItem()) {
            carePlan.addContained((Resource)questionnaire);
        }
        return carePlan;
    }
}

