/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r5.model.Questionnaire;

public class Helpers {
    private Helpers() {
    }

    public static Object parseItemTypeForVersion(FhirVersionEnum fhirVersion, String typeCode, Boolean hasBinding, Boolean isGroup) {
        switch (fhirVersion) {
            case R4: {
                return Helpers.parseR4ItemType(typeCode, hasBinding, isGroup);
            }
            case R5: {
                return Helpers.parseR5ItemType(typeCode, hasBinding, isGroup);
            }
        }
        throw new IllegalArgumentException("unsupported FHIR version: %s".formatted(fhirVersion));
    }

    public static Questionnaire.QuestionnaireItemType parseR4ItemType(String elementType, Boolean hasBinding, Boolean isGroup) {
        if (Boolean.TRUE.equals(hasBinding)) {
            return Questionnaire.QuestionnaireItemType.CHOICE;
        }
        if (Boolean.TRUE.equals(isGroup)) {
            return Questionnaire.QuestionnaireItemType.GROUP;
        }
        if (elementType == null) {
            return null;
        }
        switch (elementType) {
            case "code": 
            case "coding": 
            case "CodeableConcept": {
                return Questionnaire.QuestionnaireItemType.CHOICE;
            }
            case "uri": 
            case "url": 
            case "canonical": {
                return Questionnaire.QuestionnaireItemType.URL;
            }
            case "Quantity": {
                return Questionnaire.QuestionnaireItemType.QUANTITY;
            }
            case "Reference": {
                return Questionnaire.QuestionnaireItemType.REFERENCE;
            }
            case "id": 
            case "oid": 
            case "uuid": 
            case "base64Binary": 
            case "Identifier": 
            case "Extension": {
                return Questionnaire.QuestionnaireItemType.STRING;
            }
            case "positiveInt": 
            case "unsignedInt": {
                return Questionnaire.QuestionnaireItemType.INTEGER;
            }
            case "instant": {
                return Questionnaire.QuestionnaireItemType.DATETIME;
            }
        }
        return Questionnaire.QuestionnaireItemType.fromCode((String)elementType);
    }

    public static Questionnaire.QuestionnaireItemType parseR5ItemType(String elementType, Boolean hasBinding, Boolean isGroup) {
        if (Boolean.TRUE.equals(hasBinding)) {
            return Questionnaire.QuestionnaireItemType.QUESTION;
        }
        if (Boolean.TRUE.equals(isGroup)) {
            return Questionnaire.QuestionnaireItemType.GROUP;
        }
        if (elementType == null) {
            return null;
        }
        switch (elementType) {
            case "code": 
            case "coding": 
            case "CodeableConcept": {
                return Questionnaire.QuestionnaireItemType.QUESTION;
            }
            case "uri": 
            case "url": 
            case "canonical": {
                return Questionnaire.QuestionnaireItemType.URL;
            }
            case "Quantity": {
                return Questionnaire.QuestionnaireItemType.QUANTITY;
            }
            case "Reference": {
                return Questionnaire.QuestionnaireItemType.REFERENCE;
            }
            case "id": 
            case "oid": 
            case "uuid": 
            case "base64Binary": 
            case "Identifier": 
            case "Extension": {
                return Questionnaire.QuestionnaireItemType.STRING;
            }
            case "positiveInt": 
            case "unsignedInt": {
                return Questionnaire.QuestionnaireItemType.INTEGER;
            }
            case "instant": {
                return Questionnaire.QuestionnaireItemType.DATETIME;
            }
        }
        return Questionnaire.QuestionnaireItemType.fromCode((String)elementType);
    }

    public static boolean isGroupItemType(Object itemType) {
        if (itemType instanceof Questionnaire.QuestionnaireItemType) {
            Questionnaire.QuestionnaireItemType r4ItemType = (Questionnaire.QuestionnaireItemType)itemType;
            return r4ItemType == Questionnaire.QuestionnaireItemType.GROUP;
        }
        if (itemType instanceof Questionnaire.QuestionnaireItemType) {
            Questionnaire.QuestionnaireItemType r5ItemType = (Questionnaire.QuestionnaireItemType)itemType;
            return r5ItemType == Questionnaire.QuestionnaireItemType.GROUP;
        }
        return false;
    }

    public static boolean isChoiceItemType(Object itemType) {
        if (itemType instanceof Questionnaire.QuestionnaireItemType) {
            Questionnaire.QuestionnaireItemType r4ItemType = (Questionnaire.QuestionnaireItemType)itemType;
            return r4ItemType == Questionnaire.QuestionnaireItemType.CHOICE;
        }
        if (itemType instanceof Questionnaire.QuestionnaireItemType) {
            Questionnaire.QuestionnaireItemType r5ItemType = (Questionnaire.QuestionnaireItemType)itemType;
            return r5ItemType == Questionnaire.QuestionnaireItemType.QUESTION;
        }
        return false;
    }

    public static String getSliceName(String elementId) {
        if (!elementId.contains(":")) {
            return null;
        }
        String sliceName = elementId.substring(elementId.indexOf(":") + 1);
        if (sliceName.contains(".")) {
            sliceName = sliceName.substring(0, sliceName.indexOf("."));
        }
        return sliceName;
    }
}

