/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Expression;
import org.opencds.cqf.fhir.cr.questionnaire.Helpers;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.opencds.cqf.fhir.utility.adapter.IElementDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IStructureDefinitionAdapter;

public class ElementHasCaseFeature {
    public IBaseBackboneElement addProperties(GenerateRequest request, CqfExpression caseFeature, IStructureDefinitionAdapter profile, IElementDefinitionAdapter element, IBaseBackboneElement questionnaireItem) {
        List sliceElements;
        String elementId = element.getId();
        String[] elementIdentifiers = element.getPath().split("\\.");
        String path = elementId.substring(elementId.indexOf(".")).replaceAll("\\[[^\\[]*\\]", "");
        String sliceName = Helpers.getSliceName(elementId);
        if (StringUtils.isNotBlank((CharSequence)sliceName) && !(sliceElements = profile.getSliceElements(sliceName)).isEmpty()) {
            StringBuilder filter = new StringBuilder(".where(");
            sliceElements.stream().filter(e -> !e.getId().equals(elementId) && e.hasDefaultOrFixedOrPattern()).forEach(slice -> {
                ArrayList<String> filterIdentifiers = new ArrayList<String>();
                String[] sliceIdentifiers = slice.getPath().split("\\.");
                for (int i = 0; i < elementIdentifiers.length; ++i) {
                    if (elementIdentifiers[i].equals(sliceIdentifiers[i])) continue;
                    filterIdentifiers.add(sliceIdentifiers[i]);
                }
                String filterPath = StringUtils.join(filterIdentifiers, (String)".");
                IBaseDatatype filterValue = slice.getDefaultOrFixedOrPattern();
                filter.append("%s = '%s'".formatted(filterPath, request.getFhirContext().newJsonParser().encodeToString((IBase)filterValue)));
            });
            filter.append(").single()");
            path = path.replace(":" + sliceName, filter);
        }
        String expression = "%" + "%s%s".formatted(caseFeature.getName(), path);
        ICompositeType expressionType = this.createExpression(request.getFhirVersion(), expression, null);
        if (expressionType != null) {
            IBaseExtension initialExpressionExt = questionnaireItem.addExtension();
            initialExpressionExt.setUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
            initialExpressionExt.setValue((IBaseDatatype)expressionType);
        }
        return questionnaireItem;
    }

    private ICompositeType createExpression(FhirVersionEnum fhirVersion, String expression, String name) {
        switch (fhirVersion) {
            case R4: {
                Expression r4Expression = new Expression().setLanguage("text/cql-expression").setExpression(expression).setName(name);
                return r4Expression;
            }
            case R5: {
                org.hl7.fhir.r5.model.Expression r5Expression = new org.hl7.fhir.r5.model.Expression().setLanguage("text/cql-expression").setExpression(expression).setName(name);
                return r5Expression;
            }
        }
        return null;
    }
}

