/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.IQuestionnaireRequest;
import org.opencds.cqf.fhir.utility.adapter.IElementDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireAdapter;
import org.opencds.cqf.fhir.utility.adapter.IStructureDefinitionAdapter;

public class GenerateRequest
implements IQuestionnaireRequest {
    private final IStructureDefinitionAdapter profileAdapter;
    private final boolean supportedOnly;
    private final boolean requiredOnly;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirVersionEnum fhirVersion;
    private Map<String, String> referencedLibraries;
    private IBaseResource questionnaire;
    private IQuestionnaireAdapter questionnaireAdapter;
    private List<IElementDefinitionAdapter> differentialElements;
    private List<IElementDefinitionAdapter> snapshotElements;

    public GenerateRequest(IBaseResource profile, boolean supportedOnly, boolean requiredOnly, LibraryEngine libraryEngine, ModelResolver modelResolver) {
        Preconditions.checkNotNull((Object)profile, (Object)"expected non-null value for profile");
        Preconditions.checkNotNull((Object)libraryEngine, (Object)"expected non-null value for libraryEngine");
        Preconditions.checkNotNull((Object)modelResolver, (Object)"expected non-null value for modelResolver");
        this.fhirVersion = profile.getStructureFhirVersionEnum();
        this.profileAdapter = (IStructureDefinitionAdapter)this.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)profile);
        this.supportedOnly = supportedOnly;
        this.requiredOnly = requiredOnly;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
        this.referencedLibraries = this.profileAdapter.getReferencedLibraries();
    }

    public IBaseResource getProfile() {
        return this.profileAdapter.get();
    }

    public IStructureDefinitionAdapter getProfileAdapter() {
        return this.profileAdapter;
    }

    @Override
    public IQuestionnaireAdapter getQuestionnaireAdapter() {
        if (this.questionnaireAdapter == null && this.questionnaire != null) {
            this.questionnaireAdapter = (IQuestionnaireAdapter)this.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)this.questionnaire);
        }
        return this.questionnaireAdapter;
    }

    public void setDifferentialElements(List<IElementDefinitionAdapter> elements) {
        this.differentialElements = elements;
    }

    public List<IElementDefinitionAdapter> getDifferentialElements() {
        return this.differentialElements;
    }

    public void setSnapshotElements(List<IElementDefinitionAdapter> elements) {
        this.snapshotElements = elements;
    }

    public List<IElementDefinitionAdapter> getSnapshotElements() {
        return this.snapshotElements;
    }

    public GenerateRequest setQuestionnaire(IBaseResource questionnaire) {
        this.questionnaire = questionnaire;
        return this;
    }

    public boolean getSupportedOnly() {
        return this.supportedOnly;
    }

    public boolean getRequiredOnly() {
        return this.requiredOnly;
    }

    public GenerateRequest setReferencedLibraries(Map<String, String> libraries) {
        this.referencedLibraries = libraries;
        return this;
    }

    @Override
    public String getOperationName() {
        return "questionnaire";
    }

    @Override
    public IBase getContextVariable() {
        return this.getProfile();
    }

    @Override
    public IIdType getSubjectId() {
        throw new UnsupportedOperationException("Unimplemented method 'getSubjectId'");
    }

    @Override
    public IBaseBundle getData() {
        throw new UnsupportedOperationException("Unimplemented method 'getData'");
    }

    @Override
    public IBaseParameters getParameters() {
        throw new UnsupportedOperationException("Unimplemented method 'getParameters'");
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public Map<String, String> getReferencedLibraries() {
        return this.referencedLibraries;
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return this.questionnaire;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        throw new UnsupportedOperationException("Unimplemented method 'getOperationOutcome'");
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        throw new UnsupportedOperationException("Unimplemented method 'setOperationOutcome'");
    }
}

