/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r5.model.Questionnaire;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.common.ExtensionProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.Helpers;
import org.opencds.cqf.fhir.cr.questionnaire.generate.ElementHasCaseFeature;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.generate.ItemTypeIsChoice;
import org.opencds.cqf.fhir.utility.Constants;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.VersionUtilities;
import org.opencds.cqf.fhir.utility.adapter.IElementDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.ILibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.IStructureDefinitionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(ItemGenerator.class);
    protected static final String NO_PROFILE_ERROR = "No profile defined for input. Unable to generate item.";
    protected static final String ITEM_CREATION_ERROR = "An error occurred during item creation: %s";
    protected static final String CHILD_LINK_ID_FORMAT = "%s.%s";
    protected final IRepository repository;
    protected final CqlEngine engine;
    protected final ExpressionProcessor expressionProcessor;
    protected final ExtensionProcessor extensionProcessor;
    protected final ElementHasCaseFeature elementHasCaseFeature;
    protected final ItemTypeIsChoice itemTypeIsChoice;

    public ItemGenerator(IRepository repository) {
        this.repository = repository;
        this.engine = Engines.forRepository((IRepository)this.repository);
        this.expressionProcessor = new ExpressionProcessor();
        this.extensionProcessor = new ExtensionProcessor();
        this.elementHasCaseFeature = new ElementHasCaseFeature();
        this.itemTypeIsChoice = new ItemTypeIsChoice(repository);
    }

    @Nullable
    public <T extends IBaseExtension<?, ?>> Pair<IBaseBackboneElement, List<T>> generate(GenerateRequest request) {
        String linkId = String.valueOf(request.getItems((IBase)request.getQuestionnaire()).size() + 1);
        try {
            int childCount = 0;
            CqfExpression caseFeature = this.getFeatureExpression(request);
            List<IElementDefinitionAdapter> parentElements = this.getElements(request, null, null);
            Pair results = this.processElements(request, parentElements, childCount, linkId, caseFeature);
            List childItems = (List)results.getLeft();
            List valueExtensions = (List)results.getRight();
            if (childItems.isEmpty() && valueExtensions.isEmpty()) {
                return null;
            }
            IBaseBackboneElement questionnaireItem = this.createQuestionnaireItem(request, linkId);
            if (!childItems.isEmpty()) {
                request.getModelResolver().setValue((Object)questionnaireItem, "item", (Object)childItems);
            }
            if (!valueExtensions.isEmpty()) {
                request.getModelResolver().setValue((Object)questionnaireItem, "extension", (Object)valueExtensions);
            }
            ArrayList launchContextExts = new ArrayList();
            if (caseFeature != null) {
                IBaseExtension itemContextExt = questionnaireItem.addExtension();
                itemContextExt.setUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext");
                itemContextExt.setValue((IBaseDatatype)caseFeature.toExpressionType(request.getFhirVersion()));
                launchContextExts.add(ExtensionBuilders.buildSdcLaunchContextExt(request.getFhirVersion(), "patient"));
                ILibraryAdapter featureLibrary = request.getAdapterFactory().createLibrary(SearchHelper.searchRepositoryByCanonical((IRepository)this.repository, (IPrimitiveType)VersionUtilities.canonicalTypeForVersion((FhirVersionEnum)request.getFhirVersion(), (String)caseFeature.getLibraryUrl())));
                List<String> inParameters = featureLibrary.getParameter().stream().filter(p -> {
                    String name = request.resolvePathString((IBase)p, "name").toUpperCase();
                    return name.equals("PRACTITIONER") || request.resolvePathString((IBase)p, "use").equals("in") && Arrays.stream(Constants.SDC_QUESTIONNAIRE_LAUNCH_CONTEXT_CODE.values()).map(Object::toString).toList().contains(name);
                }).map(p -> request.resolvePathString((IBase)p, "name").toLowerCase()).toList();
                inParameters.forEach(p -> launchContextExts.add(ExtensionBuilders.buildSdcLaunchContextExt(request.getFhirVersion(), p)));
            }
            return new ImmutablePair((Object)questionnaireItem, launchContextExts);
        }
        catch (Exception ex) {
            String message = ITEM_CREATION_ERROR.formatted(ex.getMessage());
            logger.error(message);
            return new ImmutablePair((Object)this.createErrorItem(request, linkId, message), new ArrayList());
        }
    }

    protected CqfExpression getFeatureExpression(GenerateRequest request) {
        CqfExpression expression = this.expressionProcessor.getCqfExpression(request, request.getExtensions((IBase)request.getProfile()), "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-featureExpression");
        if (expression != null) {
            expression.setName(request.getProfileAdapter().getName());
        }
        return expression;
    }

    protected <E extends IBaseExtension<?, ?>> Pair<List<IBaseBackboneElement>, List<E>> processElements(GenerateRequest request, List<IElementDefinitionAdapter> elements, int childCount, String itemLinkId, CqfExpression caseFeature) {
        ArrayList<IBaseBackboneElement> items = new ArrayList<IBaseBackboneElement>();
        ArrayList<IBaseExtension> valueExtensions = new ArrayList<IBaseExtension>();
        for (IElementDefinitionAdapter element : elements) {
            String childLinkId;
            IBaseBackboneElement item;
            if (element.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-definitionExtractValue")) {
                valueExtensions.add(element.getExtensionByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-definitionExtractValue"));
                continue;
            }
            if (element.hasDefaultOrFixedOrPattern()) continue;
            if ((item = this.processElement(request, caseFeature, element, childLinkId = CHILD_LINK_ID_FORMAT.formatted(itemLinkId, ++childCount))) == null) {
                --childCount;
                continue;
            }
            items.add(item);
        }
        return new ImmutablePair(items, valueExtensions);
    }

    protected IBaseBackboneElement processProfile(GenerateRequest request, IStructureDefinitionAdapter profileAdapter, String childLinkId) {
        throw new NotImplementedException("Nested profile generation is not currently supported.");
    }

    protected IStructureDefinitionAdapter getElementProfile(GenerateRequest request, String elementProfile) {
        try {
            return (IStructureDefinitionAdapter)request.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)SearchHelper.searchRepositoryByCanonical((IRepository)request.getRepository(), (IPrimitiveType)VersionUtilities.canonicalTypeForVersion((FhirVersionEnum)request.getFhirVersion(), (String)elementProfile)));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected IBaseBackboneElement processElement(GenerateRequest request, CqfExpression caseFeature, IElementDefinitionAdapter element, String childLinkId) {
        IStructureDefinitionAdapter profileAdapter = null;
        String elementProfile = element.getTypeProfile();
        if (StringUtils.isNotBlank((CharSequence)elementProfile) && (profileAdapter = this.getElementProfile(request, elementProfile)) != null) {
            return this.processProfile(request, profileAdapter, childLinkId);
        }
        List<IElementDefinitionAdapter> childElements = this.getElements(request, element.getPath(), element.getSliceName());
        Pair results = this.processElements(request, childElements, 0, childLinkId, caseFeature);
        List childItems = (List)results.getLeft();
        List valueExtensions = (List)results.getRight();
        IBaseBackboneElement item = this.createItemForElement(request, element, childLinkId, caseFeature, !childItems.isEmpty());
        if (!childItems.isEmpty()) {
            request.getModelResolver().setValue((Object)item, "item", (Object)childItems);
        }
        if (!valueExtensions.isEmpty()) {
            request.getModelResolver().setValue((Object)item, "extension", (Object)valueExtensions);
        }
        return item;
    }

    protected IBaseBackboneElement createItemForElement(GenerateRequest request, IElementDefinitionAdapter element, String childLinkId, CqfExpression caseFeature, Boolean isGroup) {
        try {
            String elementType = this.getElementType(request, element);
            Object itemType = Helpers.parseItemTypeForVersion(request.getFhirVersion(), elementType, element.hasBinding(), isGroup);
            if (itemType == null) {
                return null;
            }
            String definition = request.getProfileAdapter().getUrl() + "#" + element.getId();
            boolean required = element.hasMin() && element.getMin() > 0;
            boolean repeats = element.hasMax() && !element.getMax().equals("1");
            IBaseBackboneElement item = this.initializeQuestionnaireItem(request, itemType, definition, childLinkId, this.getElementText(element), required, repeats);
            if (Helpers.isGroupItemType(itemType)) {
                return item;
            }
            if (Helpers.isChoiceItemType(itemType)) {
                this.itemTypeIsChoice.addProperties(element, item);
            }
            if (caseFeature != null) {
                this.elementHasCaseFeature.addProperties(request, caseFeature, request.getProfileAdapter(), element, item);
            }
            return item;
        }
        catch (Exception ex) {
            String message = ITEM_CREATION_ERROR.formatted(ex.getMessage());
            logger.warn(message);
            return this.createErrorItem(request, childLinkId, message);
        }
    }

    protected List<IElementDefinitionAdapter> getElements(GenerateRequest request, String parentPath, String sliceName) {
        List<IElementDefinitionAdapter> elements = request.getDifferentialElements().stream().filter(e -> this.filterElement(request, (IElementDefinitionAdapter)e, null, parentPath, sliceName, false)).collect(Collectors.toList());
        if (request.getSnapshotElements() != null) {
            elements.addAll(request.getProfileAdapter().getSnapshotElements().stream().filter(e -> this.filterElement(request, (IElementDefinitionAdapter)e, elements, parentPath, sliceName, request.getRequiredOnly())).toList());
        }
        return elements;
    }

    protected boolean filterElement(GenerateRequest request, IElementDefinitionAdapter element, List<IElementDefinitionAdapter> existingElements, String parentPath, String sliceName, boolean requiredOnly) {
        String path = element.getPath();
        if (this.elementExists(existingElements, path)) {
            return false;
        }
        if (element.hasDefaultOrFixedOrPattern()) {
            return false;
        }
        if (element.hasSlicing()) {
            return false;
        }
        if (this.notInPath(path, parentPath)) {
            return false;
        }
        if (sliceName != null) {
            return element.getId().contains(sliceName);
        }
        if (requiredOnly) {
            return element.isRequired();
        }
        if (request.getSupportedOnly()) {
            return element.getMustSupport();
        }
        return true;
    }

    protected boolean elementExists(List<IElementDefinitionAdapter> existingElements, String path) {
        return existingElements != null && !existingElements.isEmpty() && existingElements.stream().anyMatch(e -> e.getPath().equals(path));
    }

    protected boolean notInPath(String path, String parentPath) {
        String[] pathSplit = path.split("\\.");
        if (parentPath == null) {
            return pathSplit.length > 2;
        }
        int splitLength = parentPath.split("\\.").length + 1;
        return pathSplit.length > splitLength || !path.contains(parentPath + ".");
    }

    protected <E extends ICompositeType> boolean isRequiredPath(GenerateRequest request, E element) {
        IPrimitiveType min = request.resolvePath((IBase)element, "min", IPrimitiveType.class);
        return min != null && (Integer)min.getValue() != 0;
    }

    protected IBaseBackboneElement createErrorItem(GenerateRequest request, String linkId, String errorMessage) {
        return this.createQuestionnaireItemComponent(request, errorMessage, linkId, null, true);
    }

    protected String getElementType(GenerateRequest request, IElementDefinitionAdapter element) {
        String type;
        String string = type = element == null ? null : element.getTypeCode();
        if (type == null && element != null) {
            IElementDefinitionAdapter snapshot;
            String path = element.getPath();
            IElementDefinitionAdapter iElementDefinitionAdapter = snapshot = request.getSnapshotElements() == null ? null : (IElementDefinitionAdapter)request.getSnapshotElements().stream().filter(e -> e.getPath().equals(path)).findFirst().orElse(null);
            if (snapshot != null) {
                type = snapshot.getTypeCode();
            }
        }
        return type;
    }

    public IBaseBackboneElement createQuestionnaireItem(GenerateRequest request, String linkId) {
        String text = request.getProfileAdapter().hasTitle() ? request.getProfileAdapter().getTitle() : request.getProfileAdapter().getName();
        IBaseBackboneElement item = this.createQuestionnaireItemComponent(request, text, linkId, request.getProfileAdapter().getUrl(), false);
        IBaseExtension definitionExtract = item.addExtension();
        definitionExtract.setUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-definitionExtract");
        definitionExtract.setValue((IBaseDatatype)VersionUtilities.canonicalTypeForVersion((FhirVersionEnum)request.getFhirVersion(), (String)request.getProfileAdapter().getUrl()));
        return item;
    }

    protected IBaseBackboneElement createQuestionnaireItemComponent(GenerateRequest request, String text, String linkId, String definition, Boolean isDisplay) {
        Questionnaire.QuestionnaireItemType itemType = switch (request.getFhirVersion()) {
            case FhirVersionEnum.R4 -> {
                if (Boolean.TRUE.equals(isDisplay)) {
                    yield Questionnaire.QuestionnaireItemType.DISPLAY;
                }
                yield Questionnaire.QuestionnaireItemType.GROUP;
            }
            case FhirVersionEnum.R5 -> {
                if (Boolean.TRUE.equals(isDisplay)) {
                    yield Questionnaire.QuestionnaireItemType.DISPLAY;
                }
                yield Questionnaire.QuestionnaireItemType.GROUP;
            }
            default -> null;
        };
        return this.initializeQuestionnaireItem(request, itemType, definition, linkId, text, false, true);
    }

    protected IBaseBackboneElement initializeQuestionnaireItem(GenerateRequest request, Object itemType, String definition, String linkId, String text, boolean required, boolean repeats) {
        return switch (request.getFhirVersion()) {
            case FhirVersionEnum.R4 -> new Questionnaire.QuestionnaireItemComponent().setType((Questionnaire.QuestionnaireItemType)itemType).setDefinition(definition).setLinkId(linkId).setText(text).setRequired(required).setRepeats(repeats);
            case FhirVersionEnum.R5 -> new Questionnaire.QuestionnaireItemComponent().setType((Questionnaire.QuestionnaireItemType)itemType).setDefinition(definition).setLinkId(linkId).setText(text).setRequired(required).setRepeats(repeats);
            default -> null;
        };
    }

    protected String getElementText(IElementDefinitionAdapter element) {
        return element.hasLabel() ? element.getLabel() : this.getElementDescription(element);
    }

    protected String getElementDescription(IElementDefinitionAdapter element) {
        return element.hasShort() ? element.getShort() : element.getPath();
    }
}

