/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.ValueSet;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.VersionUtilities;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.ICodingAdapter;
import org.opencds.cqf.fhir.utility.adapter.IElementDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetConceptReferenceAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetExpansionContainsAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTypeIsChoice {
    protected static final Logger logger = LoggerFactory.getLogger(ItemTypeIsChoice.class);
    protected final IRepository repository;
    protected final IAdapterFactory adapterFactory;

    public ItemTypeIsChoice(IRepository repository) {
        this.repository = repository;
        this.adapterFactory = IAdapterFactory.forFhirContext((FhirContext)repository.fhirContext());
    }

    private FhirVersionEnum fhirVersion() {
        return this.repository.fhirContext().getVersion().getVersion();
    }

    public IBaseBackboneElement addProperties(IElementDefinitionAdapter element, IBaseBackboneElement item) {
        IValueSetAdapter valueSet = this.getValueSet(element);
        if (valueSet != null) {
            if (valueSet.hasExpansion()) {
                this.addAnswerOptionsForValueSetWithExpansionComponent(valueSet, item);
            } else {
                this.addAnswerOptionsForValueSetWithComposeComponent(valueSet, item);
            }
        }
        return item;
    }

    protected void addAnswerOptionsForValueSetWithExpansionComponent(IValueSetAdapter valueSet, IBaseBackboneElement item) {
        List expansionList = valueSet.getExpansionContains();
        expansionList.forEach(expansion -> {
            ICodingAdapter coding = this.getCodingFromExpansion((IValueSetExpansionContainsAdapter)expansion);
            if (coding != null) {
                this.addAnswerOption(item, coding);
            }
        });
    }

    protected void addAnswerOptionsForValueSetWithComposeComponent(IValueSetAdapter valueSet, IBaseBackboneElement item) {
        List conceptSets = valueSet.getComposeInclude();
        conceptSets.forEach(conceptSet -> {
            String systemUri = conceptSet.getSystem();
            conceptSet.getConcept().forEach(concept -> {
                ICodingAdapter coding = this.getCodingFromConcept((IValueSetConceptReferenceAdapter)concept, systemUri);
                if (coding != null) {
                    this.addAnswerOption(item, coding);
                }
            });
        });
    }

    protected void addAnswerOption(IBaseBackboneElement item, ICodingAdapter coding) {
        if (item instanceof Questionnaire.QuestionnaireItemComponent) {
            Questionnaire.QuestionnaireItemComponent r4Item = (Questionnaire.QuestionnaireItemComponent)item;
            r4Item.addAnswerOption().setValue((Type)((org.hl7.fhir.r4.model.Coding)coding.get()));
        } else if (item instanceof Questionnaire.QuestionnaireItemComponent) {
            Questionnaire.QuestionnaireItemComponent r5Item = (Questionnaire.QuestionnaireItemComponent)item;
            r5Item.addAnswerOption().setValue((DataType)((Coding)coding.get()));
        }
    }

    protected ICodingAdapter getCodingFromConcept(IValueSetConceptReferenceAdapter code, String systemUri) {
        if (code instanceof ValueSet.ConceptReferenceComponent) {
            ValueSet.ConceptReferenceComponent r4Code = (ValueSet.ConceptReferenceComponent)code;
            return this.adapterFactory.createCoding((ICompositeType)new org.hl7.fhir.r4.model.Coding().setCode(r4Code.getCode()).setSystem(systemUri).setDisplay(r4Code.getDisplay()));
        }
        if (code instanceof ValueSet.ConceptReferenceComponent) {
            ValueSet.ConceptReferenceComponent r5Code = (ValueSet.ConceptReferenceComponent)code;
            return this.adapterFactory.createCoding((ICompositeType)new Coding().setCode(r5Code.getCode()).setSystem(systemUri).setDisplay(r5Code.getDisplay()));
        }
        return null;
    }

    protected ICodingAdapter getCodingFromExpansion(IValueSetExpansionContainsAdapter code) {
        if (code instanceof ValueSet.ValueSetExpansionContainsComponent) {
            ValueSet.ValueSetExpansionContainsComponent r4Code = (ValueSet.ValueSetExpansionContainsComponent)code;
            return this.adapterFactory.createCoding((ICompositeType)new org.hl7.fhir.r4.model.Coding().setCode(r4Code.getCode()).setSystem(r4Code.getSystem()).setDisplay(r4Code.getDisplay()));
        }
        if (code instanceof ValueSet.ValueSetExpansionContainsComponent) {
            ValueSet.ValueSetExpansionContainsComponent r5Code = (ValueSet.ValueSetExpansionContainsComponent)code;
            return this.adapterFactory.createCoding((ICompositeType)new Coding().setCode(r5Code.getCode()).setSystem(r5Code.getSystem()).setDisplay(r5Code.getDisplay()));
        }
        return null;
    }

    protected IValueSetAdapter getValueSet(IElementDefinitionAdapter element) {
        if (element.hasBinding()) {
            try {
                IPrimitiveType valueSetUrl = VersionUtilities.canonicalTypeForVersion((FhirVersionEnum)this.fhirVersion(), (String)element.getBindingValueSet());
                return (IValueSetAdapter)this.adapterFactory.createKnowledgeArtifactAdapter((IDomainResource)SearchHelper.searchRepositoryByCanonical((IRepository)this.repository, (IPrimitiveType)valueSetUrl));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return null;
    }
}

