/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.populate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.populate.IPopulateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.populate.ProcessItem;
import org.opencds.cqf.fhir.cr.questionnaire.populate.ProcessItemWithContext;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateProcessor
implements IPopulateProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(PopulateProcessor.class);
    private final ProcessItem processItem;
    private final ProcessItemWithContext processItemWithContext;
    final ExpressionProcessor expressionProcessor;

    public PopulateProcessor() {
        this(new ProcessItem(), new ProcessItemWithContext(), new ExpressionProcessor());
    }

    private PopulateProcessor(ProcessItem processItem, ProcessItemWithContext processItemWithExtension, ExpressionProcessor expressionProcessor) {
        this.processItem = processItem;
        this.processItemWithContext = processItemWithExtension;
        this.expressionProcessor = expressionProcessor;
    }

    @Override
    public IBaseResource populate(PopulateRequest request) {
        logger.info("Performing $populate operation on Questionnaire/{}", (Object)request.getQuestionnaire().getIdElement().getIdPart());
        request.getItems((IBase)request.getQuestionnaire()).forEach(item -> request.addQuestionnaireResponseItems(this.populateItem(request, (IBaseBackboneElement)item)));
        request.resolveOperationOutcome(request.getQuestionnaireResponse());
        logger.info("$populate operation completed");
        return request.getQuestionnaireResponse();
    }

    protected Map<String, Object> getVariables(PopulateRequest request, IBase element) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        List<CqfExpression> expressions = request.getExtensionsByUrl(element, "http://hl7.org/fhir/StructureDefinition/variable").stream().map(e -> CqfExpression.of((IBaseExtension)e, request.getReferencedLibraries())).toList();
        expressions.forEach(expression -> {
            try {
                List<IBase> result = this.expressionProcessor.getExpressionResult(request, (CqfExpression)expression, null, null);
                if (!result.isEmpty()) {
                    if (result.size() == 1) {
                        variables.put(expression.getName(), result.get(0));
                    } else {
                        variables.put(expression.getName(), result);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error encountered evaluating result for variable: {}", (Object)expression.getName());
            }
        });
        return variables;
    }

    protected List<IBaseBackboneElement> populateItem(PopulateRequest request, IBaseBackboneElement item) {
        String linkId = request.getItemLinkId(item);
        logger.info("Processing item {}", (Object)linkId);
        IBaseExtension populationContextExt = item.getExtension().stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext")).findFirst().orElse(null);
        if (populationContextExt != null) {
            return this.processItemWithContext(request, item);
        }
        List<IBaseBackboneElement> childItems = request.getItems((IBase)item);
        if (!childItems.isEmpty()) {
            IBaseBackboneElement responseItem = this.processItem.createResponseItem(request.getFhirVersion(), item);
            List<IBaseBackboneElement> responseChildItems = this.populateItems(request, childItems);
            request.getModelResolver().setValue((Object)responseItem, "item", responseChildItems);
            return List.of(responseItem);
        }
        return List.of(this.processItem(request, item));
    }

    protected List<IBaseBackboneElement> populateItems(PopulateRequest request, List<IBaseBackboneElement> items) {
        ArrayList<IBaseBackboneElement> responseItems = new ArrayList<IBaseBackboneElement>();
        items.forEach(item -> responseItems.addAll(this.populateItem(request, (IBaseBackboneElement)item)));
        return responseItems;
    }

    protected List<IBaseBackboneElement> processItemWithContext(PopulateRequest request, IBaseBackboneElement item) {
        try {
            return this.processItemWithContext.processContextItem(request, item);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            request.logException(e.getMessage());
            return List.of();
        }
    }

    protected IBaseBackboneElement processItem(PopulateRequest request, IBaseBackboneElement item) {
        try {
            return this.processItem.processItem(request, item);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            request.logException(e.getMessage());
            return this.processItem.createResponseItem(request.getFhirVersion(), item);
        }
    }
}

