/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.populate;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.IInputParameterResolver;
import org.opencds.cqf.fhir.cr.common.IQuestionnaireRequest;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.adapter.IParametersParameterComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireAdapter;

public class PopulateRequest
implements IQuestionnaireRequest {
    private final IQuestionnaireAdapter questionnaireAdapter;
    private final IBaseResource questionnaireResponse;
    private final IIdType subjectId;
    private final List<IParametersParameterComponentAdapter> context;
    private final IBaseBundle data;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirVersionEnum fhirVersion;
    private final Map<String, String> referencedLibraries;
    private final IInputParameterResolver inputParameterResolver;
    private IBase contextVariable;
    private IBaseOperationOutcome operationOutcome;

    public PopulateRequest(IBaseResource questionnaire, IIdType subjectId, List<? extends IBaseBackboneElement> context, IBaseExtension<?, ?> launchContext, IBaseParameters parameters, IBaseBundle data, LibraryEngine libraryEngine, ModelResolver modelResolver) {
        Preconditions.checkNotNull((Object)questionnaire, (Object)"expected non-null value for questionnaire");
        Preconditions.checkNotNull((Object)libraryEngine, (Object)"expected non-null value for libraryEngine");
        Preconditions.checkNotNull((Object)modelResolver, (Object)"expected non-null value for modelResolver");
        this.fhirVersion = questionnaire.getStructureFhirVersionEnum();
        this.questionnaireAdapter = (IQuestionnaireAdapter)this.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)questionnaire);
        this.context = context == null ? new ArrayList<IParametersParameterComponentAdapter>() : context.stream().map(c -> this.getAdapterFactory().createParametersParameter(c)).collect(Collectors.toList());
        this.subjectId = this.getSubjectId(subjectId);
        this.data = data;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
        List<IBaseExtension<?, ?>> launchContexts = this.getExtensionsByUrl((IBase)this.questionnaireAdapter.get(), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext");
        if (launchContext != null) {
            launchContexts.add(launchContext);
        }
        if (parameters == null) {
            parameters = (IBaseParameters)Resources.newBaseForVersion((String)"Parameters", (FhirVersionEnum)this.fhirVersion);
        }
        this.getAdapterFactory().createParameters(parameters).addParameter("%questionnaire", (IBaseResource)this.questionnaireAdapter.get());
        this.questionnaireResponse = this.createQuestionnaireResponse();
        this.contextVariable = this.questionnaireResponse;
        this.referencedLibraries = this.questionnaireAdapter.getReferencedLibraries();
        this.inputParameterResolver = IInputParameterResolver.createResolver(libraryEngine.getRepository(), this.subjectId, null, null, parameters, this.data, this.context, launchContexts);
    }

    protected IIdType getSubjectId(IIdType subject) {
        IParametersParameterComponentAdapter subjectContext = this.context.stream().filter(c -> c.getPartValues("name").stream().anyMatch(p -> ((IPrimitiveType)p).getValueAsString().equals("patient"))).findFirst().orElse(null);
        if (subjectContext == null && !this.context.isEmpty()) {
            subjectContext = this.context.get(0);
        }
        if (subjectContext != null) {
            IBaseDatatype subjectContextValue = subjectContext.getPartValues("content").stream().findFirst().orElse(null);
            if (subjectContextValue instanceof IBaseReference) {
                IBaseReference subjectRef = (IBaseReference)subjectContextValue;
                return subjectRef.getReferenceElement();
            }
            if (subjectContextValue instanceof IBaseResource) {
                IBaseResource subjectResource = (IBaseResource)subjectContextValue;
                return subjectResource.getIdElement();
            }
        }
        if (subject != null) {
            return subject;
        }
        throw new IllegalArgumentException("Unable to determine subject from launch context.");
    }

    @Override
    public String getOperationName() {
        return "populate";
    }

    @Override
    public IBase getContextVariable() {
        return this.contextVariable;
    }

    public void setContextVariable(IBase value) {
        this.contextVariable = value;
    }

    @Override
    public IBase getResourceVariable() {
        return this.getQuestionnaireResponse();
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return this.questionnaireAdapter.get();
    }

    @Override
    public IQuestionnaireAdapter getQuestionnaireAdapter() {
        return this.questionnaireAdapter;
    }

    @Override
    public IIdType getSubjectId() {
        return this.subjectId;
    }

    @Override
    public IBaseBundle getData() {
        return this.data;
    }

    @Override
    public IBaseParameters getParameters() {
        return (IBaseParameters)this.getAdapterFactory().createParameters(this.inputParameterResolver.getParameters()).copy();
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public Map<String, String> getReferencedLibraries() {
        return this.referencedLibraries;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        return this.operationOutcome;
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        this.operationOutcome = operationOutcome;
    }

    protected IBaseResource createQuestionnaireResponse() {
        org.hl7.fhir.r4.model.QuestionnaireResponse response;
        switch (this.fhirVersion) {
            case R4: {
                org.hl7.fhir.r4.model.QuestionnaireResponse questionnaireResponse = new org.hl7.fhir.r4.model.QuestionnaireResponse().setStatus(QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS).setQuestionnaire(this.questionnaireAdapter.getCanonical()).setSubject(new org.hl7.fhir.r4.model.Reference(this.subjectId)).setAuthored(new Date());
                break;
            }
            case R5: {
                org.hl7.fhir.r4.model.QuestionnaireResponse questionnaireResponse = new QuestionnaireResponse().setStatus(QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS).setQuestionnaire(this.questionnaireAdapter.getCanonical()).setSubject(new Reference(this.subjectId)).setAuthored(new Date());
                break;
            }
            default: {
                org.hl7.fhir.r4.model.QuestionnaireResponse questionnaireResponse = response = null;
            }
        }
        if (response == null) {
            throw new IllegalArgumentException("Unsupported FHIR version: %s".formatted(this.fhirVersion.getFhirVersionString()));
        }
        response.setId("%s-%s".formatted(this.questionnaireAdapter.getId().getIdPart(), this.subjectId.getIdPart()));
        return response;
    }

    public IBaseResource getQuestionnaireResponse() {
        return this.questionnaireResponse;
    }

    public void addQuestionnaireResponseItems(List<IBaseBackboneElement> items) {
        this.getModelResolver().setValue((Object)this.getQuestionnaireResponse(), "item", items);
    }
}

