/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.populate;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.common.ItemValueTransformer;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessItem {
    private static final Logger logger = LoggerFactory.getLogger(ProcessItem.class);
    final ExpressionProcessor expressionProcessor;

    public ProcessItem() {
        this(new ExpressionProcessor());
    }

    public ProcessItem(ExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
    }

    public IBaseBackboneElement processItem(PopulateRequest request, IBaseBackboneElement item) {
        IBaseBackboneElement responseItem = this.createResponseItem(request.getFhirVersion(), item);
        request.setContextVariable((IBase)responseItem);
        Map<String, Object> rawParams = request.getRawParameters();
        rawParams.put("%qitem", item);
        this.populateAnswer(request, responseItem, this.getInitialValue(request, item, responseItem, rawParams));
        return responseItem;
    }

    protected void populateAnswer(PopulateRequest request, IBaseBackboneElement responseItem, List<IBase> answerValue) {
        if (answerValue == null || answerValue.isEmpty()) {
            return;
        }
        ArrayList<IBaseBackboneElement> answers = new ArrayList<IBaseBackboneElement>();
        for (IBase value : answerValue) {
            answers.add(this.createAnswer(request.getFhirVersion(), value));
        }
        request.getModelResolver().setValue((Object)responseItem, "answer", answers);
    }

    protected List<IBase> getInitialValue(PopulateRequest request, IBaseBackboneElement item, IBaseBackboneElement responseItem, Map<String, Object> rawParameters) {
        List<IBase> results;
        CqfExpression expression = this.expressionProcessor.getItemInitialExpression(request, item);
        if (expression != null) {
            String itemLinkId = request.getItemLinkId(item);
            try {
                results = this.expressionProcessor.getExpressionResultForItem(request, expression, itemLinkId, null, rawParameters);
                if (results != null && !results.isEmpty()) {
                    this.addAuthorExtension(request, responseItem);
                }
            }
            catch (Exception e) {
                String message = "Encountered error evaluating initial expression for item %s: %s".formatted(itemLinkId, e.getMessage());
                logger.error(message);
                request.logException(message);
                results = new ArrayList();
            }
        } else {
            results = request.resolvePathList((IBase)item, "initial", IBaseBackboneElement.class).stream().map(i -> request.resolvePath((IBase)i, "value", IBase.class)).collect(Collectors.toList());
        }
        return results;
    }

    protected void addAuthorExtension(PopulateRequest request, IBaseBackboneElement item) {
        request.getModelResolver().setValue((Object)item, "extension", Collections.singletonList(ExtensionBuilders.buildReferenceExt(request.getFhirVersion(), ExtensionBuilders.QUESTIONNAIRE_RESPONSE_AUTHOR_EXTENSION, false)));
    }

    protected IBaseBackboneElement createAnswer(FhirVersionEnum fhirVersion, IBase value) {
        return switch (fhirVersion) {
            case FhirVersionEnum.R4 -> new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent().setValue(ItemValueTransformer.transformValueToItem((Type)value));
            case FhirVersionEnum.R5 -> new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent().setValue(ItemValueTransformer.transformValueToItem((DataType)value));
            default -> null;
        };
    }

    protected IBaseBackboneElement createResponseItem(FhirVersionEnum fhirVersion, IBaseBackboneElement item) {
        return switch (fhirVersion) {
            case FhirVersionEnum.R4 -> {
                Questionnaire.QuestionnaireItemComponent r4Item = (Questionnaire.QuestionnaireItemComponent)item;
                yield new QuestionnaireResponse.QuestionnaireResponseItemComponent(r4Item.getLinkIdElement()).setDefinitionElement(r4Item.getDefinitionElement()).setTextElement(r4Item.getTextElement());
            }
            case FhirVersionEnum.R5 -> {
                Questionnaire.QuestionnaireItemComponent r5Item = (Questionnaire.QuestionnaireItemComponent)item;
                yield new QuestionnaireResponse.QuestionnaireResponseItemComponent(r5Item.getLinkId()).setDefinitionElement(r5Item.getDefinitionElement()).setTextElement(r5Item.getTextElement());
            }
            default -> null;
        };
    }
}

