/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.populate;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Questionnaire;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.IOperationRequest;
import org.opencds.cqf.fhir.cr.questionnaire.Helpers;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.populate.ProcessItem;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.VersionUtilities;
import org.opencds.cqf.fhir.utility.adapter.IElementDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IStructureDefinitionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessItemWithContext
extends ProcessItem {
    private static final Logger logger = LoggerFactory.getLogger(ProcessItemWithContext.class);

    public ProcessItemWithContext() {
    }

    public ProcessItemWithContext(ExpressionProcessor expressionProcessor) {
        super(expressionProcessor);
    }

    List<IBaseBackboneElement> processContextItem(PopulateRequest request, IBaseBackboneElement item) {
        List<Object> populationContext;
        String itemLinkId = request.getItemLinkId(item);
        if (!((Questionnaire.QuestionnaireItemComponent)item).getType().equals((Object)Questionnaire.QuestionnaireItemType.GROUP)) {
            throw new UnprocessableEntityException(new String[]{"Encountered Item Population Context extension on a non group item: {}", itemLinkId});
        }
        IBaseResource profile = null;
        String definition = request.resolvePathString((IBase)item, "definition");
        if (StringUtils.isNotBlank((CharSequence)definition)) {
            String profileUrl = definition.split("#")[0];
            try {
                profile = SearchHelper.searchRepositoryByCanonical((IRepository)request.getRepository(), (IPrimitiveType)VersionUtilities.canonicalTypeForVersion((FhirVersionEnum)request.getFhirVersion(), (String)profileUrl));
            }
            catch (Exception e) {
                String message = "No profile found for definition: %s".formatted(profileUrl);
                logger.error(message);
                request.logException(message);
            }
        }
        IStructureDefinitionAdapter profileAdapter = profile == null ? null : (IStructureDefinitionAdapter)request.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)profile);
        CqfExpression contextExpression = this.expressionProcessor.getCqfExpression(request, item.getExtension(), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext");
        try {
            populationContext = this.expressionProcessor.getExpressionResultForItem(request, contextExpression, itemLinkId, null, null).stream().map(r -> {
                if (r instanceof IBaseResource) {
                    IBaseResource baseResource = (IBaseResource)r;
                    return baseResource;
                }
                String message = "Encountered error populating item (%s): Context value is expected to be a resource.".formatted(itemLinkId);
                logger.error(message);
                request.logException(message);
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            request.logException(e.getMessage());
            populationContext = new ArrayList();
        }
        if (populationContext.isEmpty()) {
            populationContext.add(null);
        }
        if (populationContext.size() > 1 && !((Questionnaire.QuestionnaireItemComponent)item).getRepeats()) {
            throw new UnprocessableEntityException(new String[]{"Population context expression resulted in multiple values for a non repeating group: {}", contextExpression.getExpression()});
        }
        return populationContext.stream().map(context -> this.processPopulationContext(request, item, contextExpression.getName(), (IBaseResource)context, profileAdapter)).collect(Collectors.toList());
    }

    IBaseBackboneElement processPopulationContext(PopulateRequest request, IBaseBackboneElement groupItem, String contextName, IBaseResource context, IStructureDefinitionAdapter profile) {
        IBaseBackboneElement contextItem = this.createResponseItem(request.getFhirVersion(), groupItem);
        request.getItems((IBase)groupItem).forEach(item -> {
            List<IBaseBackboneElement> childItems = request.getItems((IBase)item);
            if (!childItems.isEmpty()) {
                IBaseBackboneElement childGroupItem = this.processPopulationContext(request, (IBaseBackboneElement)item, contextName, context, profile);
                request.getModelResolver().setValue((Object)contextItem, "item", Collections.singletonList(childGroupItem));
            } else {
                try {
                    IBaseBackboneElement processedSubItem = this.createResponseContextItem(request, (IBaseBackboneElement)item, contextName, context, profile);
                    request.getModelResolver().setValue((Object)contextItem, "item", Collections.singletonList(processedSubItem));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    request.logException(e.getMessage());
                }
            }
        });
        return contextItem;
    }

    IBaseBackboneElement createResponseContextItem(PopulateRequest request, IBaseBackboneElement item, String contextName, IBaseResource context, IStructureDefinitionAdapter profile) {
        if (request.resolveRawPath(item, "initial") != null) {
            return this.processItem(request, item);
        }
        IBaseBackboneElement responseItem = this.createResponseItem(request.getFhirVersion(), item);
        request.setContextVariable((IBase)responseItem);
        String definition = request.resolvePathString((IBase)item, "definition");
        if (StringUtils.isNotBlank((CharSequence)definition) && profile != null) {
            Object pathValue = this.getPathValue(request, context, definition, profile);
            if (pathValue != null) {
                List<IBase> answerValue;
                List<IBase> list = answerValue = pathValue instanceof List ? (List<IBase>)pathValue : List.of((IBase)pathValue);
                if (!answerValue.isEmpty()) {
                    this.addAuthorExtension(request, responseItem);
                }
                this.populateAnswer(request, responseItem, answerValue);
            }
        } else {
            Object extension = request.getExtensionByUrl((IBase)item, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
            if (extension != null) {
                Map<String, Object> rawParams = request.getRawParameters();
                rawParams.put("%" + contextName, context);
                rawParams.put("%qitem", item);
                this.populateAnswer(request, responseItem, this.getInitialValue(request, item, responseItem, rawParams));
            }
        }
        return responseItem;
    }

    public Object getPathValue(IOperationRequest request, IBaseResource context, String definition, IStructureDefinitionAdapter profile) {
        Object pathValue = null;
        String elementId = definition.split("#")[1];
        String sliceName = Helpers.getSliceName(elementId);
        IElementDefinitionAdapter element = profile.getElement(elementId);
        String elementPath = element.getPath();
        String answerType = element.getTypeCode();
        String path = elementPath.substring(elementPath.indexOf(".") + 1).replace("[x]", "");
        if (StringUtils.isNotBlank((CharSequence)sliceName)) {
            path = path.split("\\.")[0];
        }
        if ((pathValue = request.getModelResolver().resolvePath((Object)context, path)) instanceof ArrayList) {
            ArrayList pathList = (ArrayList)pathValue;
            pathValue = elementId.contains(":") ? this.getSliceValue(request, profile, path, sliceName, pathList) : pathList.get(0);
        }
        if (pathValue != null && !((IBase)pathValue).fhirType().equals(answerType) && pathValue instanceof IPrimitiveType) {
            IPrimitiveType stringPath = (IPrimitiveType)pathValue;
            pathValue = VersionUtilities.stringTypeForVersion((FhirVersionEnum)request.getFhirVersion(), (String)stringPath.getValueAsString());
        }
        return pathValue;
    }

    private Object getSliceValue(IOperationRequest request, IStructureDefinitionAdapter profile, String path, String sliceName, ArrayList<?> pathList) {
        List<IElementDefinitionAdapter> filterElements = profile.getSliceElements(sliceName).stream().filter(IElementDefinitionAdapter::hasDefaultOrFixedOrPattern).toList();
        return pathList.stream().map(v -> (IBase)v).filter(value -> {
            for (IElementDefinitionAdapter filterElement : filterElements) {
                String[] filterSplit = filterElement.getPath().split("\\.");
                int sliceIndex = -1;
                for (int i = 0; i < filterSplit.length; ++i) {
                    if (!filterSplit[i].equals(path)) continue;
                    sliceIndex = i;
                }
                String filterPath = filterSplit[sliceIndex + 1];
                IBase filterValue = request.resolvePath((IBase)value, filterPath);
                IBaseDatatype filter = filterElement.getDefaultOrFixedOrPattern();
                if (!(filter instanceof IPrimitiveType)) continue;
                IPrimitiveType filterString = (IPrimitiveType)filter;
                if (!(filterValue instanceof IPrimitiveType)) continue;
                IPrimitiveType valueString = (IPrimitiveType)filterValue;
                if (!filterString.getValueAsString().equals(valueString.getValueAsString())) continue;
                return true;
            }
            return false;
        }).findFirst().orElse(null);
    }
}

