/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.ResourceResolver;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractProcessor;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractRequest;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.IExtractProcessor;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.utility.monad.Either;
import org.opencds.cqf.fhir.utility.repository.Repositories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionnaireResponseProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(QuestionnaireResponseProcessor.class);
    protected static final String QUESTIONNAIRE = "Questionnaire";
    protected final ResourceResolver questionnaireResponseResolver;
    protected final ResourceResolver questionnaireResolver;
    protected final ModelResolver modelResolver;
    protected final EvaluationSettings evaluationSettings;
    protected final FhirVersionEnum fhirVersion;
    protected IRepository repository;
    protected IExtractProcessor extractProcessor;

    public QuestionnaireResponseProcessor(IRepository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public QuestionnaireResponseProcessor(IRepository repository, EvaluationSettings evaluationSettings) {
        this(repository, evaluationSettings, null);
    }

    public QuestionnaireResponseProcessor(IRepository repository, EvaluationSettings evaluationSettings, IExtractProcessor extractProcessor) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.evaluationSettings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.questionnaireResponseResolver = new ResourceResolver("QuestionnaireResponse", this.repository);
        this.questionnaireResolver = new ResourceResolver(QUESTIONNAIRE, this.repository);
        this.fhirVersion = this.repository.fhirContext().getVersion().getVersion();
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)this.fhirVersion);
        this.extractProcessor = extractProcessor;
    }

    public FhirContext fhirContext() {
        return this.repository.fhirContext();
    }

    protected <R extends IBaseResource> R resolveQuestionnaireResponse(Either<IIdType, R> questionnaireResponse) {
        return this.questionnaireResponseResolver.resolve(questionnaireResponse);
    }

    protected <R extends IBaseResource> IBaseResource resolveQuestionnaire(IBaseResource questionnaireResponse, Either<IIdType, R> questionnaireId) {
        if (questionnaireId != null) {
            return this.questionnaireResolver.resolve(questionnaireId);
        }
        try {
            Object pathResult;
            Object canonical = questionnaireResponse.getStructureFhirVersionEnum().equals((Object)FhirVersionEnum.DSTU3) ? ((pathResult = this.modelResolver.resolvePath((Object)questionnaireResponse, "questionnaire")) == null ? null : ((IBaseReference)pathResult).getReferenceElement()) : (IPrimitiveType)this.modelResolver.resolvePath((Object)questionnaireResponse, "questionnaire");
            if (canonical == null) {
                return null;
            }
            IBaseResource questionnaire = null;
            if ((questionnaire = this.getQuestionnaireFromContained(questionnaireResponse, (IPrimitiveType<String>)canonical, questionnaire)) == null) {
                questionnaire = SearchHelper.searchRepositoryByCanonical((IRepository)this.repository, (IPrimitiveType)canonical, (Class)this.repository.fhirContext().getResourceDefinition(QUESTIONNAIRE).getImplementingClass());
            }
            return questionnaire;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private IBaseResource getQuestionnaireFromContained(IBaseResource questionnaireResponse, IPrimitiveType<String> canonical, IBaseResource questionnaire) {
        List contained = (List)this.modelResolver.resolvePath((Object)questionnaireResponse, "contained");
        if (contained != null && !contained.isEmpty()) {
            questionnaire = contained.stream().filter(r -> r.fhirType().equals(QUESTIONNAIRE) && canonical.getValueAsString().equals(this.getContainedId(r.getIdElement().getIdPart()))).findFirst().orElse(null);
        }
        return questionnaire;
    }

    private String getContainedId(String id) {
        return id.startsWith("#") ? id : "#" + id;
    }

    public <R extends IBaseResource> IBaseBundle extract(Either<IIdType, R> resource) {
        return this.extract(resource, null, null, null, true);
    }

    public <R extends IBaseResource> IBaseBundle extract(Either<IIdType, R> questionnaireResponseId, Either<IIdType, R> questionnaireId, IBaseParameters parameters, IBaseBundle data, boolean useServerData) {
        this.repository = Repositories.proxy((IRepository)this.repository, (Boolean)useServerData, (IRepository)null, null, null);
        return this.extract(questionnaireResponseId, questionnaireId, parameters, data, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <R extends IBaseResource> IBaseBundle extract(Either<IIdType, R> questionnaireResponseId, Either<IIdType, R> questionnaireId, IBaseParameters parameters, IBaseBundle data, LibraryEngine libraryEngine) {
        R questionnaireResponse = this.resolveQuestionnaireResponse(questionnaireResponseId);
        IBaseResource questionnaire = this.resolveQuestionnaire((IBaseResource)questionnaireResponse, questionnaireId);
        IBaseReference subject = (IBaseReference)this.modelResolver.resolvePath(questionnaireResponse, "subject");
        ExtractRequest request = new ExtractRequest((IBaseResource)questionnaireResponse, questionnaire, subject == null ? null : subject.getReferenceElement(), parameters, data, libraryEngine, this.modelResolver, null);
        IExtractProcessor processor = this.extractProcessor != null ? this.extractProcessor : new ExtractProcessor();
        return processor.extract(request);
    }
}

