/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.IInputParameterResolver;
import org.opencds.cqf.fhir.cr.common.IQuestionnaireRequest;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ItemPair;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireAdapter;

public class ExtractRequest
implements IQuestionnaireRequest {
    private final IBaseResource questionnaireResponse;
    private final IQuestionnaireAdapter questionnaireAdapter;
    private final IIdType subjectId;
    private final IBaseParameters parameters;
    private final IBaseBundle data;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirContext fhirContext;
    private final FhirVersionEnum fhirVersion;
    private final Map<String, String> referencedLibraries;
    private final IInputParameterResolver inputParameterResolver;
    private IBaseOperationOutcome operationOutcome;

    public ExtractRequest(IBaseResource questionnaireResponse, IBaseResource questionnaire, IIdType subjectId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine, ModelResolver modelResolver, IInputParameterResolver inputParameterResolver) {
        Preconditions.checkNotNull((Object)questionnaireResponse, (Object)"expected non-null value for questionnaireResponse");
        Preconditions.checkNotNull((Object)libraryEngine, (Object)"expected non-null value for libraryEngine");
        Preconditions.checkNotNull((Object)modelResolver, (Object)"expected non-null value for modelResolver");
        this.questionnaireResponse = questionnaireResponse;
        this.fhirVersion = this.questionnaireResponse.getStructureFhirVersionEnum();
        this.questionnaireAdapter = questionnaire == null ? null : this.getAdapterFactory().createQuestionnaire(questionnaire);
        this.subjectId = subjectId;
        this.parameters = parameters;
        this.data = bundle;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
        this.inputParameterResolver = inputParameterResolver != null ? inputParameterResolver : IInputParameterResolver.createResolver(libraryEngine.getRepository(), this.subjectId, null, null, this.parameters, this.data);
        this.fhirContext = this.libraryEngine.getRepository().fhirContext();
        this.referencedLibraries = Map.of();
    }

    public IBaseResource getQuestionnaireResponse() {
        return this.questionnaireResponse;
    }

    public boolean hasQuestionnaire() {
        return this.questionnaireAdapter != null;
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return this.hasQuestionnaire() ? this.questionnaireAdapter.get() : null;
    }

    @Override
    public IQuestionnaireAdapter getQuestionnaireAdapter() {
        return this.questionnaireAdapter;
    }

    public IBaseBackboneElement getQuestionnaireItem(IBaseBackboneElement item) {
        return this.hasQuestionnaire() ? this.getQuestionnaireItem(item, this.getItems((IBase)this.getQuestionnaire())) : null;
    }

    public IBaseBackboneElement getQuestionnaireItem(IBaseBackboneElement item, List<IBaseBackboneElement> qItems) {
        return qItems != null ? (IBaseBackboneElement)qItems.stream().filter(i -> this.getItemLinkId((IBaseBackboneElement)i).equals(this.getItemLinkId(item))).findFirst().orElse(null) : null;
    }

    public boolean isDefinitionItem(ItemPair item) {
        IBaseBackboneElement targetItem = item.getItem() == null ? item.getResponseItem() : item.getItem();
        return this.hasExtension((IBase)targetItem, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext") || this.hasExtension((IBase)targetItem, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-definitionExtract") || StringUtils.isNotBlank((CharSequence)this.resolvePathString((IBase)targetItem, "definition"));
    }

    public <T extends IBaseExtension<?, ?>> T getDefinitionExtract() {
        IBaseExtension qrExt = this.getExtensions((IBase)this.questionnaireResponse).stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext") || e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-definitionExtract")).findFirst().orElse(null);
        if (qrExt != null) {
            return (T)qrExt;
        }
        return (T)(this.questionnaireAdapter == null ? null : (IBaseExtension)this.questionnaireAdapter.getExtension().stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext") || e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-definitionExtract")).findFirst().orElse(null));
    }

    public String getExtractId() {
        return "extract-" + this.questionnaireResponse.getIdElement().getIdPart();
    }

    @Override
    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    @Override
    public String getOperationName() {
        return "extract";
    }

    @Override
    public IBase getContextVariable() {
        return this.getQuestionnaireResponse();
    }

    @Override
    public IIdType getSubjectId() {
        return this.subjectId;
    }

    @Override
    public IBaseBundle getData() {
        return this.data;
    }

    @Override
    public IBaseParameters getParameters() {
        return this.inputParameterResolver.getParameters();
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public Map<String, String> getReferencedLibraries() {
        return this.referencedLibraries;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        return this.operationOutcome;
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        this.operationOutcome = operationOutcome;
    }
}

