/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract;

import ca.uhn.fhir.context.BaseRuntimeChildDatatypeDefinition;
import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildExtension;
import ca.uhn.fhir.context.RuntimeChildPrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildPrimitiveEnumerationDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildResourceBlockDefinition;
import ca.uhn.fhir.repository.IRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.ItemValueTransformer;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractRequest;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ItemPair;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.VersionUtilities;
import org.opencds.cqf.fhir.utility.adapter.IElementDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IStructureDefinitionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionItem {
    protected static final String ID_PATH = "id";
    protected static final String DEFINITION_PATH = "definition";
    protected static final String VALUE_PATH = "value";
    protected static final Logger logger = LoggerFactory.getLogger(ProcessDefinitionItem.class);
    final ExpressionProcessor expressionProcessor;

    public ProcessDefinitionItem() {
        this(new ExpressionProcessor());
    }

    public ProcessDefinitionItem(ExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
    }

    public IBaseResource processDefinitionItem(ExtractRequest request, ItemPair item) {
        String linkId = request.getItemLinkId(item.getResponseItem());
        if (StringUtils.isBlank((CharSequence)linkId)) {
            linkId = "Questionnaire.root";
        }
        ImmutablePair<String, String> definitionProfile = this.getDefinitionProfile(request, item);
        List<IBaseExtension<?, ?>> valueExtensions = this.getValueExtensions(request, item);
        String definition = this.getDefinition(request, item);
        String profileUrl = definitionProfile.right == null ? definition : (String)definitionProfile.right;
        Optional<IStructureDefinitionAdapter> profile = this.getProfile(request, profileUrl);
        String resourceType = this.getResourceType(linkId, definitionProfile, definition, profile);
        IBaseResource extractResource = this.getExtractResource();
        boolean isCreatedResource = extractResource == null;
        IBaseResource resource = isCreatedResource ? (IBaseResource)Resources.newBaseForVersion((String)resourceType, (FhirVersionEnum)request.getFhirVersion()) : extractResource;
        this.processResource(request, resource, profile, isCreatedResource, item, valueExtensions);
        return resource;
    }

    protected String getResourceType(String linkId, ImmutablePair<String, String> definitionProfile, String definition, Optional<IStructureDefinitionAdapter> profile) {
        String resourceType = (String)definitionProfile.left;
        if (StringUtils.isEmpty((CharSequence)resourceType)) {
            if (profile.isPresent()) {
                resourceType = profile.get().getType();
            } else if (definitionProfile.right != null) {
                String[] split = ((String)definitionProfile.right).split("\\/");
                resourceType = split[split.length - 1];
            } else {
                if (definition == null) {
                    throw new IllegalArgumentException("Unable to retrieve definition for item: %s".formatted(linkId));
                }
                resourceType = this.getDefinitionType(definition);
            }
        }
        return resourceType;
    }

    protected <E extends IBaseExtension<?, ?>> E getExtractExtension(ExtractRequest request, ItemPair item) {
        String url = "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-definitionExtract";
        Object ext = request.getExtensionByUrl(this.getExtensionElement(request, item, url), url);
        if (ext != null) {
            return ext;
        }
        String deprecatedUrl = "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext";
        return request.getExtensionByUrl(this.getExtensionElement(request, item, deprecatedUrl), deprecatedUrl);
    }

    protected <E extends IBaseExtension<?, ?>> List<E> getValueExtensions(ExtractRequest request, ItemPair item) {
        String url = "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-definitionExtractValue";
        return request.getExtensionsByUrl(this.getExtensionElement(request, item, url), url);
    }

    protected IBase getExtensionElement(ExtractRequest request, ItemPair item, String url) {
        Object element = request.hasExtension((IBase)item.getItem(), url) ? item.getItem() : (request.hasExtension((IBase)item.getResponseItem(), url) ? item.getResponseItem() : request.getQuestionnaire());
        return element;
    }

    protected ImmutablePair<String, String> getDefinitionProfile(ExtractRequest request, ItemPair item) {
        IBaseDatatype extValue;
        String resourceType = null;
        String profile = null;
        Object extractExtension = this.getExtractExtension(request, item);
        if (extractExtension != null && (extValue = extractExtension.getValue()) instanceof IPrimitiveType) {
            String stringValue = ((IPrimitiveType)extValue).getValueAsString();
            if (stringValue.contains("/")) {
                profile = stringValue;
            } else {
                resourceType = stringValue;
            }
        }
        return new ImmutablePair(resourceType, profile);
    }

    protected IBaseResource getExtractResource() {
        return null;
    }

    protected void processResource(ExtractRequest request, IBaseResource resource, Optional<IStructureDefinitionAdapter> profile, boolean isCreatedResource, ItemPair item, List<IBaseExtension<?, ?>> valueExtensions) {
        List<IBaseBackboneElement> questionnaireItems;
        List<IBaseBackboneElement> responseItems;
        BaseRuntimeElementDefinition resourceDefinition = request.getFhirContext().getElementDefinition(resource.getClass());
        if (isCreatedResource) {
            String id = request.getExtractId();
            String linkId = request.getItemLinkId(item.getResponseItem());
            if (StringUtils.isNotBlank((CharSequence)linkId)) {
                id = id.concat("-%s".formatted(linkId));
            }
            resource.setId(Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)id));
            this.resolveMeta(resource, profile);
        }
        valueExtensions.forEach(valueExt -> this.processValueExtension(request, resource, profile, (IBaseExtension<?, ?>)valueExt));
        if (item.getResponseItem() != null && request.getItems((IBase)item.getResponseItem()).isEmpty()) {
            responseItems = Arrays.asList(item.getResponseItem());
            questionnaireItems = Arrays.asList(item.getItem());
        } else {
            responseItems = request.getItems((IBase)(item.getResponseItem() == null ? request.getQuestionnaireResponse() : item.getResponseItem()));
            questionnaireItems = request.getItems((IBase)(item.getItem() == null ? request.getQuestionnaire() : item.getItem()));
        }
        this.processItems(request, resourceDefinition, profile, (IBase)resource, (ImmutablePair<List<IBaseBackboneElement>, List<IBaseBackboneElement>>)new ImmutablePair(responseItems, questionnaireItems), false, "");
        this.processDefaultItems(request, resource, profile);
    }

    protected void processDefaultItems(ExtractRequest request, IBaseResource resource, Optional<IStructureDefinitionAdapter> profile) {
        if (profile.isPresent()) {
            List<IElementDefinitionAdapter> defaultElements = profile.get().getDifferentialElements().stream().filter(e -> e.hasDefaultOrFixedOrPattern()).collect(Collectors.toList());
            defaultElements.forEach(e -> {
                IBaseDatatype value = e.getDefaultOrFixedOrPattern();
                if (value != null) {
                    String path = this.getPath((IElementDefinitionAdapter)e);
                    String[] idSplit = e.getId().split(":");
                    if (idSplit.length <= 1 || !idSplit[1].contains(".")) {
                        request.getModelResolver().setValue((Object)resource, path, (Object)value);
                    }
                }
            });
        }
    }

    protected void processValueExtension(ExtractRequest request, IBaseResource resource, Optional<IStructureDefinitionAdapter> profile, IBaseExtension<?, ?> valueExt) {
        Object definitionExt = request.getExtensionByUrl((IBase)valueExt, DEFINITION_PATH);
        Object fixedValueExt = request.getExtensionByUrl((IBase)valueExt, "fixed-value");
        Object expressionExt = request.getExtensionByUrl((IBase)valueExt, "expression");
        if (definitionExt != null && (expressionExt != null || fixedValueExt != null)) {
            IBaseDatatype value;
            String definition = ((IPrimitiveType)definitionExt.getValue()).getValueAsString();
            Object object = value = fixedValueExt != null ? fixedValueExt.getValue() : this.expressionProcessor.getExpressionResult(request, CqfExpression.of(expressionExt, request.getReferencedLibraries()));
            if (value != null) {
                ImmutablePair<String, IStructureDefinitionAdapter> path = this.getPathAdapter(request, profile, definition);
                request.getModelResolver().setValue((Object)resource, (String)path.left, (Object)value);
            }
        }
    }

    private ImmutablePair<String, IStructureDefinitionAdapter> getPathAdapter(ExtractRequest request, Optional<IStructureDefinitionAdapter> profile, String definition) {
        String[] split = definition.split("#");
        String canonical = split[0];
        String id = split[1];
        IStructureDefinitionAdapter adapter = profile.orElseGet(() -> this.getProfile(request, canonical).orElse(null));
        String path = this.getPath(adapter, id);
        return new ImmutablePair((Object)path, (Object)adapter);
    }

    protected Optional<IStructureDefinitionAdapter> getProfile(ExtractRequest request, String definition) {
        if (StringUtils.isNotBlank((CharSequence)definition)) {
            IPrimitiveType canonical = VersionUtilities.canonicalTypeForVersion((FhirVersionEnum)request.getFhirVersion(), (String)definition.split("#")[0]);
            try {
                return Optional.of((IStructureDefinitionAdapter)request.getAdapterFactory().createKnowledgeArtifactAdapter((IDomainResource)SearchHelper.searchRepositoryByCanonical((IRepository)request.getRepository(), (IPrimitiveType)canonical)));
            }
            catch (Exception e) {
                logger.error("Encountered error retrieving profile %s: %s".formatted(canonical, e.getMessage()), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    protected void processItems(ExtractRequest request, BaseRuntimeElementDefinition<?> resourceDefinition, Optional<IStructureDefinitionAdapter> profile, IBase resource, ImmutablePair<List<IBaseBackboneElement>, List<IBaseBackboneElement>> items, boolean isNestedRepeating, String parentPath) {
        List responseItems = (List)items.left;
        List questionnaireItems = (List)items.right;
        responseItems.forEach(childItem -> {
            ItemPair itemPair = new ItemPair(request.getQuestionnaireItem((IBaseBackboneElement)childItem, questionnaireItems), (IBaseBackboneElement)childItem);
            this.processChildItem(request, resourceDefinition, profile, resource, itemPair, isNestedRepeating, parentPath);
        });
    }

    protected boolean getIsRepeating(ExtractRequest request, IBaseBackboneElement questionnaireItem) {
        IBase repeats = request.resolvePath((IBase)questionnaireItem, "repeats");
        return repeats != null && (Boolean)((IPrimitiveType)repeats).getValue() != false;
    }

    protected String stripTypeFromPath(String path) {
        return path.substring(path.indexOf(".") + 1);
    }

    protected String getPath(IElementDefinitionAdapter element) {
        return this.stripTypeFromPath(element.getPath());
    }

    protected String getPath(IStructureDefinitionAdapter profile, String id) {
        IElementDefinitionAdapter element;
        String path = id;
        if (profile != null && (element = profile.getElement(id)) != null) {
            path = element.getPath();
        }
        return this.stripTypeFromPath(path);
    }

    protected void processChildItem(ExtractRequest request, BaseRuntimeElementDefinition<?> resourceDefinition, Optional<IStructureDefinitionAdapter> profile, IBase parent, ItemPair itemPair, boolean isNestedRepeating, String parentPath) {
        String definition = this.getDefinition(request, itemPair);
        List<IBaseBackboneElement> children = request.getItems((IBase)itemPair.getResponseItem());
        boolean repeats = this.getIsRepeating(request, itemPair.getItem());
        if (StringUtils.isBlank((CharSequence)definition)) {
            this.processItems(request, resourceDefinition, profile, parent, (ImmutablePair<List<IBaseBackboneElement>, List<IBaseBackboneElement>>)new ImmutablePair(children, request.getItems((IBase)itemPair.getItem())), repeats, parentPath);
            return;
        }
        if (!definition.contains("#")) {
            throw new IllegalArgumentException("Invalid definition encountered for item %s".formatted(request.getItemLinkId(itemPair.getResponseItem())));
        }
        ImmutablePair<String, IStructureDefinitionAdapter> pathAdapter = this.getPathAdapter(request, profile, definition);
        String path = (String)pathAdapter.left;
        IStructureDefinitionAdapter adapter = (IStructureDefinitionAdapter)pathAdapter.right;
        String[] identifiers = path.split("\\.");
        HashMap<String, BaseRuntimeChildDefinition> propertyDefs = this.getPropertyDefinitions(request, resourceDefinition, adapter, identifiers);
        if (!children.isEmpty()) {
            IBase element;
            String prop = identifiers[identifiers.length - 1];
            IBase iBase = element = repeats ? null : this.getElement(request, parent, path);
            if (element == null) {
                BaseRuntimeChildDefinition propDef = propertyDefs.get(prop);
                if (propDef instanceof BaseRuntimeChildDatatypeDefinition) {
                    BaseRuntimeChildDatatypeDefinition datatypeDef = (BaseRuntimeChildDatatypeDefinition)propDef;
                    element = Resources.newBase((Class)datatypeDef.getDatatype());
                } else if (propDef instanceof RuntimeChildResourceBlockDefinition) {
                    RuntimeChildResourceBlockDefinition blockDef = (RuntimeChildResourceBlockDefinition)propDef;
                    element = Resources.newBase((Class)blockDef.getChildByName(blockDef.getElementName()).getImplementingClass());
                } else if (adapter != null) {
                    IElementDefinitionAdapter elementDef = adapter.getElementByPath(path);
                    element = Resources.newBaseForVersion((String)elementDef.getTypeCode(), (FhirVersionEnum)request.getFhirVersion());
                } else {
                    BaseRuntimeChildDefinition baseRuntimeChildDefinition = propertyDefs.get(prop);
                    if (baseRuntimeChildDefinition instanceof RuntimeChildChoiceDefinition) {
                        RuntimeChildChoiceDefinition choiceDef = (RuntimeChildChoiceDefinition)baseRuntimeChildDefinition;
                        element = Resources.newBase(this.getChoices((BaseRuntimeChildDefinition)choiceDef).get(0));
                    }
                }
            }
            this.processItems(request, resourceDefinition, profile, element, (ImmutablePair<List<IBaseBackboneElement>, List<IBaseBackboneElement>>)new ImmutablePair(children, request.getItems((IBase)itemPair.getItem())), repeats, path);
            request.getModelResolver().setValue((Object)parent, prop, List.of(element));
        } else {
            List<IBaseBackboneElement> answers = request.resolvePathList((IBase)itemPair.getResponseItem(), "answer", IBaseBackboneElement.class);
            this.processItem(request, parent, isNestedRepeating, parentPath, answers, repeats, adapter, path, identifiers, propertyDefs);
        }
    }

    protected void processItem(ExtractRequest request, IBase parent, boolean isNestedRepeating, String parentPath, List<IBaseBackboneElement> answers, boolean repeats, IStructureDefinitionAdapter profile, String path, String[] identifiers, HashMap<String, BaseRuntimeChildDefinition> propertyDefs) {
        if (path.contains(":")) {
            this.processSliceItem(request, profile, parent, answers, identifiers, propertyDefs);
        } else if (identifiers.length > 1 && (isNestedRepeating || repeats)) {
            this.processRepeatingWithNested(request, parent, isNestedRepeating, answers, identifiers, propertyDefs, profile);
        } else {
            String answerPath = StringUtils.isBlank((CharSequence)parentPath) ? path : path.replace(parentPath + ".", "");
            answers.stream().forEach(answer -> {
                IBase answerValue = request.resolvePath((IBase)answer, VALUE_PATH);
                if (answerValue != null) {
                    this.setAnswerValue(request, parent, (BaseRuntimeChildDefinition)propertyDefs.get(answerPath), answerPath, answerValue, profile);
                }
            });
        }
    }

    protected void processRepeatingWithNested(ExtractRequest request, IBase parent, boolean isNestedRepeating, List<IBaseBackboneElement> answers, String[] identifiers, HashMap<String, BaseRuntimeChildDefinition> propertyDefs, IStructureDefinitionAdapter profile) {
        String parentProperty = identifiers[0];
        String childProperty = this.getChildProperty(identifiers, 1);
        boolean isChildList = propertyDefs.get(identifiers[identifiers.length - 1]).isMultipleCardinality();
        boolean useParent = isNestedRepeating || isChildList;
        answers.stream().forEach(answer -> {
            IBase answerValue = request.resolvePath((IBase)answer, VALUE_PATH);
            if (answerValue != null) {
                IBase parentValue = useParent ? parent : Resources.newBase((Class)((BaseRuntimeChildDatatypeDefinition)propertyDefs.get(parentProperty)).getDatatype());
                this.setAnswerValue(request, parentValue, (BaseRuntimeChildDefinition)propertyDefs.get(childProperty), childProperty, answerValue, profile);
                if (!useParent) {
                    this.setAnswerValue(request, parent, (BaseRuntimeChildDefinition)propertyDefs.get(parentProperty), parentProperty, parentValue, profile);
                }
            }
        });
    }

    protected void processSliceItem(ExtractRequest request, IStructureDefinitionAdapter profile, IBase parent, List<IBaseBackboneElement> answers, String[] identifiers, HashMap<String, BaseRuntimeChildDefinition> propertyDefs) {
        Class clazz;
        String sliceName;
        if (profile == null) {
            throw new IllegalArgumentException("Unable to parse slice element without a profile for definition: %s".formatted(String.join((CharSequence)".", identifiers)));
        }
        int sliceIndex = -1;
        for (int i = 0; i < identifiers.length; ++i) {
            if (!identifiers[i].contains(":")) continue;
            sliceIndex = i;
        }
        String string = sliceName = sliceIndex == -1 ? null : identifiers[sliceIndex];
        if (sliceName == null) {
            return;
        }
        String slicePath = sliceName.split(":")[0];
        BaseRuntimeChildDefinition slicePropertyDef = propertyDefs.get(sliceName);
        if (slicePropertyDef instanceof BaseRuntimeChildDatatypeDefinition) {
            BaseRuntimeChildDatatypeDefinition def = (BaseRuntimeChildDatatypeDefinition)slicePropertyDef;
            clazz = def.getDatatype();
        } else {
            clazz = Resources.getClassForTypeAndVersion((String)"Extension", (FhirVersionEnum)request.getFhirVersion());
        }
        Class sliceClass = clazz;
        List sliceElements = profile.getSliceElements(sliceName);
        String answerPath = this.getChildProperty(identifiers, sliceIndex + 1);
        IBase extensionUrl = this.getExtensionUrl(profile, sliceName);
        answers.stream().forEach(answer -> {
            IBase answerValue = request.resolvePath((IBase)answer, VALUE_PATH);
            if (answerValue != null) {
                IBase sliceValue = Resources.newBase((Class)sliceClass);
                this.setAnswerValue(request, sliceValue, (BaseRuntimeChildDefinition)propertyDefs.get(answerPath), answerPath, answerValue, profile);
                for (IElementDefinitionAdapter slice : sliceElements) {
                    String sliceElementPath = slice.getId().replace("%s.%s.".formatted(profile.getType(), sliceName), "");
                    IBaseDatatype sliceElementValue = slice.getDefaultOrFixedOrPattern();
                    this.setAnswerValue(request, sliceValue, (BaseRuntimeChildDefinition)propertyDefs.get(sliceElementPath), sliceElementPath, (IBase)sliceElementValue, profile);
                }
                if (slicePath.equals("extension")) {
                    this.setAnswerValue(request, sliceValue, (BaseRuntimeChildDefinition)propertyDefs.get("url"), "url", extensionUrl, profile);
                }
                this.setAnswerValue(request, parent, (BaseRuntimeChildDefinition)propertyDefs.get(sliceName), slicePath, sliceValue, profile);
            }
        });
    }

    protected IBase getExtensionUrl(IStructureDefinitionAdapter profile, String sliceName) {
        Optional type;
        IBase retValue = null;
        IElementDefinitionAdapter sliceElement = profile.getElement(profile.getType() + "." + sliceName);
        if (sliceElement != null && (type = sliceElement.getType().stream().findFirst()).isPresent()) {
            retValue = sliceElement.resolvePathList((IBase)type.get(), "profile").stream().findFirst().orElse(null);
        }
        return retValue;
    }

    protected String getChildProperty(String[] identifiers, int startIndex) {
        String childProperty = identifiers[startIndex];
        for (int i = startIndex + 1; i < identifiers.length; ++i) {
            childProperty = childProperty.concat("." + identifiers[i]);
        }
        return childProperty;
    }

    protected void setAnswerValue(ExtractRequest request, IBase parent, BaseRuntimeChildDefinition pathDefinition, String answerPath, IBase answerValue, IStructureDefinitionAdapter profile) {
        block2: {
            try {
                request.getModelResolver().setValue((Object)parent, answerPath, this.transformAnswer(request, pathDefinition, answerValue, answerPath, profile));
            }
            catch (Exception e) {
                if (!(pathDefinition instanceof RuntimeChildPrimitiveDatatypeDefinition)) break block2;
                RuntimeChildPrimitiveDatatypeDefinition definition = (RuntimeChildPrimitiveDatatypeDefinition)pathDefinition;
                if (!(answerValue instanceof IPrimitiveType)) break block2;
                IPrimitiveType type = (IPrimitiveType)answerValue;
                IPrimitiveType newValue = (IPrimitiveType)Resources.newBase((Class)definition.getDatatype());
                newValue.setValueAsString(type.getValueAsString());
                request.getModelResolver().setValue((Object)parent, answerPath, (Object)newValue);
            }
        }
    }

    protected HashMap<String, BaseRuntimeChildDefinition> getPropertyDefinitions(ExtractRequest request, BaseRuntimeElementDefinition<?> resourceDefinition, IStructureDefinitionAdapter adapter, String[] identifiers) {
        HashMap<String, BaseRuntimeChildDefinition> props = new HashMap<String, BaseRuntimeChildDefinition>();
        BaseRuntimeElementDefinition targetDef = resourceDefinition;
        for (int i = 0; i < identifiers.length; ++i) {
            BaseRuntimeChildDefinition def = targetDef.getChildByName(identifiers[i].split(":")[0]);
            props.put(identifiers[i], def);
            if (i >= identifiers.length - 1) continue;
            if (def instanceof RuntimeChildExtension) {
                targetDef = request.getFhirContext().getElementDefinition(Resources.getClassForTypeAndVersion((String)"Extension", (FhirVersionEnum)request.getFhirVersion()));
                continue;
            }
            if (def instanceof RuntimeChildChoiceDefinition) {
                IElementDefinitionAdapter elementDef;
                RuntimeChildChoiceDefinition choiceDef = (RuntimeChildChoiceDefinition)def;
                IElementDefinitionAdapter iElementDefinitionAdapter = elementDef = adapter == null ? null : adapter.getElementByPath(identifiers[i]);
                if (elementDef == null) {
                    targetDef = choiceDef.getChildElementDefinitionByDatatype((Class)choiceDef.getChoices().get(0));
                    continue;
                }
                targetDef = choiceDef.getChildByName(identifiers[i].replace("[x]", elementDef.getTypeCode()));
                continue;
            }
            if (!(def instanceof BaseRuntimeChildDatatypeDefinition)) continue;
            BaseRuntimeChildDatatypeDefinition datatypeDef = (BaseRuntimeChildDatatypeDefinition)def;
            targetDef = request.getFhirContext().getElementDefinition(datatypeDef.getDatatype());
        }
        return props;
    }

    protected IBase getElement(ExtractRequest request, IBase parent, String path) {
        Object object;
        String elementPath = path.split("\\.")[0];
        Object value = request.resolveRawPath(parent, elementPath);
        if (value instanceof ArrayList) {
            ArrayList al = (ArrayList)value;
            object = al.get(0);
        } else {
            object = value;
        }
        return (IBase)object;
    }

    protected List<Class<? extends IBase>> getChoices(BaseRuntimeChildDefinition pathDefinition) {
        List<Class<Object>> list;
        if (pathDefinition instanceof RuntimeChildChoiceDefinition) {
            RuntimeChildChoiceDefinition def = (RuntimeChildChoiceDefinition)pathDefinition;
            list = def.getChoices();
        } else {
            list = new ArrayList<Class<? extends IBase>>();
        }
        return list;
    }

    protected Object transformAnswer(ExtractRequest request, BaseRuntimeChildDefinition pathDefinition, IBase answerValue, String answerPath, IStructureDefinitionAdapter profile) {
        BaseRuntimeChildDatatypeDefinition def;
        String answerType;
        IElementDefinitionAdapter pathElement = profile == null ? null : profile.getElementByPath(answerPath.split(":")[0]);
        String string = answerType = pathElement == null ? null : pathElement.getTypeCode();
        if (answerType != null && !answerValue.fhirType().equals(answerType)) {
            IBase newAnswerValue = Resources.newBaseForVersion((String)answerType, (FhirVersionEnum)request.getFhirVersion());
            request.getModelResolver().setValue((Object)newAnswerValue, VALUE_PATH, (Object)answerValue);
            answerValue = newAnswerValue;
        } else if (!(pathDefinition instanceof RuntimeChildPrimitiveEnumerationDatatypeDefinition) && (pathDefinition instanceof RuntimeChildChoiceDefinition && !this.getChoices(pathDefinition).contains(answerValue.getClass()) || pathDefinition instanceof BaseRuntimeChildDatatypeDefinition && !(def = (BaseRuntimeChildDatatypeDefinition)pathDefinition).getDatatype().equals(answerValue.getClass()))) {
            answerValue = ItemValueTransformer.transformValueToResource(request.getFhirVersion(), answerValue);
        }
        return pathDefinition != null && pathDefinition.isMultipleCardinality() ? Arrays.asList(answerValue) : answerValue;
    }

    protected String getDefinition(ExtractRequest request, ItemPair itemPair) {
        String definition = request.resolvePathString((IBase)itemPair.getItem(), DEFINITION_PATH);
        if (definition == null) {
            definition = request.resolvePathString((IBase)itemPair.getResponseItem(), DEFINITION_PATH);
        }
        return definition;
    }

    protected String getDefinitionType(String definition) {
        if (!definition.contains("#")) {
            throw new IllegalArgumentException("Unable to determine resource type from item definition: %s".formatted(definition));
        }
        return definition.split("#")[1];
    }

    protected void resolveMeta(IBaseResource resource, Optional<IStructureDefinitionAdapter> profile) {
        IBaseMetaType meta = resource.getMeta();
        if (profile.isPresent()) {
            meta.addProfile(profile.get().getCanonical());
        }
    }
}

