/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.valueset;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cr.common.DataRequirementsProcessor;
import org.opencds.cqf.fhir.cr.common.IDataRequirementsProcessor;
import org.opencds.cqf.fhir.cr.common.IPackageProcessor;
import org.opencds.cqf.fhir.cr.common.PackageProcessor;
import org.opencds.cqf.fhir.cr.common.ResourceResolver;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.utility.monad.Either3;

public class ValueSetProcessor {
    protected final ModelResolver modelResolver;
    protected final FhirVersionEnum fhirVersion;
    protected IPackageProcessor packageProcessor;
    protected IDataRequirementsProcessor dataRequirementsProcessor;
    protected IRepository repository;
    protected EvaluationSettings evaluationSettings;

    public ValueSetProcessor(IRepository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public ValueSetProcessor(IRepository repository, EvaluationSettings evaluationSettings) {
        this(repository, evaluationSettings, null, null);
    }

    public ValueSetProcessor(IRepository repository, EvaluationSettings evaluationSettings, IPackageProcessor packageProcessor, IDataRequirementsProcessor dataRequirementsProcessor) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.evaluationSettings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.fhirVersion = this.repository.fhirContext().getVersion().getVersion();
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)this.fhirVersion);
        this.packageProcessor = packageProcessor;
        this.dataRequirementsProcessor = dataRequirementsProcessor;
    }

    public EvaluationSettings evaluationSettings() {
        return this.evaluationSettings;
    }

    protected <T extends IPrimitiveType<String>, R extends IBaseResource> R resolveValueSet(Either3<T, IIdType, R> valueSet) {
        return new ResourceResolver("ValueSet", this.repository).resolve(valueSet);
    }

    public <T extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle packageValueSet(Either3<T, IIdType, R> valueSet) {
        return this.packageValueSet(valueSet, false);
    }

    public <T extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle packageValueSet(Either3<T, IIdType, R> valueSet, boolean isPut) {
        return this.packageValueSet(valueSet, PackageHelper.packageParameters((FhirVersionEnum)this.fhirVersion, null, (boolean)isPut));
    }

    public <T extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle packageValueSet(Either3<T, IIdType, R> valueSet, IBaseParameters parameters) {
        return this.packageValueSet((IBaseResource)this.resolveValueSet(valueSet), parameters);
    }

    public IBaseBundle packageValueSet(IBaseResource valueSet, IBaseParameters parameters) {
        IPackageProcessor processor = this.packageProcessor != null ? this.packageProcessor : new PackageProcessor(this.repository);
        return processor.packageResource(valueSet, parameters);
    }

    public <T extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource dataRequirements(Either3<T, IIdType, R> valueSet, IBaseParameters parameters) {
        return this.dataRequirements((IBaseResource)this.resolveValueSet(valueSet), parameters);
    }

    public IBaseResource dataRequirements(IBaseResource valueSet, IBaseParameters parameters) {
        IDataRequirementsProcessor processor = this.dataRequirementsProcessor != null ? this.dataRequirementsProcessor : new DataRequirementsProcessor(this.repository, this.evaluationSettings);
        return processor.getDataRequirements(valueSet, parameters);
    }
}

