/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.MetadataResource;
import org.opencds.cqf.fhir.cr.visitor.IValueSetExpansionCache;
import org.opencds.cqf.fhir.cr.visitor.VisitorHelper;
import org.opencds.cqf.fhir.cr.visitor.r5.ReleaseVisitor;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IEndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.utility.client.TerminologyServerClient;

public abstract class BaseKnowledgeArtifactVisitor
implements IKnowledgeArtifactVisitor {
    String isOwnedUrl = "http://hl7.org/fhir/StructureDefinition/artifact-isOwned";
    protected final IRepository repository;
    protected final Optional<IValueSetExpansionCache> valueSetExpansionCache;

    protected BaseKnowledgeArtifactVisitor(IRepository repository) {
        this.repository = repository;
        this.valueSetExpansionCache = Optional.empty();
    }

    protected BaseKnowledgeArtifactVisitor(IRepository repository, IValueSetExpansionCache valueSetExpansionCache) {
        this.repository = repository;
        this.valueSetExpansionCache = Optional.ofNullable(valueSetExpansionCache);
    }

    protected FhirContext fhirContext() {
        return this.repository.fhirContext();
    }

    protected FhirVersionEnum fhirVersion() {
        return this.fhirContext().getVersion().getVersion();
    }

    protected Optional<IValueSetExpansionCache> getExpansionCache() {
        return this.valueSetExpansionCache;
    }

    protected List<IBaseBackboneElement> findArtifactCommentsToUpdate(IBaseResource artifact, String releaseVersion, IRepository repository) {
        if (artifact instanceof org.hl7.fhir.dstu3.model.MetadataResource) {
            org.hl7.fhir.dstu3.model.MetadataResource resource2 = (org.hl7.fhir.dstu3.model.MetadataResource)artifact;
            return org.opencds.cqf.fhir.cr.visitor.dstu3.ReleaseVisitor.findArtifactCommentsToUpdate(resource2, releaseVersion, repository).stream().map(r -> r).collect(Collectors.toList());
        }
        if (artifact instanceof MetadataResource) {
            MetadataResource resource1 = (MetadataResource)artifact;
            return org.opencds.cqf.fhir.cr.visitor.r4.ReleaseVisitor.findArtifactCommentsToUpdate(resource1, releaseVersion, repository).stream().map(r -> r).collect(Collectors.toList());
        }
        if (artifact instanceof org.hl7.fhir.r5.model.MetadataResource) {
            org.hl7.fhir.r5.model.MetadataResource resource = (org.hl7.fhir.r5.model.MetadataResource)artifact;
            return ReleaseVisitor.findArtifactCommentsToUpdate(resource, releaseVersion, repository).stream().map(r -> r).collect(Collectors.toList());
        }
        throw new UnprocessableEntityException("Version not supported");
    }

    protected List<IDomainResource> getComponents(IKnowledgeArtifactAdapter adapter, IRepository repository, ArrayList<IDomainResource> resourcesToUpdate) {
        adapter.getOwnedRelatedArtifacts().stream().forEach(c -> {
            String preReleaseReference = IKnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)c);
            Optional<IKnowledgeArtifactAdapter> maybeArtifact = VisitorHelper.tryGetLatestVersion(preReleaseReference, repository);
            if (maybeArtifact.isPresent()) {
                if (resourcesToUpdate.stream().noneMatch(rtu -> rtu.getId().equals(((IKnowledgeArtifactAdapter)maybeArtifact.get()).getId().toString()))) {
                    resourcesToUpdate.add(maybeArtifact.get().get());
                    this.getComponents(maybeArtifact.get(), repository, resourcesToUpdate);
                }
            } else {
                throw new ResourceNotFoundException("Unexpected resource not found when getting components");
            }
        });
        return resourcesToUpdate;
    }

    protected void recursiveGather(IKnowledgeArtifactAdapter adapter, Map<String, IKnowledgeArtifactAdapter> gatheredResources, List<String> capability, List<String> include, ImmutableTriple<List<String>, List<String>, List<String>> versionTuple) throws PreconditionFailedException {
        this.recursiveGather(adapter, gatheredResources, capability, include, versionTuple, null, null);
    }

    protected void recursiveGather(IKnowledgeArtifactAdapter adapter, Map<String, IKnowledgeArtifactAdapter> gatheredResources, List<String> capability, List<String> include, ImmutableTriple<List<String>, List<String>, List<String>> versionTuple, IEndpointAdapter terminologyEndpoint, TerminologyServerClient client) throws PreconditionFailedException {
        if (adapter == null) {
            return;
        }
        if (!gatheredResources.keySet().contains(adapter.getCanonical())) {
            gatheredResources.put(adapter.getCanonical(), adapter);
            VisitorHelper.findUnsupportedCapability(adapter, capability);
            VisitorHelper.processCanonicals(adapter, versionTuple);
            adapter.combineComponentsAndDependencies().stream().filter(ra -> StringUtils.isNotBlank((CharSequence)ra.getReference()) && StringUtils.isNotBlank((CharSequence)Canonicals.getResourceType((String)ra.getReference()))).filter(ra -> {
                try {
                    RuntimeResourceDefinition resourceDef = this.fhirContext().getResourceDefinition(Canonicals.getResourceType((String)ra.getReference()));
                    return resourceDef != null;
                }
                catch (DataFormatException e) {
                    if (e.getMessage().contains("1684")) {
                        return false;
                    }
                    throw new DataFormatException(e.getMessage());
                }
            }).map(ra -> Optional.ofNullable(SearchHelper.searchRepositoryByCanonicalWithPaging((IRepository)this.repository, (String)ra.getReference())).map(bundle -> (IDomainResource)BundleHelper.getEntryResourceFirstRep((IBaseBundle)bundle)).orElseGet(() -> this.tryGetValueSetsFromTxServer((IDependencyInfo)ra, client, terminologyEndpoint))).filter(r -> r != null).map(r -> IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion()).createKnowledgeArtifactAdapter(r)).forEach(component -> this.recursiveGather((IKnowledgeArtifactAdapter)component, gatheredResources, capability, include, versionTuple, terminologyEndpoint, client));
        }
    }

    protected void addBundleEntry(IBaseBundle bundle, boolean isPut, IKnowledgeArtifactAdapter adapter) {
        if (bundle == null) {
            return;
        }
        if (BundleHelper.getEntryResources((IBaseBundle)bundle).stream().map(e -> IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion()).createKnowledgeArtifactAdapter((IDomainResource)e)).filter(mr -> mr.getUrl() != null).noneMatch(mr -> mr.getUrl().equals(adapter.getUrl()) && (!mr.hasVersion() || mr.getVersion().equals(adapter.getVersion())))) {
            IBaseBackboneElement entry = PackageHelper.createEntry((IBaseResource)adapter.get(), (boolean)isPut);
            BundleHelper.addEntry((IBaseBundle)bundle, (IBaseBackboneElement)entry);
        }
    }

    protected <T extends ICompositeType & IBaseHasExtensions> void addRelatedArtifact(List<T> relatedArtifacts, IKnowledgeArtifactAdapter adapter) {
        String reference;
        if (relatedArtifacts == null) {
            return;
        }
        String string = reference = adapter.hasVersion() ? adapter.getUrl().concat("|%s".formatted(adapter.getVersion())) : adapter.getUrl();
        if (relatedArtifacts.stream().noneMatch(ra -> IKnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)ra).equals(reference))) {
            relatedArtifacts.add(IKnowledgeArtifactAdapter.newRelatedArtifact((FhirVersionEnum)this.fhirVersion(), (String)"depends-on", (String)reference, (String)adapter.getDescriptor()));
        }
    }

    private IDomainResource tryGetValueSetsFromTxServer(IDependencyInfo ra, TerminologyServerClient client, IEndpointAdapter endpoint) {
        if (client != null && endpoint != null && Canonicals.getResourceType((String)ra.getReference()).equals("ValueSet")) {
            return client.getResource(endpoint, ra.getReference()).orElse(null);
        }
        return null;
    }
}

