/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.CqlTranslator;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.elm.requirements.fhir.DataRequirementsProcessor;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_50;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.conv30_50.VersionConvertor_30_50;
import org.hl7.fhir.convertors.conv40_50.VersionConvertor_40_50;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.cql2elm.content.RepositoryFhirLibrarySourceProvider;
import org.opencds.cqf.fhir.cql.cql2elm.util.LibraryVersionSelector;
import org.opencds.cqf.fhir.cql.engine.parameters.CqlFhirParametersConverter;
import org.opencds.cqf.fhir.cr.visitor.BaseKnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.cr.visitor.VisitorHelper;
import org.opencds.cqf.fhir.utility.Libraries;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.ILibraryAdapter;

public class DataRequirementsVisitor
extends BaseKnowledgeArtifactVisitor {
    protected DataRequirementsProcessor dataRequirementsProcessor = new DataRequirementsProcessor();
    protected EvaluationSettings evaluationSettings;

    public DataRequirementsVisitor(IRepository repository, EvaluationSettings evaluationSettings) {
        super(repository);
        this.evaluationSettings = evaluationSettings;
    }

    public IBase visit(IKnowledgeArtifactAdapter adapter, IBaseParameters operationParameters) {
        Optional parameters = VisitorHelper.getResourceParameter("parameters", operationParameters);
        List artifactVersion = VisitorHelper.getStringListParameter("artifactVersion", operationParameters).orElseGet(ArrayList::new);
        List checkArtifactVersion = VisitorHelper.getStringListParameter("checkArtifactVersion", operationParameters).orElseGet(ArrayList::new);
        List forceArtifactVersion = VisitorHelper.getStringListParameter("forceArtifactVersion", operationParameters).orElseGet(ArrayList::new);
        ILibraryAdapter library = IAdapterFactory.forFhirContext((FhirContext)this.fhirContext()).createLibrary((IBaseResource)this.fhirContext().getResourceDefinition("Library").newInstance());
        library.setName("EffectiveDataRequirements");
        library.setStatus(adapter.getStatus());
        library.setType("module-definition");
        Map referencedLibraries = adapter.retrieveReferencedLibraries(this.repository);
        if (!referencedLibraries.isEmpty()) {
            LibraryManager libraryManager = this.createLibraryManager();
            referencedLibraries.forEach((k, v) -> {
                ILibraryAdapter primaryLibrary = (ILibraryAdapter)referencedLibraries.values().stream().toList().get(0);
                CqlTranslator translator = this.translateLibrary((IBaseResource)primaryLibrary.get(), libraryManager);
                CqlFhirParametersConverter cqlFhirParametersConverter = Engines.getCqlFhirParametersConverter((FhirContext)this.fhirContext());
                Map evaluationParameters = parameters.map(arg_0 -> ((CqlFhirParametersConverter)cqlFhirParametersConverter).toCqlParameters(arg_0)).orElse(null);
                Library r5Library = this.dataRequirementsProcessor.gatherDataRequirements(libraryManager, translator.getTranslatedLibrary(), this.evaluationSettings.getCqlOptions().getCqlCompilerOptions(), null, evaluationParameters, true, true);
                ILibraryAdapter convertedLibrary = this.convertAndCreateAdapter(r5Library);
                convertedLibrary.getDataRequirement().forEach(dataReq -> library.addDataRequirement((ICompositeType)dataReq.get()));
                convertedLibrary.getRelatedArtifact().forEach(x$0 -> library.addRelatedArtifact((ICompositeType)x$0));
            });
        }
        HashMap<String, IKnowledgeArtifactAdapter> gatheredResources = new HashMap<String, IKnowledgeArtifactAdapter>();
        List relatedArtifacts = this.stripInvalid(library);
        this.recursiveGather(adapter, gatheredResources, forceArtifactVersion, forceArtifactVersion, (ImmutableTriple<List<String>, List<String>, List<String>>)new ImmutableTriple((Object)artifactVersion, (Object)checkArtifactVersion, (Object)forceArtifactVersion));
        gatheredResources.values().forEach(r -> this.addRelatedArtifact(relatedArtifacts, (IKnowledgeArtifactAdapter)r));
        library.setRelatedArtifact(relatedArtifacts);
        return library.get();
    }

    private <T extends ICompositeType & IBaseHasExtensions> List<T> stripInvalid(ILibraryAdapter library) {
        return library.getRelatedArtifact().stream().filter(r -> {
            IBase resourcePath = library.resolvePath((IBase)r, "resource");
            String reference = library.fhirContext().getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU3) ? ((Reference)resourcePath).getReference() : (String)((IPrimitiveType)resourcePath).getValue();
            return reference.split("/").length > 2;
        }).map(r -> r).collect(Collectors.toList());
    }

    private ILibraryAdapter convertAndCreateAdapter(Library r5Library) {
        IAdapterFactory adapterFactory = IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion());
        return switch (this.fhirVersion()) {
            case FhirVersionEnum.DSTU3 -> {
                VersionConvertor_30_50 versionConvertor3050 = new VersionConvertor_30_50(new BaseAdvisor_30_50());
                yield adapterFactory.createLibrary((IBaseResource)versionConvertor3050.convertResource((Resource)r5Library));
            }
            case FhirVersionEnum.R4 -> {
                VersionConvertor_40_50 versionConvertor4050 = new VersionConvertor_40_50(new BaseAdvisor_40_50());
                yield adapterFactory.createLibrary((IBaseResource)versionConvertor4050.convertResource((Resource)r5Library));
            }
            case FhirVersionEnum.R5 -> adapterFactory.createLibrary((IBaseResource)r5Library);
            default -> throw new IllegalArgumentException("FHIR version %s is not supported.".formatted(this.fhirVersion().getFhirVersionString()));
        };
    }

    protected CqlTranslator getTranslator(InputStream cqlStream, LibraryManager libraryManager) {
        CqlTranslator translator;
        try {
            translator = CqlTranslator.fromStream((InputStream)cqlStream, (LibraryManager)libraryManager);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Errors occurred translating library: %s".formatted(e.getMessage()));
        }
        return translator;
    }

    protected CqlTranslator translateLibrary(IBaseResource library, LibraryManager libraryManager) {
        CqlTranslator translator = this.getTranslator(new ByteArrayInputStream((byte[])Libraries.getContent((IBaseResource)library, (String)"text/cql").orElseThrow(() -> new UnprocessableEntityException("No CQL content found for Library: %s".formatted(Libraries.getName((IBaseResource)library))))), libraryManager);
        if (!translator.getErrors().isEmpty()) {
            throw new UnprocessableEntityException(((CqlCompilerException)translator.getErrors().get(0)).getMessage());
        }
        return translator;
    }

    protected LibrarySourceProvider buildLibrarySource() {
        IAdapterFactory adapterFactory = IAdapterFactory.forFhirContext((FhirContext)this.fhirContext());
        return new RepositoryFhirLibrarySourceProvider(this.repository, adapterFactory, new LibraryVersionSelector(adapterFactory));
    }

    protected LibraryManager createLibraryManager() {
        LibrarySourceProvider librarySourceProvider = this.buildLibrarySource();
        ArrayList<LibrarySourceProvider> sourceProviders = new ArrayList<LibrarySourceProvider>(Arrays.asList(librarySourceProvider, librarySourceProvider));
        ModelManager modelManager = this.evaluationSettings.getModelCache() != null ? new ModelManager(this.evaluationSettings.getModelCache()) : new ModelManager();
        LibraryManager libraryManager = new LibraryManager(modelManager, this.evaluationSettings.getCqlOptions().getCqlCompilerOptions(), this.evaluationSettings.getLibraryCache());
        libraryManager.getLibrarySourceLoader().clearProviders();
        for (LibrarySourceProvider provider : sourceProviders) {
            libraryManager.getLibrarySourceLoader().registerProvider(provider);
        }
        return libraryManager;
    }
}

