/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.cr.visitor.BaseKnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.cr.visitor.VisitorHelper;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.VersionUtilities;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;

public class DraftVisitor
extends BaseKnowledgeArtifactVisitor {
    public DraftVisitor(IRepository repository) {
        super(repository);
    }

    public IBase visit(IKnowledgeArtifactAdapter adapter, IBaseParameters draftParameters) {
        String version = VisitorHelper.getStringParameter("version", draftParameters).orElseThrow(() -> new UnprocessableEntityException("The version argument is required"));
        IDomainResource libRes = adapter.get();
        this.checkVersionValidSemver(version);
        List removeReleaseLabelAndDescription = libRes.getExtension().stream().filter(ext -> !ext.getUrl().equals("http://hl7.org/fhir/StructureDefinition/artifact-releaseDescription") && !ext.getUrl().equals("http://hl7.org/fhir/StructureDefinition/artifact-releaseLabel")).collect(Collectors.toList());
        adapter.setExtension(removeReleaseLabelAndDescription);
        adapter.setApprovalDate(null);
        String draftVersion = version + "-draft";
        String draftVersionUrl = Canonicals.getUrl((String)adapter.getUrl()) + "|" + draftVersion;
        if (!"active".equals(adapter.getStatus())) {
            throw new PreconditionFailedException("Drafts can only be created from artifacts with status of 'active'. Resource '%s' has a status of: '%s'".formatted(adapter.getUrl(), adapter.getStatus()));
        }
        IBaseBundle existingArtifactsForUrl = SearchHelper.searchRepositoryByCanonicalWithPaging((IRepository)this.repository, (String)draftVersionUrl);
        if (!BundleHelper.getEntry((IBaseBundle)existingArtifactsForUrl).isEmpty()) {
            throw new PreconditionFailedException("A draft of Program '%s' already exists with version: '%s'. Only one draft of a program version can exist at a time.".formatted(adapter.getUrl(), draftVersionUrl));
        }
        List<IDomainResource> resourcesToCreate = this.createDraftsOfArtifactAndRelated(libRes, version, new ArrayList<IDomainResource>());
        IBaseBundle transactionBundle = BundleHelper.newBundle((FhirVersionEnum)this.fhirVersion(), null, (String)"transaction");
        List<String> urnList = resourcesToCreate.stream().map(res -> "urn:uuid:" + UUID.randomUUID().toString()).collect(Collectors.toList());
        TreeSet<String> ownedResourceUrls = this.createOwnedResourceUrlCache(resourcesToCreate);
        for (int i = 0; i < resourcesToCreate.size(); ++i) {
            IKnowledgeArtifactAdapter newResourceAdapter = IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion()).createKnowledgeArtifactAdapter(resourcesToCreate.get(i));
            this.updateUsageContextReferencesWithUrns(newResourceAdapter, resourcesToCreate, urnList);
            this.updateRelatedArtifactUrlsWithNewVersions(newResourceAdapter.combineComponentsAndDependencies(), draftVersion, ownedResourceUrls);
            IDomainResource updateIdForBundle = newResourceAdapter.copy();
            updateIdForBundle.setId(urnList.get(i));
            BundleHelper.addEntry((IBaseBundle)transactionBundle, (IBaseBackboneElement)PackageHelper.createEntry((IBaseResource)updateIdForBundle, (boolean)false));
        }
        return this.repository.transaction(transactionBundle);
    }

    private List<IDomainResource> createDraftsOfArtifactAndRelated(IDomainResource resource, String version, List<IDomainResource> resourcesToCreate) {
        String draftVersion = version + "-draft";
        IKnowledgeArtifactAdapter sourceResourceAdapter = IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion()).createKnowledgeArtifactAdapter(resource);
        String draftVersionUrl = Canonicals.getUrl((String)sourceResourceAdapter.getUrl()) + "|" + draftVersion;
        Optional existingArtifactsWithMatchingUrl = IKnowledgeArtifactAdapter.findLatestVersion((IBaseBundle)SearchHelper.searchRepositoryByCanonicalWithPaging((IRepository)this.repository, (String)draftVersionUrl));
        Optional<IKnowledgeArtifactAdapter> draftVersionAlreadyInBundle = resourcesToCreate.stream().map(res -> IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion()).createKnowledgeArtifactAdapter(res)).filter(a -> a.getUrl().equals(Canonicals.getUrl((String)draftVersionUrl)) && a.getVersion().equals(draftVersion)).findAny();
        IDomainResource newResource = null;
        if (existingArtifactsWithMatchingUrl.isPresent()) {
            newResource = (IDomainResource)existingArtifactsWithMatchingUrl.get();
        } else if (draftVersionAlreadyInBundle.isPresent()) {
            newResource = draftVersionAlreadyInBundle.get().get();
        }
        if (newResource == null) {
            sourceResourceAdapter.setEffectivePeriod(null);
            newResource = sourceResourceAdapter.copy();
            IKnowledgeArtifactAdapter newResourceAdapter = IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion()).createKnowledgeArtifactAdapter(newResource);
            newResourceAdapter.setStatus("draft");
            newResourceAdapter.setVersion(draftVersion);
            resourcesToCreate.add(newResource);
            List ownedRelatedArtifacts = sourceResourceAdapter.getOwnedRelatedArtifacts();
            for (ICompositeType ra : ownedRelatedArtifacts) {
                String url = sourceResourceAdapter.resolvePathString((IBase)ra, "resource");
                this.processReferencedResourceForDraft(url, version, resourcesToCreate);
            }
        }
        return resourcesToCreate;
    }

    private void processReferencedResourceForDraft(String canonical, String version, List<IDomainResource> transactionBundle) {
        Optional<IDomainResource> referencedResource = StringUtils.isBlank((CharSequence)canonical) ? Optional.empty() : Optional.of((IDomainResource)BundleHelper.getEntryResourceFirstRep((IBaseBundle)SearchHelper.searchRepositoryByCanonicalWithPaging((IRepository)this.repository, (IPrimitiveType)VersionUtilities.canonicalTypeForVersion((FhirVersionEnum)this.fhirVersion(), (String)canonical))));
        referencedResource.ifPresent(r -> this.createDraftsOfArtifactAndRelated((IDomainResource)r, version, transactionBundle));
    }

    private void checkVersionValidSemver(String version) throws UnprocessableEntityException {
        if (version == null || version.isEmpty()) {
            throw new UnprocessableEntityException("The version argument is required");
        }
        if (version.contains("draft")) {
            throw new UnprocessableEntityException("The version cannot contain 'draft'");
        }
        if (version.contains("/") || version.contains("\\") || version.contains("|")) {
            throw new UnprocessableEntityException("The version contains illegal characters");
        }
        Pattern pattern = Pattern.compile("^(\\d+\\.)(\\d+\\.)(\\*|\\d+)$", 2);
        Matcher matcher = pattern.matcher(version);
        boolean matchFound = matcher.find();
        if (!matchFound) {
            throw new UnprocessableEntityException("The version must be in the format MAJOR.MINOR.PATCH");
        }
    }

    private TreeSet<String> createOwnedResourceUrlCache(List<IDomainResource> resources) {
        TreeSet<String> retVal = new TreeSet<String>();
        resources.stream().map(resource -> IAdapterFactory.forFhirVersion((FhirVersionEnum)this.fhirVersion()).createKnowledgeArtifactAdapter(resource)).map(IKnowledgeArtifactAdapter::getOwnedRelatedArtifacts).flatMap(Collection::stream).map(x$0 -> IKnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)((ICompositeType)x$0))).filter(r -> r != null).map(Canonicals::getUrl).forEach(retVal::add);
        return retVal;
    }

    private void updateUsageContextReferencesWithUrns(IKnowledgeArtifactAdapter newResource, List<IDomainResource> resourceListWithOriginalIds, List<String> idListForTransactionBundle) {
        List useContexts = newResource.getUseContext();
        for (ICompositeType useContext : useContexts) {
            IBase value = newResource.resolvePath((IBase)useContext, "value");
            if (!(value instanceof IBaseReference)) continue;
            resourceListWithOriginalIds.stream().filter(resource -> (resource.getClass().getSimpleName() + "/" + resource.getIdElement().getIdPart()).equals(newResource.resolvePathString(value, "reference"))).findAny().ifPresent(resource -> {
                int indexOfDraftInIdList = resourceListWithOriginalIds.indexOf(resource);
                newResource.getModelResolver().setValue((Object)useContext, "value", (Object)VersionUtilities.referenceTypeForVersion((FhirVersionEnum)this.fhirVersion(), (String)((String)idListForTransactionBundle.get(indexOfDraftInIdList))));
            });
        }
    }

    private void updateRelatedArtifactUrlsWithNewVersions(List<IDependencyInfo> referenceList, String updatedVersion, TreeSet<String> ownedUrlCache) {
        referenceList.stream().filter(ra -> ownedUrlCache.contains(Canonicals.getUrl((String)ra.getReference()))).collect(Collectors.toList()).replaceAll(ra -> {
            ra.setReference(Canonicals.getUrl((String)ra.getReference()) + "|" + updatedVersion);
            return ra;
        });
    }
}

