/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.fhir.cr.visitor.VisitorHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.Parameters;
import org.opencds.cqf.fhir.utility.ValueSets;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IEndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersParameterComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetAdapter;
import org.opencds.cqf.fhir.utility.client.TerminologyServerClient;

public class ExpandHelper {
    private final IRepository repository;
    private final IAdapterFactory adapterFactory;
    private final TerminologyServerClient terminologyServerClient;
    public static final List<String> unsupportedParametersToRemove = List.of("canonical-version");

    public ExpandHelper(IRepository repository, TerminologyServerClient server) {
        this.repository = repository;
        this.adapterFactory = IAdapterFactory.forFhirContext((FhirContext)this.repository.fhirContext());
        this.terminologyServerClient = server;
    }

    private FhirContext fhirContext() {
        return this.repository.fhirContext();
    }

    private static void filterOutUnsupportedParameters(IParametersAdapter parameters) {
        List paramsToSet = parameters.getParameter();
        unsupportedParametersToRemove.forEach(parameterUrl -> {
            while (parameters.hasParameter(parameterUrl)) {
                parameters.setParameter(paramsToSet.stream().filter(p -> !p.getName().equals(parameterUrl)).map(IParametersParameterComponentAdapter::get).toList());
            }
        });
    }

    public void expandValueSet(IValueSetAdapter valueSet, IParametersAdapter expansionParameters, Optional<IEndpointAdapter> terminologyEndpoint, List<IValueSetAdapter> valueSets, List<String> expandedList, Date expansionTimestamp) {
        if (expandedList.contains(valueSet.getUrl())) {
            return;
        }
        ExpandHelper.filterOutUnsupportedParameters(expansionParameters);
        String authoritativeSourceUrl = valueSet.getExtension().stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/valueset-authoritativeSource")).findFirst().map(url -> ((IPrimitiveType)url.getValue()).getValueAsString()).map(url -> TerminologyServerClient.getAddressBase((String)url, (FhirContext)this.fhirContext())).orElse(null);
        if (terminologyEndpoint.isPresent() && (authoritativeSourceUrl == null || authoritativeSourceUrl.equals(terminologyEndpoint.get().getAddress()))) {
            this.terminologyServerExpand(valueSet, expansionParameters, terminologyEndpoint.get());
        } else if (valueSet.hasSimpleCompose()) {
            valueSet.naiveExpand();
        } else if (valueSet.hasGroupingCompose()) {
            this.groupExpand(valueSet, expansionParameters, terminologyEndpoint, valueSets, expandedList, this.repository, expansionTimestamp);
        } else if (valueSet.hasCompose()) {
            throw new UnprocessableEntityException("Cannot expand ValueSet without a terminology server: " + String.valueOf(valueSet.getId()));
        }
        expandedList.add(valueSet.getUrl());
    }

    private void terminologyServerExpand(IValueSetAdapter valueSet, IParametersAdapter expansionParameters, IEndpointAdapter terminologyEndpoint) {
        IValueSetAdapter expandedValueSet = (IValueSetAdapter)this.adapterFactory.createResource(this.terminologyServerClient.expand(valueSet, terminologyEndpoint, expansionParameters));
        if (!valueSet.hasVersion()) {
            valueSet.setVersion(expandedValueSet.getVersion());
        }
        valueSet.setExpansion(expandedValueSet.getExpansion());
    }

    private void groupExpand(IValueSetAdapter valueSet, IParametersAdapter expansionParameters, Optional<IEndpointAdapter> terminologyEndpoint, List<IValueSetAdapter> valueSets, List<String> expandedList, IRepository repository, Date expansionTimestamp) {
        IBaseBackboneElement expansion = this.expandIncludes(valueSet, expansionParameters, terminologyEndpoint, valueSets, expandedList, repository, expansionTimestamp);
        try {
            ValueSets.setExpansionTimestamp((FhirContext)this.fhirContext(), (IBase)expansion, (Date)(expansionTimestamp == null ? new Date() : expansionTimestamp));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
        valueSet.setExpansion(expansion);
    }

    private IBaseBackboneElement expandIncludes(IValueSetAdapter valueSet, IParametersAdapter expansionParameters, Optional<IEndpointAdapter> terminologyEndpoint, List<IValueSetAdapter> valueSets, List<String> expandedList, IRepository repository, Date expansionTimestamp) {
        IBaseBackboneElement expansion = valueSet.newExpansion();
        valueSet.getValueSetIncludes().forEach(reference -> {
            String version;
            String url = Canonicals.getUrl((String)reference);
            IValueSetAdapter includedVS = this.getIncludedValueSet(terminologyEndpoint, valueSets, repository, (String)reference, url, version = Canonicals.getVersion((String)reference));
            if (includedVS != null) {
                if (!expandedList.contains(url)) {
                    this.expandIncluded(expansionParameters, terminologyEndpoint, valueSets, expandedList, expansionTimestamp, includedVS);
                }
                this.addCodesToExpansion(expansion, includedVS);
                if (includedVS.hasNaiveParameter() && !valueSet.hasNaiveParameter()) {
                    ValueSets.addParameterToExpansion((FhirContext)this.fhirContext(), (IBase)expansion, (IBaseBackboneElement)valueSet.createNaiveParameter());
                }
            } else {
                throw new UnprocessableEntityException("Terminology Server expansion failed for ValueSet '" + valueSet.getUrl() + "' because Child ValueSet '" + reference + "' could not be found. ");
            }
        });
        return expansion;
    }

    private void addCodesToExpansion(IBaseBackboneElement expansion, IValueSetAdapter includedVS) {
        Optional.ofNullable(ValueSets.getCodesInExpansion((FhirContext)this.fhirContext(), (IBaseResource)includedVS.get())).ifPresent(e -> e.forEach(code -> {
            List existingCodes = ValueSets.getCodesInExpansion((FhirContext)this.fhirContext(), (IBase)expansion);
            if (existingCodes == null || existingCodes.stream().noneMatch(expandedCode -> code.getSystem().equals(expandedCode.getSystem()) && code.getCode().equals(expandedCode.getCode()) && (StringUtils.isEmpty((CharSequence)code.getVersion()) || code.getVersion().equals(expandedCode.getVersion())))) {
                try {
                    ValueSets.addCodeToExpansion((FhirContext)this.fhirContext(), (IBase)expansion, (Code)code);
                }
                catch (Exception ex) {
                    throw new UnprocessableEntityException("Encountered exception attempting to expand ValueSet %s: %s".formatted(includedVS.get().getId(), ex.getMessage()));
                }
            }
        }));
    }

    private IValueSetAdapter getIncludedValueSet(Optional<IEndpointAdapter> terminologyEndpoint, List<IValueSetAdapter> valueSets, IRepository repository, String reference, String url, String version) {
        return valueSets.stream().filter(v -> v.getUrl().equals(url) && (version == null || v.getVersion().equals(version))).findFirst().orElseGet(() -> {
            if (terminologyEndpoint.isPresent()) {
                return this.terminologyServerClient.getResource((IEndpointAdapter)terminologyEndpoint.get(), reference).map(r -> (IValueSetAdapter)this.adapterFactory.createResource((IBaseResource)r)).orElse(null);
            }
            return VisitorHelper.tryGetLatestVersion(reference, repository).map(a -> (IValueSetAdapter)a).orElse(null);
        });
    }

    private void expandIncluded(IParametersAdapter expansionParameters, Optional<IEndpointAdapter> terminologyEndpoint, List<IValueSetAdapter> valueSets, List<String> expandedList, Date expansionTimestamp, IValueSetAdapter includedVS) {
        List newParams;
        IParametersAdapter childExpParams = (IParametersAdapter)this.adapterFactory.createResource(expansionParameters.copy());
        if (childExpParams.hasParameter("url")) {
            newParams = childExpParams.getParameter().stream().filter(p -> !p.getName().equals("url")).collect(Collectors.toList());
            if (includedVS.hasUrl()) {
                newParams.add(this.adapterFactory.createParametersParameter((IBaseBackboneElement)(this.fhirContext().getVersion().getVersion() == FhirVersionEnum.DSTU3 ? Parameters.newUriPart((FhirContext)this.fhirContext(), (String)"url", (String)includedVS.getUrl(), (IBase[])new IBase[0]) : Parameters.newUrlPart((FhirContext)this.fhirContext(), (String)"url", (String)includedVS.getUrl(), (IBase[])new IBase[0]))));
            }
            childExpParams.setParameter(newParams.stream().map(IParametersParameterComponentAdapter::get).toList());
        }
        if (childExpParams.hasParameter("valueSetVersion")) {
            newParams = childExpParams.getParameter().stream().filter(p -> !p.getName().equals("valueSetVersion")).collect(Collectors.toList());
            if (includedVS.hasVersion()) {
                newParams.add(this.adapterFactory.createParametersParameter((IBaseBackboneElement)Parameters.newStringPart((FhirContext)this.fhirContext(), (String)"valueSetVersion", (String)includedVS.getVersion(), (IBase[])new IBase[0])));
            }
            childExpParams.setParameter(newParams.stream().map(IParametersParameterComponentAdapter::get).toList());
        }
        this.expandValueSet(includedVS, childExpParams, terminologyEndpoint, valueSets, expandedList, expansionTimestamp);
    }
}

