/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.opencds.cqf.fhir.cr.visitor.BaseKnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.cr.visitor.VisitorHelper;
import org.opencds.cqf.fhir.cr.visitor.dstu3.CRMIReleaseExperimentalBehavior;
import org.opencds.cqf.fhir.cr.visitor.r4.CRMIReleaseExperimentalBehavior;
import org.opencds.cqf.fhir.cr.visitor.r5.CRMIReleaseExperimentalBehavior;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IEndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.ILibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.MeasureAdapter;
import org.opencds.cqf.fhir.utility.client.TerminologyServerClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseVisitor
extends BaseKnowledgeArtifactVisitor {
    private static final String NOT_SUPPORTED = " not supported";
    private static final String ACTIVE = "active";
    private static final String DRAFT = "draft";
    private Logger logger = LoggerFactory.getLogger(ReleaseVisitor.class);
    private static final String DEPENDSON = "depends-on";
    private static final String VALUESET = "ValueSet";
    private static final String CODESYSTEM = "CodeSystem";
    protected final TerminologyServerClient terminologyServerClient;

    public ReleaseVisitor(IRepository repository) {
        super(repository);
        this.terminologyServerClient = new TerminologyServerClient(this.fhirContext());
    }

    public ReleaseVisitor(IRepository repository, TerminologyServerClient terminologyServerClient) {
        super(repository);
        this.terminologyServerClient = terminologyServerClient;
    }

    public IBase visit(IKnowledgeArtifactAdapter rootAdapter, IBaseParameters operationParameters) {
        IDomainResource rootLibrary = rootAdapter.get();
        Date current = new Date();
        boolean latestFromTxServer = VisitorHelper.getBooleanParameter("latestFromTxServer", operationParameters).orElse(false);
        Optional<IEndpointAdapter> terminologyEndpoint = VisitorHelper.getResourceParameter("terminologyEndpoint", operationParameters).map(r -> (IEndpointAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)r));
        if (latestFromTxServer && terminologyEndpoint.isEmpty()) {
            throw new UnprocessableEntityException("latestFromTxServer = true but no terminologyEndpoint is available");
        }
        String version = VisitorHelper.getStringParameter("version", operationParameters).orElseThrow(() -> new UnprocessableEntityException("Version must be present"));
        String releaseLabel = VisitorHelper.getStringParameter("releaseLabel", operationParameters).orElse("");
        Optional<String> versionBehavior = VisitorHelper.getStringParameter("versionBehavior", operationParameters);
        Optional<String> requireNonExperimental = VisitorHelper.getStringParameter("requireNonExperimental", operationParameters).map(e -> {
            if (rootAdapter.getExperimental()) {
                return "none";
            }
            return e;
        });
        this.checkReleaseVersion(version, versionBehavior);
        this.checkReleasePreconditions(rootAdapter, rootAdapter.getApprovalDate());
        this.updateReleaseLabel((IBaseResource)rootLibrary, releaseLabel);
        String existingVersion = rootAdapter.hasVersion() ? rootAdapter.getVersion().replace("-draft", "") : null;
        String releaseVersion = this.getReleaseVersion(version, versionBehavior, existingVersion, this.fhirVersion()).orElseThrow(() -> new UnprocessableEntityException("Could not resolve a version for the root artifact."));
        ICompositeType rootEffectivePeriod = rootAdapter.getEffectivePeriod();
        HashMap<String, Boolean> ownedComponentMap = new HashMap<String, Boolean>();
        ownedComponentMap.put(rootAdapter.getCanonical(), true);
        List<IDomainResource> updatedComponents = this.updateAllComponents(rootAdapter, latestFromTxServer, ownedComponentMap, terminologyEndpoint.orElse(null));
        updatedComponents.forEach(r -> this.checkNonExperimental((IDomainResource)r, requireNonExperimental, this.repository));
        List<IDomainResource> updatedOwnedComponents = updatedComponents.stream().filter(r -> (Boolean)ownedComponentMap.get(((IKnowledgeArtifactAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)r)).getCanonical())).toList();
        updatedOwnedComponents.forEach(r -> ReleaseVisitor.updateMetadata((IKnowledgeArtifactAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)r), releaseVersion, rootEffectivePeriod, current));
        ArrayList rootArtifactOriginalDependencies = new ArrayList(rootAdapter.getDependencies());
        List originalDependenciesWithExtensions = rootArtifactOriginalDependencies.stream().filter(dep -> dep.getExtension() != null && !dep.getExtension().isEmpty()).collect(Collectors.toList());
        List noDeps = rootAdapter.getRelatedArtifact();
        noDeps.removeIf(ra -> IKnowledgeArtifactAdapter.getRelatedArtifactType((ICompositeType)ra).equalsIgnoreCase(DEPENDSON));
        rootAdapter.setRelatedArtifact(noDeps);
        Optional expansionParameters = rootAdapter.getExpansionParameters();
        List systemVersionParams = expansionParameters.map(p -> VisitorHelper.getStringListParameter("system-version", p).orElse(null)).orElse(new ArrayList());
        List canonicalVersionParams = expansionParameters.map(p -> VisitorHelper.getStringListParameter("canonical-version", p).orElse(null)).orElse(new ArrayList());
        HashSet<String> gatheredResources = new HashSet<String>();
        this.gatherDependencies(rootAdapter, rootAdapter, gatheredResources, updatedComponents, new HashMap<String, IDomainResource>(), systemVersionParams, canonicalVersionParams, latestFromTxServer, terminologyEndpoint.orElse(null));
        if (rootAdapter.get().fhirType().equals("Library")) {
            ((ILibraryAdapter)rootAdapter).setExpansionParameters(systemVersionParams, canonicalVersionParams);
        }
        List relatedArtifacts = rootAdapter.getRelatedArtifact();
        ArrayList<Object> distinctResolvedRelatedArtifacts = new ArrayList<Object>(relatedArtifacts);
        distinctResolvedRelatedArtifacts.clear();
        for (Object resolvedRelatedArtifact : relatedArtifacts) {
            String relatedArtifactReference = IKnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)resolvedRelatedArtifact);
            boolean isDistinct = distinctResolvedRelatedArtifacts.stream().noneMatch(arg_0 -> ReleaseVisitor.lambda$visit$11(relatedArtifactReference, (ICompositeType)resolvedRelatedArtifact, arg_0));
            if (!isDistinct) continue;
            distinctResolvedRelatedArtifacts.add(resolvedRelatedArtifact);
            originalDependenciesWithExtensions.stream().filter(arg_0 -> ReleaseVisitor.lambda$visit$12(relatedArtifactReference, (ICompositeType)resolvedRelatedArtifact, arg_0)).findFirst().ifPresent(arg_0 -> ReleaseVisitor.lambda$visit$14((ICompositeType)resolvedRelatedArtifact, originalDependenciesWithExtensions, relatedArtifactReference, arg_0));
        }
        IBaseBundle transactionBundle = BundleHelper.newBundle((FhirVersionEnum)this.fhirVersion(), null, (String)"transaction");
        for (IDomainResource artifact : updatedComponents) {
            IBaseBackboneElement entry2 = PackageHelper.createEntry((IBaseResource)artifact, (boolean)true);
            BundleHelper.addEntry((IBaseBundle)transactionBundle, (IBaseBackboneElement)entry2);
        }
        try {
            this.findArtifactCommentsToUpdate((IBaseResource)rootLibrary, releaseVersion, this.repository).forEach(entry -> BundleHelper.addEntry((IBaseBundle)transactionBundle, (IBaseBackboneElement)entry));
        }
        catch (Exception e2) {
            this.logger.error("Error encountered attempting to update ArtifactComments: {}", (Object)e2.getMessage());
        }
        rootAdapter.setRelatedArtifact(distinctResolvedRelatedArtifacts);
        return this.repository.transaction(transactionBundle);
    }

    private static void updateMetadata(IKnowledgeArtifactAdapter artifactAdapter, String version, ICompositeType rootEffectivePeriod, Date current) {
        artifactAdapter.setDate(current == null ? new Date() : current);
        artifactAdapter.setStatus(ACTIVE);
        artifactAdapter.setVersion(version);
        ReleaseVisitor.propagateEffectivePeriod(rootEffectivePeriod, artifactAdapter);
    }

    private List<IDomainResource> updateAllComponents(IKnowledgeArtifactAdapter artifactAdapter, boolean latestFromTxServer, Map<String, Boolean> updatedResourceReferences, IEndpointAdapter endpoint) throws NotImplementedOperationException, ResourceNotFoundException {
        ArrayList<IDomainResource> updatedComponents = new ArrayList<IDomainResource>();
        updatedComponents.add(artifactAdapter.get());
        for (ICompositeType component : artifactAdapter.getComponents()) {
            Optional<IKnowledgeArtifactAdapter> latest;
            boolean alreadyUpdated;
            String preReleaseReference = IKnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)component);
            boolean isOwned = IKnowledgeArtifactAdapter.checkIfRelatedArtifactIsOwned((ICompositeType)component);
            if (StringUtils.isBlank((CharSequence)preReleaseReference) || (alreadyUpdated = this.checkIfReferenceInList(preReleaseReference, updatedComponents).isPresent()) || !(latest = this.latestComponentRespectingVersions(preReleaseReference, endpoint, latestFromTxServer, isOwned)).isPresent()) continue;
            updatedResourceReferences.put(latest.get().getCanonical(), isOwned);
            updatedComponents.addAll(this.updateAllComponents(latest.get(), latestFromTxServer, updatedResourceReferences, endpoint));
        }
        return updatedComponents;
    }

    private Optional<IKnowledgeArtifactAdapter> latestComponentRespectingVersions(String preReleaseReference, IEndpointAdapter endpoint, boolean latestFromTxServer, boolean isOwned) {
        Optional<IKnowledgeArtifactAdapter> latest = Optional.empty();
        String resourceType = Canonicals.getResourceType((String)preReleaseReference);
        String prereleaseReferenceVersion = Canonicals.getVersion((String)preReleaseReference);
        latest = isOwned ? VisitorHelper.tryGetLatestVersion(preReleaseReference, this.repository) : (resourceType != null && resourceType.equals(VALUESET) && prereleaseReferenceVersion == null && latestFromTxServer ? this.terminologyServerClient.getLatestNonDraftResource(endpoint, preReleaseReference).map(r -> (IKnowledgeArtifactAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)r)) : VisitorHelper.tryGetLatestVersionWithStatus(preReleaseReference, this.repository, ACTIVE).or(() -> VisitorHelper.tryGetLatestVersionExceptStatus(preReleaseReference, this.repository, DRAFT)));
        return latest;
    }

    private void gatherDependencies(IKnowledgeArtifactAdapter rootAdapter, IKnowledgeArtifactAdapter artifactAdapter, Set<String> gatheredResources, List<IDomainResource> releasedResources, Map<String, IDomainResource> alreadyUpdatedDependencies, List<String> systemVersionExpansionParameters, List<String> canonicalVersionExpansionParameters, boolean latestFromTxServer, IEndpointAdapter endpoint) {
        if (artifactAdapter == null) {
            return;
        }
        if (!gatheredResources.contains(artifactAdapter.getCanonical())) {
            gatheredResources.add(artifactAdapter.getCanonical());
            for (ICompositeType component : artifactAdapter.getComponents()) {
                Optional<IKnowledgeArtifactAdapter> maybeLatest = this.updateComponentAndCache(component, releasedResources, alreadyUpdatedDependencies);
                ICompositeType componentToDependency = IKnowledgeArtifactAdapter.newRelatedArtifact((FhirVersionEnum)this.fhirVersion(), (String)DEPENDSON, (String)maybeLatest.map(IKnowledgeArtifactAdapter::getCanonical).orElse(IKnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)component)), (String)maybeLatest.map(IKnowledgeArtifactAdapter::getDescriptor).orElse(null));
                String resourceType = maybeLatest.map(r -> Canonicals.getResourceType((String)r.getCanonical())).orElse(Canonicals.getResourceType((String)IKnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)component)));
                this.ensureResourceTypeExtension(resourceType, componentToDependency);
                List updatedRelatedArtifacts = artifactAdapter.getRelatedArtifact();
                updatedRelatedArtifacts.add(componentToDependency);
                artifactAdapter.setRelatedArtifact(updatedRelatedArtifacts);
            }
            List dependencies = artifactAdapter.getDependencies();
            for (IDependencyInfo dependency : dependencies) {
                IKnowledgeArtifactAdapter dependencyAdapter = null;
                String dependencyUrl = Canonicals.getUrl((String)dependency.getReference());
                if (dependencyUrl == null) {
                    dependencyUrl = dependency.getReference();
                }
                if (!alreadyUpdatedDependencies.containsKey(dependencyUrl)) {
                    Optional<IKnowledgeArtifactAdapter> maybeAdapter = this.tryResolveDependency(dependency, canonicalVersionExpansionParameters, systemVersionExpansionParameters, latestFromTxServer, endpoint);
                    if (maybeAdapter.isPresent()) {
                        dependencyAdapter = maybeAdapter.get();
                        alreadyUpdatedDependencies.put(dependencyAdapter.getUrl(), dependencyAdapter.get());
                        String url = Canonicals.getUrl((String)dependencyAdapter.getUrl()) + "|" + dependencyAdapter.getVersion();
                        IBaseBundle existingArtifactsForUrl = SearchHelper.searchRepositoryByCanonicalWithPaging((IRepository)this.repository, (String)url);
                        if (BundleHelper.getEntry((IBaseBundle)existingArtifactsForUrl).isEmpty()) {
                            this.repository.create((IBaseResource)dependencyAdapter.get());
                        }
                    } else {
                        alreadyUpdatedDependencies.put(dependencyUrl, null);
                    }
                } else {
                    if (alreadyUpdatedDependencies.get(dependencyUrl) == null) continue;
                    dependencyAdapter = (IKnowledgeArtifactAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)((IBaseResource)alreadyUpdatedDependencies.get(dependencyUrl)));
                }
                if (dependencyAdapter != null) {
                    dependency.setReference(dependencyAdapter.getCanonical());
                    this.gatherDependencies(rootAdapter, dependencyAdapter, gatheredResources, releasedResources, alreadyUpdatedDependencies, systemVersionExpansionParameters, canonicalVersionExpansionParameters, latestFromTxServer, endpoint);
                }
                if (artifactAdapter.getUrl().equals(rootAdapter.getUrl())) continue;
                ICompositeType newDep = IKnowledgeArtifactAdapter.newRelatedArtifact((FhirVersionEnum)this.fhirVersion(), (String)DEPENDSON, (String)dependency.getReference(), (String)(dependencyAdapter != null ? dependencyAdapter.getDescriptor() : null));
                this.ensureResourceTypeExtension(this.getResourceType(dependency), newDep);
                List updatedRelatedArtifacts = rootAdapter.getRelatedArtifact();
                updatedRelatedArtifacts.add(newDep);
                rootAdapter.setRelatedArtifact(updatedRelatedArtifacts);
            }
            this.extractMeasureDirectReferenceCodes(rootAdapter, artifactAdapter);
        }
    }

    private void ensureResourceTypeExtension(String resourceType, ICompositeType newDep) {
        if (resourceType != null && (resourceType.equals(VALUESET) || resourceType.equals(CODESYSTEM))) {
            if (this.fhirVersion().equals((Object)FhirVersionEnum.R4)) {
                ((org.hl7.fhir.r4.model.RelatedArtifact)newDep).getResourceElement().addExtension("http://hl7.org/fhir/StructureDefinition/cqf-resourceType", (Type)new CodeType(resourceType));
            } else if (this.fhirVersion().equals((Object)FhirVersionEnum.R5)) {
                ((RelatedArtifact)newDep).getResourceElement().addExtension("http://hl7.org/fhir/StructureDefinition/cqf-resourceType", (DataType)new org.hl7.fhir.r5.model.CodeType(resourceType));
            }
        }
    }

    private void extractMeasureDirectReferenceCodes(IKnowledgeArtifactAdapter rootAdapter, IKnowledgeArtifactAdapter artifactAdapter) {
        if (artifactAdapter instanceof MeasureAdapter) {
            MeasureAdapter measureAdapter = (MeasureAdapter)artifactAdapter;
            org.opencds.cqf.fhir.cr.visitor.r4.ReleaseVisitor.extractDirectReferenceCodes(rootAdapter, measureAdapter.get());
        } else if (artifactAdapter instanceof org.opencds.cqf.fhir.utility.adapter.r5.MeasureAdapter) {
            org.opencds.cqf.fhir.utility.adapter.r5.MeasureAdapter measureAdapter = (org.opencds.cqf.fhir.utility.adapter.r5.MeasureAdapter)artifactAdapter;
            org.opencds.cqf.fhir.cr.visitor.r5.ReleaseVisitor.extractDirectReferenceCodes(rootAdapter, measureAdapter.get());
        }
    }

    private Optional<IKnowledgeArtifactAdapter> tryResolveDependency(IDependencyInfo dependency, List<String> canonicalVersionExpansionParameters, List<String> systemVersionExpansionParameters, boolean latestFromTxServer, IEndpointAdapter endpoint) {
        String resourceType = this.getResourceType(dependency);
        if (StringUtils.isBlank((CharSequence)Canonicals.getVersion((String)dependency.getReference()))) {
            this.getExpansionParametersVersion(dependency, resourceType, canonicalVersionExpansionParameters, systemVersionExpansionParameters).map(Canonicals::getVersion).ifPresent(version -> dependency.setReference(dependency.getReference() + "|" + version));
        }
        Optional<IKnowledgeArtifactAdapter> maybeAdapter = Optional.empty();
        maybeAdapter = !StringUtils.isBlank((CharSequence)Canonicals.getVersion((String)dependency.getReference())) ? Optional.ofNullable(this.getArtifactByCanonical(dependency.getReference(), this.repository)) : this.tryFindLatestDependency(dependency.getReference(), resourceType, latestFromTxServer, endpoint);
        return maybeAdapter;
    }

    private Optional<IKnowledgeArtifactAdapter> tryFindLatestDependency(String reference, String resourceType, boolean latestFromTxServer, IEndpointAdapter endpoint) {
        Optional<IKnowledgeArtifactAdapter> maybeAdapter = Optional.empty();
        maybeAdapter = resourceType != null && resourceType.equals(VALUESET) && latestFromTxServer ? this.terminologyServerClient.getLatestNonDraftResource(endpoint, reference).map(r -> (IKnowledgeArtifactAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)r)) : VisitorHelper.tryGetLatestVersionWithStatus(reference, this.repository, ACTIVE).or(() -> VisitorHelper.tryGetLatestVersionExceptStatus(reference, this.repository, DRAFT));
        return maybeAdapter;
    }

    private <T extends ICompositeType & IBaseHasExtensions> Optional<IKnowledgeArtifactAdapter> updateComponentAndCache(T component, List<IDomainResource> releasedResources, Map<String, IDomainResource> alreadyUpdatedDependencies) {
        Optional<IKnowledgeArtifactAdapter> maybeLatest = this.getLatestArtifactAndThrowErrorIfOwnedMissing(component, releasedResources);
        if (maybeLatest.isPresent()) {
            this.updateCacheAndReference(component, maybeLatest.get(), alreadyUpdatedDependencies);
        }
        return maybeLatest;
    }

    private <T extends ICompositeType & IBaseHasExtensions> Optional<IKnowledgeArtifactAdapter> getLatestArtifactAndThrowErrorIfOwnedMissing(T component, List<IDomainResource> releasedResources) {
        String reference = IKnowledgeArtifactAdapter.getRelatedArtifactReference(component);
        Optional<IKnowledgeArtifactAdapter> resource = Optional.ofNullable(reference).map(r -> this.checkIfReferenceInList((String)r, releasedResources).orElse(null));
        if (IKnowledgeArtifactAdapter.checkIfRelatedArtifactIsOwned(component) && resource.isEmpty()) {
            throw new InternalErrorException("Owned resource reference not found during release: " + reference);
        }
        return resource;
    }

    private <T extends ICompositeType & IBaseHasExtensions> void updateCacheAndReference(T component, IKnowledgeArtifactAdapter updatedResource, Map<String, IDomainResource> alreadyUpdatedDependencies) {
        if (!alreadyUpdatedDependencies.containsKey(updatedResource.getUrl())) {
            alreadyUpdatedDependencies.put(updatedResource.getUrl(), updatedResource.get());
        }
        IKnowledgeArtifactAdapter.setRelatedArtifactReference(component, (String)updatedResource.getCanonical(), (String)updatedResource.getDescriptor());
    }

    private Optional<String> getExpansionParametersVersion(IDependencyInfo dependency, String resourceType, List<String> canonicalVersionExpansionParameters, List<String> systemVersionExpansionParameters) {
        Optional<String> expansionParametersVersion = Optional.empty();
        if (resourceType == null || resourceType.equals(CODESYSTEM)) {
            expansionParametersVersion = systemVersionExpansionParameters.stream().filter(canonical -> !StringUtils.isBlank((CharSequence)Canonicals.getUrl((String)canonical))).filter(canonical -> Canonicals.getUrl((String)canonical).equals(dependency.getReference())).findAny();
        } else if (resourceType.equals(VALUESET)) {
            expansionParametersVersion = canonicalVersionExpansionParameters.stream().filter(canonical -> Canonicals.getUrl((String)canonical).equals(dependency.getReference())).findAny();
        }
        return expansionParametersVersion;
    }

    private String getResourceType(IDependencyInfo dependency) {
        return Canonicals.getResourceType((String)dependency.getReference()) == null ? null : SearchHelper.getResourceType((IRepository)this.repository, (IDependencyInfo)dependency).getSimpleName();
    }

    private void checkNonExperimental(IDomainResource resource, Optional<String> experimentalBehavior, IRepository repository) throws UnprocessableEntityException {
        if (resource instanceof MetadataResource) {
            MetadataResource metadataResource2 = (MetadataResource)resource;
            CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes code = experimentalBehavior.isPresent() ? CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.fromCode(experimentalBehavior.get()) : CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NULL;
            org.opencds.cqf.fhir.cr.visitor.dstu3.ReleaseVisitor.checkNonExperimental(metadataResource2, code, repository, this.logger);
        } else if (resource instanceof org.hl7.fhir.r4.model.MetadataResource) {
            org.hl7.fhir.r4.model.MetadataResource metadataResource1 = (org.hl7.fhir.r4.model.MetadataResource)resource;
            CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes code = experimentalBehavior.isPresent() ? CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.fromCode(experimentalBehavior.get()) : CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NULL;
            org.opencds.cqf.fhir.cr.visitor.r4.ReleaseVisitor.checkNonExperimental(metadataResource1, code, repository, this.logger);
        } else if (resource instanceof org.hl7.fhir.r5.model.MetadataResource) {
            org.hl7.fhir.r5.model.MetadataResource metadataResource = (org.hl7.fhir.r5.model.MetadataResource)resource;
            CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes code = experimentalBehavior.isPresent() ? CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.fromCode(experimentalBehavior.get()) : CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NULL;
            org.opencds.cqf.fhir.cr.visitor.r5.ReleaseVisitor.checkNonExperimental(metadataResource, code, repository, this.logger);
        } else {
            throw new UnprocessableEntityException(resource.getClass().getName() + NOT_SUPPORTED);
        }
    }

    private static void propagateEffectivePeriod(ICompositeType rootEffectivePeriod, IKnowledgeArtifactAdapter artifactAdapter) {
        if (rootEffectivePeriod instanceof org.hl7.fhir.dstu3.model.Period) {
            org.hl7.fhir.dstu3.model.Period period2 = (org.hl7.fhir.dstu3.model.Period)rootEffectivePeriod;
            org.opencds.cqf.fhir.cr.visitor.dstu3.ReleaseVisitor.propagateEffectivePeriod(period2, artifactAdapter);
        } else if (rootEffectivePeriod instanceof Period) {
            Period period1 = (Period)rootEffectivePeriod;
            org.opencds.cqf.fhir.cr.visitor.r4.ReleaseVisitor.propagateEffectivePeriod(period1, artifactAdapter);
        } else if (rootEffectivePeriod instanceof org.hl7.fhir.r5.model.Period) {
            org.hl7.fhir.r5.model.Period period = (org.hl7.fhir.r5.model.Period)rootEffectivePeriod;
            org.opencds.cqf.fhir.cr.visitor.r5.ReleaseVisitor.propagateEffectivePeriod(period, artifactAdapter);
        } else {
            throw new UnprocessableEntityException(rootEffectivePeriod.getClass().getName() + NOT_SUPPORTED);
        }
    }

    private IKnowledgeArtifactAdapter getArtifactByCanonical(String inputReference, IRepository repository) {
        List matchingResources = VisitorHelper.getMetadataResourcesFromBundle(SearchHelper.searchRepositoryByCanonicalWithPaging((IRepository)repository, (String)inputReference)).stream().map(r -> (IKnowledgeArtifactAdapter)IAdapterFactory.createAdapterForResource((IBaseResource)r)).collect(Collectors.toList());
        if (matchingResources.isEmpty()) {
            return null;
        }
        if (matchingResources.size() == 1) {
            return (IKnowledgeArtifactAdapter)matchingResources.get(0);
        }
        this.logger.info("Multiple resources found matching {}, used the first one", (Object)inputReference);
        return (IKnowledgeArtifactAdapter)matchingResources.get(0);
    }

    private Optional<String> getReleaseVersion(String version, Optional<String> versionBehavior, String existingVersion, FhirVersionEnum fhirVersion) throws UnprocessableEntityException {
        switch (fhirVersion) {
            case DSTU3: {
                return org.opencds.cqf.fhir.cr.visitor.dstu3.ReleaseVisitor.getReleaseVersion(version, versionBehavior, existingVersion);
            }
            case R4: {
                return org.opencds.cqf.fhir.cr.visitor.r4.ReleaseVisitor.getReleaseVersion(version, versionBehavior, existingVersion);
            }
            case R5: {
                return org.opencds.cqf.fhir.cr.visitor.r5.ReleaseVisitor.getReleaseVersion(version, versionBehavior, existingVersion);
            }
        }
        throw new UnprocessableEntityException("Unsupported version of FHIR: %s".formatted(fhirVersion.getFhirVersionString()));
    }

    private void updateReleaseLabel(IBaseResource artifact, String releaseLabel) throws IllegalArgumentException {
        if (artifact instanceof MetadataResource) {
            MetadataResource resource2 = (MetadataResource)artifact;
            org.opencds.cqf.fhir.cr.visitor.dstu3.ReleaseVisitor.updateReleaseLabel(resource2, releaseLabel);
        } else if (artifact instanceof org.hl7.fhir.r4.model.MetadataResource) {
            org.hl7.fhir.r4.model.MetadataResource resource1 = (org.hl7.fhir.r4.model.MetadataResource)artifact;
            org.opencds.cqf.fhir.cr.visitor.r4.ReleaseVisitor.updateReleaseLabel(resource1, releaseLabel);
        } else if (artifact instanceof org.hl7.fhir.r5.model.MetadataResource) {
            org.hl7.fhir.r5.model.MetadataResource resource = (org.hl7.fhir.r5.model.MetadataResource)artifact;
            org.opencds.cqf.fhir.cr.visitor.r5.ReleaseVisitor.updateReleaseLabel(resource, releaseLabel);
        } else {
            throw new UnprocessableEntityException(artifact.getClass().getName() + NOT_SUPPORTED);
        }
    }

    private Optional<IKnowledgeArtifactAdapter> checkIfReferenceInList(String referenceToCheck, List<IDomainResource> resourceList) {
        for (IDomainResource resource : resourceList) {
            String currentResourceURL;
            String referenceURL = Canonicals.getUrl((String)referenceToCheck);
            if (!referenceURL.equals(currentResourceURL = IAdapterFactory.forFhirVersion((FhirVersionEnum)resource.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(resource).getUrl())) continue;
            return Optional.of(resource).map(res -> IAdapterFactory.forFhirVersion((FhirVersionEnum)res.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(res));
        }
        return Optional.empty();
    }

    private void checkReleasePreconditions(IKnowledgeArtifactAdapter artifact, Date approvalDate) throws PreconditionFailedException {
        if (artifact == null) {
            throw new ResourceNotFoundException("Resource not found.");
        }
        if (!artifact.getStatus().equals(DRAFT)) {
            throw new PreconditionFailedException("Resource with ID: '%s' does not have a status of 'draft'.".formatted(artifact.get().getIdElement().getIdPart()));
        }
        if (artifact.getDate() == null) {
            throw new PreconditionFailedException("The artifact must have a last modified date (indicated by date) before it is eligible for release.");
        }
        if (approvalDate == null) {
            throw new PreconditionFailedException("The artifact must be approved (indicated by approvalDate) before it is eligible for release.");
        }
        if (approvalDate.before(artifact.getDate())) {
            throw new PreconditionFailedException("The artifact was approved on '%s', but was last modified on '%s'. An approval must be provided after the most-recent update.".formatted(approvalDate, artifact.getDate()));
        }
    }

    private void checkReleaseVersion(String version, Optional<String> versionBehavior) throws UnprocessableEntityException {
        if (versionBehavior.isEmpty()) {
            throw new UnprocessableEntityException("'versionBehavior' must be provided as an argument to the $release operation. Valid values are 'default', 'check', 'force'.");
        }
        this.checkVersionValidSemver(version);
    }

    private void checkVersionValidSemver(String version) throws UnprocessableEntityException {
        if (version == null || version.isEmpty()) {
            throw new UnprocessableEntityException("The version argument is required");
        }
        if (version.contains(DRAFT)) {
            throw new UnprocessableEntityException("The version cannot contain 'draft'");
        }
        if (version.contains("/") || version.contains("\\") || version.contains("|")) {
            throw new UnprocessableEntityException("The version contains illegal characters");
        }
        Pattern pattern = Pattern.compile("^(\\d+\\.)(\\d+\\.)(\\*|\\d+)$", 2);
        Matcher matcher = pattern.matcher(version);
        boolean matchFound = matcher.find();
        if (!matchFound) {
            throw new UnprocessableEntityException("The version must be in the format MAJOR.MINOR.PATCH");
        }
    }

    private static /* synthetic */ void lambda$visit$14(ICompositeType resolvedRelatedArtifact, List originalDependenciesWithExtensions, String relatedArtifactReference, IDependencyInfo dep) {
        ((IBaseHasExtensions)resolvedRelatedArtifact).getExtension().addAll(dep.getExtension());
        originalDependenciesWithExtensions.removeIf(ra -> ra.getReference().equals(relatedArtifactReference));
    }

    private static /* synthetic */ boolean lambda$visit$12(String relatedArtifactReference, ICompositeType resolvedRelatedArtifact, IDependencyInfo originalDep) {
        return Canonicals.getUrl((String)originalDep.getReference()).equals(Canonicals.getUrl((String)relatedArtifactReference)) && IKnowledgeArtifactAdapter.getRelatedArtifactType((ICompositeType)resolvedRelatedArtifact).equalsIgnoreCase(DEPENDSON);
    }

    private static /* synthetic */ boolean lambda$visit$11(String relatedArtifactReference, ICompositeType resolvedRelatedArtifact, ICompositeType distinctRelatedArtifact) {
        boolean referenceNotInArray = relatedArtifactReference.equals(IKnowledgeArtifactAdapter.getRelatedArtifactReference((ICompositeType)distinctRelatedArtifact));
        boolean typeMatches = IKnowledgeArtifactAdapter.getRelatedArtifactType((ICompositeType)distinctRelatedArtifact).equals(IKnowledgeArtifactAdapter.getRelatedArtifactType((ICompositeType)resolvedRelatedArtifact));
        return referenceNotInArray && typeMatches;
    }
}

