/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.cr.visitor.BaseKnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;

public class RetireVisitor
extends BaseKnowledgeArtifactVisitor {
    public RetireVisitor(IRepository repository) {
        super(repository);
    }

    public IBase visit(IKnowledgeArtifactAdapter rootAdapter, IBaseParameters operationParameters) {
        if (!rootAdapter.getStatus().equals("active")) {
            throw new PreconditionFailedException("Cannot retire an artifact that is not in active status");
        }
        FhirVersionEnum fhirVersion = rootAdapter.get().getStructureFhirVersionEnum();
        IBaseBundle transactionBundle = BundleHelper.newBundle((FhirVersionEnum)fhirVersion, null, (String)"transaction");
        ArrayList<IDomainResource> resToUpdate = new ArrayList<IDomainResource>();
        resToUpdate.add(rootAdapter.get());
        List<IDomainResource> resourcesToUpdate = this.getComponents(rootAdapter, this.repository, resToUpdate);
        Date nowDate = new Date();
        for (IDomainResource resource : resourcesToUpdate) {
            IKnowledgeArtifactAdapter artifact = IAdapterFactory.forFhirVersion((FhirVersionEnum)resource.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(resource);
            RetireVisitor.updateMetadata(artifact, nowDate);
            IBaseBackboneElement entry = PackageHelper.createEntry((IBaseResource)artifact.get(), (boolean)true);
            BundleHelper.addEntry((IBaseBundle)transactionBundle, (IBaseBackboneElement)entry);
        }
        return this.repository.transaction(transactionBundle);
    }

    private static void updateMetadata(IKnowledgeArtifactAdapter artifactAdapter, Date date) {
        artifactAdapter.setDate(date);
        artifactAdapter.setStatus("retired");
    }
}

