/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.search.Searches;

public class VisitorHelper {
    private VisitorHelper() {
    }

    public static <T extends IBaseDatatype> Optional<T> getParameter(String name, IBaseParameters operationParameters) {
        IAdapterFactory factory = IAdapterFactory.forFhirVersion((FhirVersionEnum)operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(arg_0 -> ((IAdapterFactory)factory).createParameters(arg_0)).map(p -> p.getParameter(name)).map(parametersParameters -> parametersParameters.getValue());
    }

    public static <T extends IBaseResource> Optional<T> getResourceParameter(String name, IBaseParameters operationParameters) {
        IAdapterFactory factory = IAdapterFactory.forFhirVersion((FhirVersionEnum)operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(arg_0 -> ((IAdapterFactory)factory).createParameters(arg_0)).map(p -> p.getParameter(name)).map(parametersParameters -> parametersParameters.getResource());
    }

    public static <T extends IBaseDatatype> Optional<List<T>> getListParameter(String name, IBaseParameters operationParameters) {
        IAdapterFactory factory = IAdapterFactory.forFhirVersion((FhirVersionEnum)operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(arg_0 -> ((IAdapterFactory)factory).createParameters(arg_0)).map(p -> p.getParameterValues(name)).map(values -> values.stream().map(value -> value).collect(Collectors.toList()));
    }

    public static Optional<List<String>> getStringListParameter(String name, IBaseParameters operationParameters) {
        IAdapterFactory factory = IAdapterFactory.forFhirVersion((FhirVersionEnum)operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(arg_0 -> ((IAdapterFactory)factory).createParameters(arg_0)).map(p -> p.getParameterValues(name)).map(values -> values.stream().map(value -> (String)((IPrimitiveType)value).getValue()).collect(Collectors.toList()));
    }

    public static Optional<Boolean> getBooleanParameter(String name, IBaseParameters operationParameters) {
        IAdapterFactory factory = IAdapterFactory.forFhirVersion((FhirVersionEnum)operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(arg_0 -> ((IAdapterFactory)factory).createParameters(arg_0)).map(p -> p.getParameter(name)).map(parametersParameters -> (Boolean)((IPrimitiveType)parametersParameters.getValue()).getValue());
    }

    public static Optional<Date> getDateParameter(String name, IBaseParameters operationParameters) {
        IAdapterFactory factory = IAdapterFactory.forFhirVersion((FhirVersionEnum)operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(arg_0 -> ((IAdapterFactory)factory).createParameters(arg_0)).map(p -> p.getParameter(name)).map(parametersParameters -> (Date)((IPrimitiveType)parametersParameters.getValue()).getValue());
    }

    public static Optional<Integer> getIntegerParameter(String name, IBaseParameters operationParameters) {
        IAdapterFactory factory = IAdapterFactory.forFhirVersion((FhirVersionEnum)operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(arg_0 -> ((IAdapterFactory)factory).createParameters(arg_0)).map(p -> p.getParameter(name)).map(parametersParameters -> (Integer)((IPrimitiveType)parametersParameters.getValue()).getValue());
    }

    public static Optional<String> getStringParameter(String name, IBaseParameters operationParameters) {
        IAdapterFactory factory = IAdapterFactory.forFhirVersion((FhirVersionEnum)operationParameters.getStructureFhirVersionEnum());
        return Optional.ofNullable(operationParameters).map(arg_0 -> ((IAdapterFactory)factory).createParameters(arg_0)).map(p -> p.getParameter(name)).map(parametersParameters -> (String)((IPrimitiveType)parametersParameters.getValue()).getValue());
    }

    public static List<IDomainResource> getMetadataResourcesFromBundle(IBaseBundle bundle) {
        ArrayList<IDomainResource> resourceList = new ArrayList<IDomainResource>();
        FhirVersionEnum version = bundle.getStructureFhirVersionEnum();
        BundleHelper.getEntry((IBaseBundle)bundle).stream().map(e -> BundleHelper.getEntryResource((FhirVersionEnum)version, (IBaseBackboneElement)e)).filter(r -> r != null).forEach(r -> {
            switch (version) {
                case DSTU3: {
                    if (!(r instanceof IDomainResource)) break;
                    IDomainResource resource = (IDomainResource)r;
                    resourceList.add(resource);
                    break;
                }
                case R4: {
                    if (!(r instanceof IDomainResource)) break;
                    IDomainResource resource = (IDomainResource)r;
                    resourceList.add(resource);
                    break;
                }
                case R5: {
                    if (!(r instanceof IDomainResource)) break;
                    IDomainResource resource = (IDomainResource)r;
                    resourceList.add(resource);
                    break;
                }
            }
        });
        return resourceList;
    }

    public static void findUnsupportedCapability(IKnowledgeArtifactAdapter resource, List<String> capability) throws PreconditionFailedException {
        if (capability != null && !capability.isEmpty()) {
            List knowledgeCapabilityExtension = resource.get().getExtension().stream().filter(ext -> ext.getUrl().contains("cqf-knowledgeCapability")).collect(Collectors.toList());
            if (knowledgeCapabilityExtension.isEmpty()) {
                throw new PreconditionFailedException("Resource with url: '%s' does not specify capability.".formatted(resource.getUrl()));
            }
            knowledgeCapabilityExtension.stream().filter(ext -> !capability.contains(((IPrimitiveType)ext.getValue()).getValue())).findAny().ifPresent(ext -> {
                throw new PreconditionFailedException("Resource with url: '%s' is not one of '%s'.".formatted(resource.getUrl(), String.join((CharSequence)", ", capability)));
            });
        }
    }

    public static void processCanonicals(IKnowledgeArtifactAdapter resource, ImmutableTriple<List<String>, List<String>, List<String>> versionTuple) throws PreconditionFailedException {
        List canonicalVersion = (List)versionTuple.left;
        List checkArtifactVersion = (List)versionTuple.middle;
        List forceArtifactVersion = (List)versionTuple.right;
        if (checkArtifactVersion != null && !checkArtifactVersion.isEmpty()) {
            VisitorHelper.findVersionInListMatchingResource(checkArtifactVersion, resource).ifPresent(version -> {
                if (!resource.getVersion().equals(version)) {
                    throw new PreconditionFailedException("Resource with url '%s' has version '%s' but checkVersion specifies '%s'".formatted(resource.getUrl(), resource.getVersion(), version));
                }
            });
        } else if (forceArtifactVersion != null && !forceArtifactVersion.isEmpty()) {
            VisitorHelper.findVersionInListMatchingResource(forceArtifactVersion, resource).ifPresent(arg_0 -> ((IKnowledgeArtifactAdapter)resource).setVersion(arg_0));
        } else if (canonicalVersion != null && !canonicalVersion.isEmpty() && !resource.hasVersion()) {
            VisitorHelper.findVersionInListMatchingResource(canonicalVersion, resource).ifPresent(arg_0 -> ((IKnowledgeArtifactAdapter)resource).setVersion(arg_0));
        }
    }

    private static Optional<String> findVersionInListMatchingResource(List<String> list, IKnowledgeArtifactAdapter resource) {
        return list.stream().filter(canonical -> Canonicals.getUrl((String)canonical).equals(resource.getUrl())).map(Canonicals::getVersion).findAny();
    }

    public static Optional<IKnowledgeArtifactAdapter> tryGetLatestVersion(String inputReference, IRepository repository) {
        return IKnowledgeArtifactAdapter.findLatestVersion((IBaseBundle)SearchHelper.searchRepositoryByCanonicalWithPaging((IRepository)repository, (String)inputReference)).map(res -> IAdapterFactory.forFhirVersion((FhirVersionEnum)res.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(res));
    }

    public static Optional<IKnowledgeArtifactAdapter> tryGetLatestVersionWithStatus(String inputReference, IRepository repository, String status) {
        return IKnowledgeArtifactAdapter.findLatestVersion((IBaseBundle)SearchHelper.searchRepositoryByCanonicalWithPagingWithParams((IRepository)repository, (String)inputReference, (Map)Searches.byStatus((String)status))).map(res -> IAdapterFactory.forFhirVersion((FhirVersionEnum)res.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(res));
    }

    public static Optional<IKnowledgeArtifactAdapter> tryGetLatestVersionExceptStatus(String inputReference, IRepository repository, String status) {
        return IKnowledgeArtifactAdapter.findLatestVersion((IBaseBundle)SearchHelper.searchRepositoryByCanonicalWithPagingWithParams((IRepository)repository, (String)inputReference, (Map)Searches.exceptStatus((String)status))).map(res -> IAdapterFactory.forFhirVersion((FhirVersionEnum)res.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(res));
    }
}

