/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.cr.visitor.BaseKnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;

public class WithdrawVisitor
extends BaseKnowledgeArtifactVisitor {
    public WithdrawVisitor(IRepository repository) {
        super(repository);
    }

    public IBase visit(IKnowledgeArtifactAdapter rootAdapter, IBaseParameters operationParameters) {
        if (!rootAdapter.getStatus().equals("draft")) {
            throw new PreconditionFailedException("Cannot withdraw an artifact that is not in draft status");
        }
        FhirVersionEnum fhirVersion = rootAdapter.get().getStructureFhirVersionEnum();
        IBaseBundle transactionBundle = BundleHelper.newBundle((FhirVersionEnum)fhirVersion, null, (String)"transaction");
        ArrayList<IDomainResource> resToUpdate = new ArrayList<IDomainResource>();
        resToUpdate.add(rootAdapter.get());
        this.findArtifactCommentsToUpdate((IBaseResource)rootAdapter.get(), fhirVersion.getFhirVersionString(), this.repository).forEach(artifact -> {
            IBaseResource resource = BundleHelper.getEntryResource((FhirVersionEnum)fhirVersion, (IBaseBackboneElement)artifact);
            IBaseBackboneElement entry = PackageHelper.deleteEntry((IBaseResource)resource);
            BundleHelper.addEntry((IBaseBundle)transactionBundle, (IBaseBackboneElement)entry);
        });
        List<IDomainResource> resourcesToUpdate = this.getComponents(rootAdapter, this.repository, resToUpdate);
        for (IDomainResource artifact2 : resourcesToUpdate) {
            IBaseBackboneElement entry = PackageHelper.deleteEntry((IBaseResource)artifact2);
            BundleHelper.addEntry((IBaseBundle)transactionBundle, (IBaseBackboneElement)entry);
        }
        return this.repository.transaction(transactionBundle);
    }
}

