/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3;

import java.util.Collections;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class MedicationRequestResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public MedicationRequestResolver(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public MedicationRequest resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        MedicationRequest medicationRequest = new MedicationRequest();
        medicationRequest.setIntent(MedicationRequest.MedicationRequestIntent.ORDER);
        medicationRequest.setSubject(new Reference(request.getSubjectId()));
        if (this.activityDefinition.hasUrl()) {
            medicationRequest.setDefinition(Collections.singletonList(new Reference(this.activityDefinition.getUrl())));
        }
        if (this.activityDefinition.hasProduct()) {
            medicationRequest.setMedication(this.activityDefinition.getProduct());
        } else if (!this.activityDefinition.hasDynamicValue()) {
            throw new FHIRException(String.format("Missing required ActivityDefinition.product property for %s", "MedicationRequest"));
        }
        if (this.activityDefinition.hasDosage()) {
            medicationRequest.setDosageInstruction(this.activityDefinition.getDosage());
        }
        return medicationRequest;
    }
}

