/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.r5;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class CommunicationResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public CommunicationResolver(ActivityDefinition activityDefinition) {
        Preconditions.checkNotNull((Object)activityDefinition);
        this.activityDefinition = activityDefinition;
    }

    public Communication resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        Communication communication = new Communication();
        communication.setStatus(Enumerations.EventStatus.UNKNOWN);
        communication.setSubject(new Reference(request.getSubjectId()));
        if (this.activityDefinition.hasCode()) {
            communication.setReason(Collections.singletonList(new CodeableReference(this.activityDefinition.getCode())));
        }
        if (this.activityDefinition.hasRelatedArtifact()) {
            for (RelatedArtifact artifact : this.activityDefinition.getRelatedArtifact()) {
                if (!artifact.hasResourceElement()) continue;
                Attachment attachment = new Attachment().setUrl((String)artifact.getResourceElement().getValue());
                if (artifact.hasDisplay()) {
                    attachment.setTitle(artifact.getDisplay());
                }
                Communication.CommunicationPayloadComponent payload = new Communication.CommunicationPayloadComponent();
                payload.setContent((DataType)(artifact.hasDisplay() ? attachment.setTitle(artifact.getDisplay()) : attachment));
                communication.setPayload(Collections.singletonList(payload));
            }
        }
        return communication;
    }
}

