/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.r4.model.Expression;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cr.common.IOperationRequest;
import org.opencds.cqf.fhir.cr.common.ResolveExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(ExpressionProcessor.class);
    protected static final String EXCEPTION_MESSAGE_TEMPLATE = "Error encountered evaluating expression (%s) for item (%s): %s";

    public List<IBase> getExpressionResultForItem(IOperationRequest request, CqfExpression expression, String itemLinkId) throws ResolveExpressionException {
        if (expression == null) {
            return new ArrayList<IBase>();
        }
        try {
            return this.getExpressionResult(request, expression);
        }
        catch (Exception ex) {
            String message = String.format(EXCEPTION_MESSAGE_TEMPLATE, expression.getExpression(), itemLinkId, ex.getMessage());
            throw new ResolveExpressionException(message);
        }
    }

    public List<IBase> getExpressionResult(IOperationRequest request, CqfExpression expression) {
        return request.getLibraryEngine().resolveExpression(request.getSubjectId().getIdPart(), expression, request.getParameters(), request.getBundle()).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<IBase> getExpressionResult(IOperationRequest request, CqfExpression expression, IBaseParameters parameters) {
        return request.getLibraryEngine().resolveExpression(request.getSubjectId().getIdPart(), expression, parameters, request.getBundle()).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public <E extends IBaseExtension<?, ?>> CqfExpression getCqfExpression(IOperationRequest request, List<E> extensions, String extensionUrl) {
        IBaseExtension extension = extensions.stream().filter(e -> e.getUrl().equals(extensionUrl)).findFirst().orElse(null);
        if (extension == null) {
            return null;
        }
        switch (request.getFhirVersion()) {
            case DSTU3: {
                IBaseExtension languageExtension = extensions.stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/cqf-expression-language")).findFirst().orElse(null);
                IBaseExtension libraryExtension = extensions.stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/cqf-library")).findFirst().orElse(null);
                return new CqfExpression(languageExtension == null ? null : languageExtension.getValue().toString(), extension.getValue().toString(), libraryExtension == null ? request.getDefaultLibraryUrl() : libraryExtension.getValue().toString());
            }
            case R4: {
                return CqfExpression.of((Expression)((Expression)extension.getValue()), (String)request.getDefaultLibraryUrl());
            }
            case R5: {
                return CqfExpression.of((org.hl7.fhir.r5.model.Expression)((org.hl7.fhir.r5.model.Expression)extension.getValue()), (String)request.getDefaultLibraryUrl());
            }
        }
        return null;
    }

    public CqfExpression getCqfExpressionForElement(IOperationRequest request, IBaseBackboneElement element) {
        if (element == null) {
            return null;
        }
        switch (request.getFhirVersion()) {
            case DSTU3: {
                return new CqfExpression(request.resolvePathString((IBase)element, "language"), request.resolvePathString((IBase)element, "expression"), request.getDefaultLibraryUrl());
            }
            case R4: {
                return CqfExpression.of((Expression)request.resolvePath((IBase)element, "expression", Expression.class), (String)request.getDefaultLibraryUrl());
            }
            case R5: {
                return CqfExpression.of((org.hl7.fhir.r5.model.Expression)request.resolvePath((IBase)element, "expression", org.hl7.fhir.r5.model.Expression.class), (String)request.getDefaultLibraryUrl());
            }
        }
        return null;
    }

    public CqfExpression getItemInitialExpression(IOperationRequest request, IBaseBackboneElement item) {
        if (!item.hasExtension()) {
            return null;
        }
        CqfExpression cqfExpression = this.getCqfExpression(request, item.getExtension(), "http://hl7.org/fhir/StructureDefinition/cqf-expression");
        return cqfExpression != null ? cqfExpression : this.getCqfExpression(request, item.getExtension(), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
    }
}

