/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.inputparameters.dstu3;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.inputparameters.BaseInputParameterResolver;
import org.opencds.cqf.fhir.utility.dstu3.Parameters;
import org.opencds.cqf.fhir.utility.search.Searches;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputParameterResolver
extends BaseInputParameterResolver {
    private static final Logger logger = LoggerFactory.getLogger(InputParameterResolver.class);
    private final org.hl7.fhir.dstu3.model.Parameters parameters;

    public InputParameterResolver(Repository repository, IIdType subjectId, IIdType encounterId, IIdType practitionerId, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle) {
        super(repository, subjectId, encounterId, practitionerId, parameters, useServerData, bundle);
        this.parameters = this.resolveParameters(parameters);
    }

    protected final org.hl7.fhir.dstu3.model.Parameters resolveParameters(IBaseParameters baseParameters) {
        Practitioner practitioner;
        Encounter encounter;
        Class subjectClass;
        Object subject;
        org.hl7.fhir.dstu3.model.Parameters params = Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]);
        if (baseParameters != null) {
            params.getParameter().addAll(((org.hl7.fhir.dstu3.model.Parameters)baseParameters).getParameter());
        }
        if ((subject = this.readRepository(subjectClass = this.fhirContext().getResourceDefinition(this.subjectId.getResourceType()).getImplementingClass(), this.subjectId)) != null) {
            params.addParameter(Parameters.part((String)"%subject", (Resource)((Resource)subject), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.encounterId != null && !this.encounterId.isEmpty() && (encounter = this.readRepository(Encounter.class, this.encounterId)) != null) {
            params.addParameter(Parameters.part((String)"%encounter", (Resource)encounter, (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        if (this.practitionerId != null && !this.practitionerId.isEmpty() && (practitioner = this.readRepository(Practitioner.class, this.practitionerId)) != null) {
            params.addParameter(Parameters.part((String)"%practitioner", (Resource)practitioner, (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]));
        }
        return params;
    }

    public org.hl7.fhir.dstu3.model.Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public <T extends ICompositeType> IBaseParameters resolveInputParameters(List<T> dataRequirement) {
        List dataRequirements = dataRequirement.stream().map(i -> (DataRequirement)i).collect(Collectors.toList());
        org.hl7.fhir.dstu3.model.Parameters params = Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]);
        if (this.parameters != null) {
            params.getParameter().addAll(this.parameters.getParameter());
        }
        for (DataRequirement req : dataRequirements) {
            if (!req.hasId()) continue;
            Parameters.ParametersParameterComponent parameter = Parameters.part((String)("%" + String.format("%s", req.getId())), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0]);
            if (req.hasCodeFilter()) {
                for (DataRequirement.DataRequirementCodeFilterComponent filter : req.getCodeFilter()) {
                    if (filter == null || !filter.hasPath() || !filter.hasValueSet()) continue;
                    Bundle valueSets = (Bundle)this.repository.search(Bundle.class, ValueSet.class, Searches.byCanonical((String)filter.getValueSet().primitiveValue()));
                    if (valueSets.hasEntry()) {
                        ValueSet valueSet = (ValueSet)valueSets.getEntryFirstRep().getResource();
                        ArrayList codes = valueSet.hasExpansion() ? valueSet.getExpansion().getContains().stream().map(c -> new Coding(c.getSystem(), c.getCode(), c.getDisplay())).collect(Collectors.toList()) : new ArrayList();
                        Searches.SearchBuilder searchBuilder = Searches.builder();
                        codes.forEach(c -> searchBuilder.withTokenParam("code", c.getCode()));
                        Class resourceType = this.fhirContext().getResourceDefinition(req.getType()).getImplementingClass();
                        Bundle searchResults = (Bundle)this.repository.search(Bundle.class, resourceType, searchBuilder.build(), null);
                        if (searchResults.hasEntry()) {
                            parameter.setResource((Resource)(searchResults.getEntry().size() > 1 ? searchResults : ((Bundle.BundleEntryComponent)searchResults.getEntry().get(0)).getResource()));
                        }
                    }
                    logger.debug("Could not find ValueSet with url {} on the local server.", (Object)filter.getValueSet());
                }
            }
            params.addParameter(parameter);
        }
        return params;
    }
}

