/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Quantity;
import org.opencds.cqf.fhir.cr.measure.common.BaseMeasureReportScorer;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;

public class R4MeasureReportScorer
extends BaseMeasureReportScorer<MeasureReport> {
    @Override
    public void score(Map<GroupDef, MeasureScoring> measureScoring, MeasureReport measureReport) {
        if (measureReport.getGroup().isEmpty()) {
            return;
        }
        if (measureScoring == null || measureScoring.isEmpty()) {
            throw new IllegalArgumentException("Measure does not have a scoring methodology defined. Add a \"scoring\" property to the measure definition or the group definition.");
        }
        for (MeasureReport.MeasureReportGroupComponent mrgc : measureReport.getGroup()) {
            this.scoreGroup(this.getGroupMeasureScoring(mrgc, measureScoring), mrgc);
        }
    }

    protected MeasureScoring getGroupMeasureScoring(MeasureReport.MeasureReportGroupComponent mrgc, Map<GroupDef, MeasureScoring> measureScoring) {
        if (measureScoring.size() == 1) {
            return measureScoring.values().iterator().next();
        }
        MeasureScoring measureScoringFromGroup = null;
        for (Map.Entry<GroupDef, MeasureScoring> entry : measureScoring.entrySet()) {
            if (mrgc.getId() != null && entry.getKey().id() != null && entry.getKey().id().equals(mrgc.getId())) {
                measureScoringFromGroup = entry.getValue();
                break;
            }
            if (mrgc.getPopulation().size() != entry.getKey().populations().size() - 2) continue;
            int i = 0;
            block1: for (MeasureReport.MeasureReportGroupPopulationComponent popId : mrgc.getPopulation()) {
                for (PopulationDef popDefEntry : entry.getKey().populations()) {
                    if (!popId.getId().equals(popDefEntry.id())) continue;
                    ++i;
                    continue block1;
                }
            }
            if (i != mrgc.getPopulation().size()) continue;
            measureScoringFromGroup = entry.getValue();
        }
        if (measureScoringFromGroup == null) {
            throw new IllegalArgumentException("No MeasureScoring value set");
        }
        return measureScoringFromGroup;
    }

    protected void scoreGroup(MeasureScoring measureScoring, MeasureReport.MeasureReportGroupComponent mrgc) {
        switch (measureScoring) {
            case PROPORTION: 
            case RATIO: {
                Double score = this.calcProportionScore(this.getGroupExtensionCount(mrgc, "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-cqfm-numerator-membership"), this.getGroupExtensionCount(mrgc, "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-cqfm-denominator-membership"));
                if (score == null) break;
                mrgc.setMeasureScore(new Quantity(score.doubleValue()));
                break;
            }
        }
        for (MeasureReport.MeasureReportGroupStratifierComponent stratifierComponent : mrgc.getStratifier()) {
            this.scoreStratifier(measureScoring, stratifierComponent);
        }
    }

    protected void scoreStratum(MeasureScoring measureScoring, MeasureReport.StratifierGroupComponent stratum) {
        switch (measureScoring) {
            case PROPORTION: 
            case RATIO: {
                Double score = this.calcProportionScore(this.getStratumPopulationCount(stratum, "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-cqfm-numerator-membership"), this.getStratumPopulationCount(stratum, "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-cqfm-denominator-membership"));
                if (score == null) break;
                stratum.setMeasureScore(new Quantity(score.doubleValue()));
                break;
            }
        }
    }

    protected Integer getGroupExtensionCount(MeasureReport.MeasureReportGroupComponent mrgc, String extUrl) {
        Optional<Extension> ext = mrgc.getExtension().stream().filter(x -> x.getUrl().equals(extUrl)).findFirst();
        return ext.map(extension -> Integer.valueOf(extension.getValue().toString())).orElse(null);
    }

    protected Integer getStratumPopulationCount(MeasureReport.StratifierGroupComponent sgc, String extUrl) {
        List pop = sgc.getExtension();
        Extension ext = pop.stream().filter(x -> x.getUrl().equals(extUrl)).findFirst().orElse(null);
        if (ext != null) {
            return Integer.valueOf(ext.getValue().toString());
        }
        return null;
    }

    protected void scoreStratifier(MeasureScoring measureScoring, MeasureReport.MeasureReportGroupStratifierComponent stratifierComponent) {
        for (MeasureReport.StratifierGroupComponent sgc : stratifierComponent.getStratum()) {
            this.scoreStratum(measureScoring, sgc);
        }
    }
}

