/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Collections;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Goal;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Goal;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyRequest;

public class ProcessGoal {
    public IBaseResource convertGoal(ApplyRequest request, IBaseBackboneElement goal) {
        FhirVersionEnum fhirVersion = request.getFhirVersion();
        switch (fhirVersion) {
            case DSTU3: {
                return this.convertDstu3Goal(request.getSubjectId(), goal);
            }
            case R4: {
                return this.convertR4Goal(request.getSubjectId(), goal);
            }
            case R5: {
                return this.convertR5Goal(request.getSubjectId(), goal);
            }
        }
        return null;
    }

    private IBaseResource convertDstu3Goal(IIdType subjectId, IBaseBackboneElement element) {
        PlanDefinition.PlanDefinitionGoalComponent goal = (PlanDefinition.PlanDefinitionGoalComponent)element;
        Goal myGoal = new Goal();
        myGoal.setCategory(Collections.singletonList(goal.getCategory()));
        myGoal.setDescription(goal.getDescription());
        myGoal.setPriority(goal.getPriority());
        myGoal.setStart((org.hl7.fhir.dstu3.model.Type)goal.getStart());
        myGoal.setStatus(Goal.GoalStatus.PROPOSED);
        myGoal.setSubject(new Reference(subjectId));
        Goal.GoalTargetComponent goalTarget = goal.hasTarget() ? (Goal.GoalTargetComponent)goal.getTarget().stream().map(target -> {
            Goal.GoalTargetComponent myTarget = new Goal.GoalTargetComponent();
            myTarget.setDetail(target.getDetail());
            myTarget.setMeasure(target.getMeasure());
            myTarget.setDue((org.hl7.fhir.dstu3.model.Type)target.getDue());
            myTarget.setExtension(target.getExtension());
            return myTarget;
        }).collect(Collectors.toList()).get(0) : null;
        myGoal.setTarget(goalTarget);
        return myGoal;
    }

    private IBaseResource convertR4Goal(IIdType subjectId, IBaseBackboneElement element) {
        PlanDefinition.PlanDefinitionGoalComponent goal = (PlanDefinition.PlanDefinitionGoalComponent)element;
        org.hl7.fhir.r4.model.Goal myGoal = new org.hl7.fhir.r4.model.Goal();
        myGoal.setCategory(Collections.singletonList(goal.getCategory()));
        myGoal.setDescription(goal.getDescription());
        myGoal.setPriority(goal.getPriority());
        myGoal.setStart((Type)goal.getStart());
        myGoal.setLifecycleStatus(Goal.GoalLifecycleStatus.PROPOSED);
        myGoal.setSubject(new org.hl7.fhir.r4.model.Reference(subjectId));
        myGoal.setTarget(goal.getTarget().stream().map(target -> {
            Goal.GoalTargetComponent myTarget = new Goal.GoalTargetComponent();
            myTarget.setDetail(target.getDetail());
            myTarget.setMeasure(target.getMeasure());
            myTarget.setDue((Type)target.getDue());
            myTarget.setExtension(target.getExtension());
            return myTarget;
        }).collect(Collectors.toList()));
        return myGoal;
    }

    private IBaseResource convertR5Goal(IIdType subjectId, IBaseBackboneElement element) {
        PlanDefinition.PlanDefinitionGoalComponent goal = (PlanDefinition.PlanDefinitionGoalComponent)element;
        org.hl7.fhir.r5.model.Goal myGoal = new org.hl7.fhir.r5.model.Goal();
        myGoal.setCategory(Collections.singletonList(goal.getCategory()));
        myGoal.setDescription(goal.getDescription());
        myGoal.setPriority(goal.getPriority());
        myGoal.setStart((DataType)goal.getStart());
        myGoal.setLifecycleStatus(Goal.GoalLifecycleStatus.PROPOSED);
        myGoal.setSubject(new org.hl7.fhir.r5.model.Reference(subjectId));
        myGoal.setTarget(goal.getTarget().stream().map(target -> {
            Goal.GoalTargetComponent myTarget = new Goal.GoalTargetComponent();
            myTarget.setDetail(target.getDetail());
            myTarget.setMeasure(target.getMeasure());
            myTarget.setDue((DataType)target.getDue());
            myTarget.setExtension(target.getExtension());
            return myTarget;
        }).collect(Collectors.toList()));
        return myGoal;
    }
}

