/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RequestGroup;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.RequestGroup;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.utility.Ids;

public class ProcessRequest {
    public IBaseResource generateRequestOrchestration(ApplyRequest request) {
        switch (request.getFhirVersion()) {
            case DSTU3: {
                return this.generateOrchestrationDstu3(request);
            }
            case R4: {
                return this.generateOrchestrationR4(request);
            }
            case R5: {
                return this.generateOrchestrationR5(request);
            }
        }
        return null;
    }

    protected IBaseResource generateOrchestrationDstu3(ApplyRequest request) {
        org.hl7.fhir.dstu3.model.PlanDefinition planDefinition = (org.hl7.fhir.dstu3.model.PlanDefinition)request.getPlanDefinition();
        String canonical = planDefinition.getUrl();
        if (planDefinition.hasVersion()) {
            canonical = String.format("%s|%s", canonical, planDefinition.getVersion());
        }
        org.hl7.fhir.dstu3.model.RequestGroup requestOrchestration = new org.hl7.fhir.dstu3.model.RequestGroup().setStatus(RequestGroup.RequestStatus.DRAFT).setIntent(RequestGroup.RequestIntent.PROPOSAL).addDefinition(new Reference(canonical)).setSubject(new Reference(request.getSubjectId()));
        IIdType requestId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)requestOrchestration.fhirType(), (String)planDefinition.getIdElement().getIdPart());
        requestOrchestration.setId(requestId);
        if (request.hasEncounterId().booleanValue()) {
            requestOrchestration.setContext(new Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId().booleanValue()) {
            requestOrchestration.setAuthor(new Reference(request.getPractitionerId()));
        }
        if (request.hasOrganizationId().booleanValue()) {
            requestOrchestration.setAuthor(new Reference(request.getOrganizationId()));
        }
        if (request.getUserLanguage() instanceof org.hl7.fhir.dstu3.model.CodeableConcept) {
            requestOrchestration.setLanguage(((org.hl7.fhir.dstu3.model.CodeableConcept)request.getUserLanguage()).getCodingFirstRep().getCode());
        }
        return requestOrchestration;
    }

    protected IBaseResource generateOrchestrationR4(ApplyRequest request) {
        org.hl7.fhir.r4.model.PlanDefinition planDefinition = (org.hl7.fhir.r4.model.PlanDefinition)request.getPlanDefinition();
        String canonical = planDefinition.getUrl();
        if (planDefinition.hasVersion()) {
            canonical = String.format("%s|%s", canonical, planDefinition.getVersion());
        }
        RequestGroup requestOrchestration = new RequestGroup().setStatus(RequestGroup.RequestStatus.DRAFT).setIntent(RequestGroup.RequestIntent.PROPOSAL).addInstantiatesCanonical(canonical).setSubject(new org.hl7.fhir.r4.model.Reference(request.getSubjectId()));
        IIdType requestId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)requestOrchestration.fhirType(), (String)planDefinition.getIdElement().getIdPart());
        requestOrchestration.setId(requestId);
        if (request.hasEncounterId().booleanValue()) {
            requestOrchestration.setEncounter(new org.hl7.fhir.r4.model.Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId().booleanValue()) {
            requestOrchestration.setAuthor(new org.hl7.fhir.r4.model.Reference(request.getPractitionerId()));
        }
        if (request.hasOrganizationId().booleanValue()) {
            requestOrchestration.setAuthor(new org.hl7.fhir.r4.model.Reference(request.getOrganizationId()));
        }
        if (request.getUserLanguage() instanceof org.hl7.fhir.r4.model.CodeableConcept) {
            requestOrchestration.setLanguage(((org.hl7.fhir.r4.model.CodeableConcept)request.getUserLanguage()).getCodingFirstRep().getCode());
        }
        return requestOrchestration;
    }

    protected IBaseResource generateOrchestrationR5(ApplyRequest request) {
        PlanDefinition planDefinition = (PlanDefinition)request.getPlanDefinition();
        String canonical = planDefinition.getUrl();
        if (planDefinition.hasVersion()) {
            canonical = String.format("%s|%s", canonical, planDefinition.getVersion());
        }
        RequestOrchestration requestOrchestration = new RequestOrchestration().setStatus(Enumerations.RequestStatus.DRAFT).setIntent(Enumerations.RequestIntent.PROPOSAL).addInstantiatesCanonical(canonical).setSubject(new org.hl7.fhir.r5.model.Reference(request.getSubjectId()));
        IIdType requestId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)requestOrchestration.fhirType(), (String)planDefinition.getIdElement().getIdPart());
        requestOrchestration.setId(requestId);
        if (request.hasEncounterId().booleanValue()) {
            requestOrchestration.setEncounter(new org.hl7.fhir.r5.model.Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId().booleanValue()) {
            requestOrchestration.setAuthor(new org.hl7.fhir.r5.model.Reference(request.getPractitionerId()));
        }
        if (request.hasOrganizationId().booleanValue()) {
            requestOrchestration.setAuthor(new org.hl7.fhir.r5.model.Reference(request.getOrganizationId()));
        }
        if (request.getUserLanguage() instanceof CodeableConcept) {
            requestOrchestration.setLanguage(((CodeableConcept)request.getUserLanguage()).getCodingFirstRep().getCode());
        }
        return requestOrchestration;
    }

    public IBaseResource generateCarePlan(ApplyRequest request, IBaseResource requestOrchestration) {
        switch (request.getFhirVersion()) {
            case DSTU3: {
                return this.generateCarePlanDstu3(request, requestOrchestration);
            }
            case R4: {
                return this.generateCarePlanR4(request, requestOrchestration);
            }
            case R5: {
                return this.generateCarePlanR5(request, requestOrchestration);
            }
        }
        return null;
    }

    protected IBaseResource generateCarePlanDstu3(ApplyRequest request, IBaseResource ro) {
        org.hl7.fhir.dstu3.model.RequestGroup requestOrchestration = (org.hl7.fhir.dstu3.model.RequestGroup)ro;
        org.hl7.fhir.dstu3.model.CarePlan carePlan = new org.hl7.fhir.dstu3.model.CarePlan().setDefinition(requestOrchestration.getDefinition()).setSubject(requestOrchestration.getSubject()).setStatus(CarePlan.CarePlanStatus.DRAFT).setIntent(CarePlan.CarePlanIntent.PROPOSAL);
        IIdType carePlanId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)carePlan.fhirType(), (String)requestOrchestration.getIdElement().getIdPart());
        carePlan.setId(carePlanId);
        if (request.hasEncounterId().booleanValue()) {
            carePlan.setContext(requestOrchestration.getContext());
        }
        if (request.hasPractitionerId().booleanValue()) {
            carePlan.setAuthor(Collections.singletonList(requestOrchestration.getAuthor()));
        }
        if (requestOrchestration.getLanguage() != null) {
            carePlan.setLanguage(requestOrchestration.getLanguage());
        }
        for (IBaseResource iBaseResource : request.getRequestResources()) {
            if (!iBaseResource.fhirType().equals("Goal")) continue;
            carePlan.addGoal(new Reference((IAnyResource)((Resource)iBaseResource)));
        }
        List operationOutcomes = request.getContained((IBaseResource)requestOrchestration).stream().filter(r -> r.fhirType().equals("OperationOutcome")).collect(Collectors.toList());
        for (IBaseResource operationOutcome : operationOutcomes) {
            carePlan.addExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages", (org.hl7.fhir.dstu3.model.Type)new Reference("#" + operationOutcome.getIdElement().getValue()));
        }
        carePlan.addActivity().setReference(new Reference((IAnyResource)requestOrchestration));
        carePlan.addContained((Resource)requestOrchestration);
        for (IBaseResource resource : request.getExtractedResources()) {
            carePlan.addSupportingInfo(new Reference((IAnyResource)((Resource)resource)));
            carePlan.addContained((Resource)resource);
        }
        org.hl7.fhir.dstu3.model.Questionnaire questionnaire = (org.hl7.fhir.dstu3.model.Questionnaire)request.getQuestionnaire();
        if (questionnaire != null && questionnaire.hasItem()) {
            carePlan.addContained((Resource)questionnaire);
        }
        return carePlan;
    }

    protected IBaseResource generateCarePlanR4(ApplyRequest request, IBaseResource ro) {
        RequestGroup requestOrchestration = (RequestGroup)ro;
        org.hl7.fhir.r4.model.CarePlan carePlan = new org.hl7.fhir.r4.model.CarePlan().setInstantiatesCanonical(requestOrchestration.getInstantiatesCanonical()).setSubject(requestOrchestration.getSubject()).setStatus(CarePlan.CarePlanStatus.DRAFT).setIntent(CarePlan.CarePlanIntent.PROPOSAL);
        IIdType carePlanId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)carePlan.fhirType(), (String)requestOrchestration.getIdElement().getIdPart());
        carePlan.setId(carePlanId);
        if (request.hasEncounterId().booleanValue()) {
            carePlan.setEncounter(requestOrchestration.getEncounter());
        }
        if (request.hasPractitionerId().booleanValue()) {
            carePlan.setAuthor(requestOrchestration.getAuthor());
        }
        if (requestOrchestration.getLanguage() != null) {
            carePlan.setLanguage(requestOrchestration.getLanguage());
        }
        for (IBaseResource iBaseResource : request.getRequestResources()) {
            if (!iBaseResource.fhirType().equals("Goal")) continue;
            carePlan.addGoal(new org.hl7.fhir.r4.model.Reference((IAnyResource)((org.hl7.fhir.r4.model.Resource)iBaseResource)));
        }
        List operationOutcomes = request.getContained((IBaseResource)requestOrchestration).stream().filter(r -> r.fhirType().equals("OperationOutcome")).collect(Collectors.toList());
        for (IBaseResource operationOutcome : operationOutcomes) {
            carePlan.addExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages", (Type)new org.hl7.fhir.r4.model.Reference("#" + operationOutcome.getIdElement().getValue()));
        }
        carePlan.addActivity().setReference(new org.hl7.fhir.r4.model.Reference((IAnyResource)requestOrchestration));
        carePlan.addContained((org.hl7.fhir.r4.model.Resource)requestOrchestration);
        for (IBaseResource resource : request.getExtractedResources()) {
            carePlan.addSupportingInfo(new org.hl7.fhir.r4.model.Reference((IAnyResource)((org.hl7.fhir.r4.model.Resource)resource)));
            carePlan.addContained((org.hl7.fhir.r4.model.Resource)resource);
        }
        Questionnaire questionnaire = (Questionnaire)request.getQuestionnaire();
        if (questionnaire != null && questionnaire.hasItem()) {
            carePlan.addContained((org.hl7.fhir.r4.model.Resource)questionnaire);
        }
        return carePlan;
    }

    protected IBaseResource generateCarePlanR5(ApplyRequest request, IBaseResource ro) {
        RequestOrchestration requestOrchestration = (RequestOrchestration)ro;
        CarePlan carePlan = new CarePlan().setInstantiatesCanonical(requestOrchestration.getInstantiatesCanonical()).setSubject(requestOrchestration.getSubject()).setStatus(Enumerations.RequestStatus.DRAFT).setIntent(CarePlan.CarePlanIntent.PROPOSAL);
        IIdType carePlanId = Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)carePlan.fhirType(), (String)requestOrchestration.getIdElement().getIdPart());
        carePlan.setId(carePlanId);
        if (request.hasEncounterId().booleanValue()) {
            carePlan.setEncounter(requestOrchestration.getEncounter());
        }
        if (request.hasPractitionerId().booleanValue()) {
            carePlan.setCustodian(requestOrchestration.getAuthor());
        }
        if (requestOrchestration.getLanguage() != null) {
            carePlan.setLanguage(requestOrchestration.getLanguage());
        }
        for (IBaseResource iBaseResource : request.getRequestResources()) {
            if (!iBaseResource.fhirType().equals("Goal")) continue;
            carePlan.addGoal(new org.hl7.fhir.r5.model.Reference((IAnyResource)((org.hl7.fhir.r5.model.Resource)iBaseResource)));
        }
        List operationOutcomes = request.getContained((IBaseResource)requestOrchestration).stream().filter(r -> r.fhirType().equals("OperationOutcome")).collect(Collectors.toList());
        for (IBaseResource operationOutcome : operationOutcomes) {
            carePlan.addExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages", (DataType)new org.hl7.fhir.r5.model.Reference("#" + operationOutcome.getIdElement().getValue()));
        }
        carePlan.addActivity().setPlannedActivityReference(new org.hl7.fhir.r5.model.Reference((IAnyResource)requestOrchestration));
        carePlan.addContained((org.hl7.fhir.r5.model.Resource)requestOrchestration);
        for (IBaseResource resource : request.getExtractedResources()) {
            carePlan.addSupportingInfo(new org.hl7.fhir.r5.model.Reference((IAnyResource)((org.hl7.fhir.r5.model.Resource)resource)));
            carePlan.addContained((org.hl7.fhir.r5.model.Resource)resource);
        }
        org.hl7.fhir.r5.model.Questionnaire questionnaire = (org.hl7.fhir.r5.model.Questionnaire)request.getQuestionnaire();
        if (questionnaire != null && questionnaire.hasItem()) {
            carePlan.addContained((org.hl7.fhir.r5.model.Resource)questionnaire);
        }
        return carePlan;
    }
}

