/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.packages;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.common.IPackageProcessor;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.r5.PackageHelper;
import org.opencds.cqf.fhir.utility.r5.SearchHelper;

public class PackageProcessor
implements IPackageProcessor {
    protected final Repository repository;
    protected final FhirVersionEnum fhirVersion;

    public PackageProcessor(Repository repository) {
        this.repository = repository;
        this.fhirVersion = repository.fhirContext().getVersion().getVersion();
    }

    @Override
    public IBaseBundle packageResource(IBaseResource resource) {
        return this.packageResource(resource, "POST");
    }

    @Override
    public IBaseBundle packageResource(IBaseResource resource, String method) {
        return this.packagePlanDefinition(resource, method.equals("PUT"));
    }

    protected IBaseBundle packagePlanDefinition(IBaseResource planDefinition, boolean isPut) {
        switch (this.fhirVersion) {
            case DSTU3: {
                return this.packageDstu3((org.hl7.fhir.dstu3.model.PlanDefinition)planDefinition, isPut);
            }
            case R4: {
                return this.packageR4((org.hl7.fhir.r4.model.PlanDefinition)planDefinition, isPut);
            }
            case R5: {
                return this.packageR5((PlanDefinition)planDefinition, isPut);
            }
        }
        return null;
    }

    protected IBaseBundle packageDstu3(org.hl7.fhir.dstu3.model.PlanDefinition planDefinition, boolean isPut) {
        org.hl7.fhir.dstu3.model.Library library;
        StringType libraryCanonical;
        org.hl7.fhir.dstu3.model.Bundle packageBundle = new org.hl7.fhir.dstu3.model.Bundle();
        packageBundle.setType(Bundle.BundleType.TRANSACTION);
        BundleHelper.addEntry((IBaseBundle)packageBundle, (IBaseBackboneElement)org.opencds.cqf.fhir.utility.dstu3.PackageHelper.createEntry((IBaseResource)planDefinition, (boolean)isPut));
        StringType stringType = libraryCanonical = planDefinition.hasLibrary() ? new StringType(((Reference)planDefinition.getLibrary().get(0)).getReference()) : null;
        if (libraryCanonical != null && (library = (org.hl7.fhir.dstu3.model.Library)org.opencds.cqf.fhir.utility.dstu3.SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)libraryCanonical)) != null) {
            BundleHelper.addEntry((IBaseBundle)packageBundle, (IBaseBackboneElement)org.opencds.cqf.fhir.utility.dstu3.PackageHelper.createEntry((IBaseResource)library, (boolean)isPut));
            if (library.hasRelatedArtifact()) {
                org.opencds.cqf.fhir.utility.dstu3.PackageHelper.addRelatedArtifacts((IBaseBundle)packageBundle, (List)library.getRelatedArtifact(), (Repository)this.repository, (boolean)isPut);
            }
        }
        if (planDefinition.hasRelatedArtifact()) {
            org.opencds.cqf.fhir.utility.dstu3.PackageHelper.addRelatedArtifacts((IBaseBundle)packageBundle, (List)planDefinition.getRelatedArtifact(), (Repository)this.repository, (boolean)isPut);
        }
        return packageBundle;
    }

    protected IBaseBundle packageR4(org.hl7.fhir.r4.model.PlanDefinition planDefinition, boolean isPut) {
        Library library;
        CanonicalType libraryCanonical;
        Bundle packageBundle = new Bundle();
        packageBundle.setType(Bundle.BundleType.TRANSACTION);
        packageBundle.addEntry((Bundle.BundleEntryComponent)org.opencds.cqf.fhir.utility.PackageHelper.createEntry((IBaseResource)planDefinition, (boolean)isPut));
        CanonicalType canonicalType = libraryCanonical = planDefinition.hasLibrary() ? (CanonicalType)planDefinition.getLibrary().get(0) : null;
        if (libraryCanonical != null && (library = (Library)org.opencds.cqf.fhir.utility.r4.SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)libraryCanonical)) != null) {
            packageBundle.addEntry((Bundle.BundleEntryComponent)org.opencds.cqf.fhir.utility.PackageHelper.createEntry((IBaseResource)library, (boolean)isPut));
            if (library.hasRelatedArtifact()) {
                org.opencds.cqf.fhir.utility.r4.PackageHelper.addRelatedArtifacts((IBaseBundle)packageBundle, (List)library.getRelatedArtifact(), (Repository)this.repository, (boolean)isPut);
            }
        }
        if (planDefinition.hasRelatedArtifact()) {
            org.opencds.cqf.fhir.utility.r4.PackageHelper.addRelatedArtifacts((IBaseBundle)packageBundle, (List)planDefinition.getRelatedArtifact(), (Repository)this.repository, (boolean)isPut);
        }
        return packageBundle;
    }

    protected IBaseBundle packageR5(PlanDefinition planDefinition, boolean isPut) {
        org.hl7.fhir.r5.model.Library library;
        org.hl7.fhir.r5.model.CanonicalType libraryCanonical;
        org.hl7.fhir.r5.model.Bundle packageBundle = new org.hl7.fhir.r5.model.Bundle();
        packageBundle.setType(Bundle.BundleType.TRANSACTION);
        packageBundle.addEntry((Bundle.BundleEntryComponent)org.opencds.cqf.fhir.utility.PackageHelper.createEntry((IBaseResource)planDefinition, (boolean)isPut));
        org.hl7.fhir.r5.model.CanonicalType canonicalType = libraryCanonical = planDefinition.hasLibrary() ? (org.hl7.fhir.r5.model.CanonicalType)planDefinition.getLibrary().get(0) : null;
        if (libraryCanonical != null && (library = (org.hl7.fhir.r5.model.Library)SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)libraryCanonical)) != null) {
            packageBundle.addEntry((Bundle.BundleEntryComponent)org.opencds.cqf.fhir.utility.PackageHelper.createEntry((IBaseResource)library, (boolean)isPut));
            if (library.hasRelatedArtifact()) {
                PackageHelper.addRelatedArtifacts((IBaseBundle)packageBundle, (List)library.getRelatedArtifact(), (Repository)this.repository, (boolean)isPut);
            }
        }
        if (planDefinition.hasRelatedArtifact()) {
            PackageHelper.addRelatedArtifacts((IBaseBundle)packageBundle, (List)planDefinition.getRelatedArtifact(), (Repository)this.repository, (boolean)isPut);
        }
        return packageBundle;
    }
}

