/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate;

import java.util.List;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.common.IOperationRequest;
import org.opencds.cqf.fhir.cr.questionnaire.generate.IElementProcessor;

public class ElementHasCqfExpression {
    protected final ExpressionProcessor expressionProcessor;

    public ElementHasCqfExpression() {
        this(new ExpressionProcessor());
    }

    public ElementHasCqfExpression(ExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
    }

    public IBaseBackboneElement addProperties(IOperationRequest request, List<IBaseExtension<?, ?>> extensions, IBaseBackboneElement questionnaireItem) {
        CqfExpression expression = this.expressionProcessor.getCqfExpression(request, extensions, "http://hl7.org/fhir/StructureDefinition/cqf-expression");
        List<IBase> results = this.expressionProcessor.getExpressionResult(request, expression);
        results.forEach(result -> {
            if (IAnyResource.class.isAssignableFrom(result.getClass())) {
                this.addResourceValue(request, (IAnyResource)result, questionnaireItem);
            } else {
                this.addTypeValue(request, (IBase)result, questionnaireItem);
            }
        });
        return questionnaireItem;
    }

    protected void addResourceValue(IOperationRequest request, IAnyResource resource, IBaseBackboneElement questionnaireItem) {
        IBaseReference reference = ExtensionBuilders.buildReference(request.getFhirVersion(), resource.getId());
        Object initial = IElementProcessor.createInitial(request, (IBaseDatatype)reference);
        request.getModelResolver().setValue((Object)questionnaireItem, "initial", initial);
    }

    protected void addTypeValue(IOperationRequest request, IBase result, IBaseBackboneElement questionnaireItem) {
        Object initial = IElementProcessor.createInitial(request, (IBaseDatatype)result);
        request.getModelResolver().setValue((Object)questionnaireItem, "initial", initial);
    }
}

