/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.IQuestionnaireRequest;

public class GenerateRequest
implements IQuestionnaireRequest {
    private final Boolean supportedOnly;
    private final Boolean requiredOnly;
    private final IIdType subjectId;
    private final IBaseParameters parameters;
    private final IBaseBundle bundle;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirVersionEnum fhirVersion;
    private final IBaseResource profile;
    private final String profileUrl;
    private String defaultLibraryUrl;
    private IBaseResource questionnaire;
    private List<? extends ICompositeType> differentialElements;
    private List<? extends ICompositeType> snapshotElements;

    public GenerateRequest(IBaseResource profile, Boolean supportedOnly, Boolean requiredOnly, IIdType subjectId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine, ModelResolver modelResolver) {
        this.profile = profile;
        this.supportedOnly = supportedOnly;
        this.requiredOnly = requiredOnly;
        this.subjectId = subjectId;
        this.parameters = parameters;
        this.bundle = bundle;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
        this.fhirVersion = this.libraryEngine.getRepository().fhirContext().getVersion().getVersion();
        this.defaultLibraryUrl = "";
        this.profileUrl = this.resolvePathString((IBase)this.profile, "url");
    }

    public IBaseResource getProfile() {
        return this.profile;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public <E extends ICompositeType> void setDifferentialElements(List<E> elements) {
        this.differentialElements = elements;
    }

    public <E extends ICompositeType> List<E> getDifferentialElements() {
        return this.differentialElements;
    }

    public <E extends ICompositeType> void setSnapshotElements(List<E> elements) {
        this.snapshotElements = elements;
    }

    public <E extends ICompositeType> List<E> getSnapshotElements() {
        return this.snapshotElements;
    }

    public GenerateRequest setQuestionnaire(IBaseResource questionnaire) {
        this.questionnaire = questionnaire;
        return this;
    }

    public Boolean getSupportedOnly() {
        return this.supportedOnly;
    }

    public Boolean getRequiredOnly() {
        return this.requiredOnly;
    }

    public GenerateRequest setDefaultLibraryUrl(String url) {
        this.defaultLibraryUrl = url;
        return this;
    }

    @Override
    public String getOperationName() {
        return "questionnaire";
    }

    @Override
    public IIdType getSubjectId() {
        return this.subjectId;
    }

    @Override
    public IBaseBundle getBundle() {
        return this.bundle;
    }

    @Override
    public IBaseParameters getParameters() {
        return this.parameters;
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public String getDefaultLibraryUrl() {
        return this.defaultLibraryUrl;
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return this.questionnaire;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        throw new UnsupportedOperationException("Unimplemented method 'getOperationOutcome'");
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        throw new UnsupportedOperationException("Unimplemented method 'setOperationOutcome'");
    }
}

