/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate.r4;

import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.common.ItemValueTransformer;
import org.opencds.cqf.fhir.cr.questionnaire.generate.ElementHasCaseFeature;
import org.opencds.cqf.fhir.cr.questionnaire.generate.ElementHasCqfExpression;
import org.opencds.cqf.fhir.cr.questionnaire.generate.ElementHasDefaultValue;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.generate.IElementProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.generate.r4.QuestionnaireTypeIsChoice;

public class ElementProcessor
implements IElementProcessor {
    protected static final String ITEM_TYPE_ERROR = "Unable to determine type for element: %s";
    protected final QuestionnaireTypeIsChoice questionnaireTypeIsChoice;
    protected final ElementHasDefaultValue elementHasDefaultValue;
    protected final ElementHasCqfExpression elementHasCqfExpression;
    protected final ElementHasCaseFeature elementHasCaseFeature;

    public ElementProcessor(Repository repository) {
        this.questionnaireTypeIsChoice = new QuestionnaireTypeIsChoice(repository);
        this.elementHasDefaultValue = new ElementHasDefaultValue();
        this.elementHasCqfExpression = new ElementHasCqfExpression();
        this.elementHasCaseFeature = new ElementHasCaseFeature();
    }

    @Override
    public IBaseBackboneElement processElement(GenerateRequest request, ICompositeType baseElement, String elementType, String childLinkId, IBaseResource caseFeature, Boolean isGroup) {
        Object pathValue;
        ElementDefinition element = (ElementDefinition)baseElement;
        Questionnaire.QuestionnaireItemType itemType = isGroup != false ? Questionnaire.QuestionnaireItemType.GROUP : this.parseItemType(elementType, element.hasBinding());
        Questionnaire.QuestionnaireItemComponent item = this.initializeQuestionnaireItem(itemType, request.getProfileUrl(), element, childLinkId);
        item.setRequired(element.hasMin() && element.getMin() > 0);
        item.setRepeats(element.hasMax() && !element.getMax().equals("1"));
        if (itemType == Questionnaire.QuestionnaireItemType.GROUP) {
            return item;
        }
        if (itemType == Questionnaire.QuestionnaireItemType.CHOICE) {
            this.questionnaireTypeIsChoice.addProperties(element, item);
        }
        if (element.hasFixedOrPattern()) {
            this.elementHasDefaultValue.addProperties(request, (IBaseDatatype)element.getFixedOrPattern(), (IBaseBackboneElement)item);
        } else if (element.hasDefaultValue()) {
            this.elementHasDefaultValue.addProperties(request, (IBaseDatatype)element.getDefaultValue(), (IBaseBackboneElement)item);
        } else if (element.hasExtension("http://hl7.org/fhir/StructureDefinition/cqf-expression")) {
            this.elementHasCqfExpression.addProperties(request, request.getExtensions((IBase)element), (IBaseBackboneElement)item);
        } else if (caseFeature != null && (pathValue = this.elementHasCaseFeature.getPathValue(request, caseFeature, (ICompositeType)element)) instanceof Type) {
            item.addInitial().setValue(ItemValueTransformer.transformValueToItem((Type)pathValue));
        }
        return item;
    }

    protected Questionnaire.QuestionnaireItemComponent initializeQuestionnaireItem(Questionnaire.QuestionnaireItemType itemType, String profileUrl, ElementDefinition element, String childLinkId) {
        String definition = profileUrl + "#" + element.getPath();
        return new Questionnaire.QuestionnaireItemComponent().setType(itemType).setDefinition(definition).setLinkId(childLinkId).setText(this.getElementText(element));
    }

    public Questionnaire.QuestionnaireItemType parseItemType(String elementType, Boolean hasBinding) {
        if (Boolean.TRUE.equals(hasBinding)) {
            return Questionnaire.QuestionnaireItemType.CHOICE;
        }
        if (elementType == null) {
            throw new IllegalArgumentException("Unable to determine item type.");
        }
        switch (elementType) {
            case "code": 
            case "coding": 
            case "CodeableConcept": {
                return Questionnaire.QuestionnaireItemType.CHOICE;
            }
            case "uri": 
            case "url": 
            case "canonical": {
                return Questionnaire.QuestionnaireItemType.URL;
            }
            case "Quantity": {
                return Questionnaire.QuestionnaireItemType.QUANTITY;
            }
            case "Reference": {
                return Questionnaire.QuestionnaireItemType.REFERENCE;
            }
            case "oid": 
            case "uuid": 
            case "base64Binary": {
                return Questionnaire.QuestionnaireItemType.STRING;
            }
            case "positiveInt": 
            case "unsignedInt": {
                return Questionnaire.QuestionnaireItemType.INTEGER;
            }
            case "instant": {
                return Questionnaire.QuestionnaireItemType.DATETIME;
            }
        }
        return Questionnaire.QuestionnaireItemType.fromCode((String)elementType);
    }

    protected String getElementText(ElementDefinition element) {
        return element.hasLabel() ? element.getLabel() : this.getElementDescription(element);
    }

    protected String getElementDescription(ElementDefinition element) {
        return element.hasShort() ? element.getShort() : element.getPath();
    }
}

