/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.populate;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Questionnaire;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.common.ItemValueTransformer;
import org.opencds.cqf.fhir.cr.common.ResolveExpressionException;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;

public class ProcessItem {
    final ExpressionProcessor expressionProcessor;

    public ProcessItem() {
        this(new ExpressionProcessor());
    }

    private ProcessItem(ExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
    }

    public IBaseBackboneElement processItem(PopulateRequest request, IBaseBackboneElement item) throws ResolveExpressionException {
        IBaseBackboneElement populatedItem = this.copyItem(item);
        List<IBase> expressionResults = this.getExpressionResults(request, item);
        if (!expressionResults.isEmpty()) {
            request.getModelResolver().setValue((Object)populatedItem, "extension", Collections.singletonList(ExtensionBuilders.buildReferenceExt(request.getFhirVersion(), ExtensionBuilders.QUESTIONNAIRE_RESPONSE_AUTHOR_EXTENSION, false)));
            if (request.getFhirVersion().equals((Object)FhirVersionEnum.DSTU3)) {
                request.getModelResolver().setValue((Object)populatedItem, "initial", (Object)ItemValueTransformer.transformValueToItem((org.hl7.fhir.dstu3.model.Type)expressionResults.get(0)));
            } else {
                ArrayList initial = new ArrayList();
                expressionResults.forEach(result -> initial.add(this.createInitial(request.getFhirVersion(), (IBase)result)));
                request.getModelResolver().setValue((Object)populatedItem, "initial", initial);
            }
        }
        return populatedItem;
    }

    public IBaseBackboneElement copyItem(IBaseBackboneElement item) {
        return (IBaseBackboneElement)SerializationUtils.clone((Serializable)item);
    }

    public List<IBase> getExpressionResults(PopulateRequest request, IBaseBackboneElement item) throws ResolveExpressionException {
        CqfExpression expression = this.expressionProcessor.getItemInitialExpression(request, item);
        if (expression != null) {
            String itemLinkId = request.getItemLinkId(item);
            return this.expressionProcessor.getExpressionResultForItem(request, expression, itemLinkId);
        }
        return new ArrayList<IBase>();
    }

    public IBaseBackboneElement createInitial(FhirVersionEnum fhirVersion, IBase value) {
        switch (fhirVersion) {
            case R4: {
                return new Questionnaire.QuestionnaireItemInitialComponent().setValue(ItemValueTransformer.transformValueToItem((Type)value));
            }
            case R5: {
                return new Questionnaire.QuestionnaireItemInitialComponent().setValue(ItemValueTransformer.transformValueToItem((DataType)value));
            }
        }
        return null;
    }
}

