/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.cr.common.ResolveExpressionException;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.CodeMap;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractRequest;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.IExtractProcessor;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ProcessDefinitionItem;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ProcessItem;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ResponseBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractProcessor
implements IExtractProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(ExtractProcessor.class);
    protected final ProcessItem processItem;
    protected final ProcessDefinitionItem processDefinitionItem;

    public ExtractProcessor() {
        this(new ProcessItem(), new ProcessDefinitionItem());
    }

    private ExtractProcessor(ProcessItem processItem, ProcessDefinitionItem processDefinitionItem) {
        this.processItem = processItem;
        this.processDefinitionItem = processDefinitionItem;
    }

    @Override
    public IBaseBundle extract(ExtractRequest request) {
        List<IBaseResource> resources = this.processItems(request);
        return this.createBundle(request, resources);
    }

    @Override
    public List<IBaseResource> processItems(ExtractRequest request) {
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        IBaseReference subject = (IBaseReference)request.resolvePath((IBase)request.getQuestionnaireResponse(), "subject");
        IBaseExtension<?, ?> extractionContextExt = request.getItemExtractionContext();
        if (extractionContextExt != null) {
            request.getItems((IBase)request.getQuestionnaireResponse()).forEach(item -> this.processDefinitionItem(request, (IBaseBackboneElement)item, (List<IBaseResource>)resources, subject));
        } else {
            Map<String, List<IBaseCoding>> questionnaireCodeMap = CodeMap.create(request);
            request.getItems((IBase)request.getQuestionnaireResponse()).forEach(item -> {
                if (!request.getItems((IBase)item).isEmpty()) {
                    this.processGroupItem(request, (IBaseBackboneElement)item, questionnaireCodeMap, (List<IBaseResource>)resources, subject);
                } else if (request.resolvePathString((IBase)item, "definition") != null) {
                    this.processDefinitionItem(request, (IBaseBackboneElement)item, (List<IBaseResource>)resources, subject);
                } else {
                    this.processItem(request, (IBaseBackboneElement)item, questionnaireCodeMap, (List<IBaseResource>)resources, subject);
                }
            });
        }
        return resources;
    }

    protected IBaseBundle createBundle(ExtractRequest request, List<IBaseResource> resources) {
        switch (request.getFhirVersion()) {
            case DSTU3: {
                return ResponseBundle.createBundleDstu3(request.getExtractId(), resources);
            }
            case R4: {
                return ResponseBundle.createBundleR4(request.getExtractId(), resources);
            }
            case R5: {
                return ResponseBundle.createBundleR5(request.getExtractId(), resources);
            }
        }
        return null;
    }

    protected void processGroupItem(ExtractRequest request, IBaseBackboneElement item, Map<String, List<IBaseCoding>> questionnaireCodeMap, List<IBaseResource> resources, IBaseReference subject) {
        IBaseReference groupSubject;
        List subjectItems = request.getItems((IBase)item).stream().filter(child -> child.getExtension().stream().anyMatch(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse-isSubject"))).collect(Collectors.toList());
        IBaseReference iBaseReference = groupSubject = !subjectItems.isEmpty() ? (IBaseReference)request.resolvePath((IBase)request.resolvePathList((IBase)subjectItems.get(0), "answer", IBaseBackboneElement.class).get(0), "value") : (IBaseReference)SerializationUtils.clone((Serializable)subject);
        if (request.resolvePathString((IBase)item, "definition") != null) {
            this.processDefinitionItem(request, item, resources, groupSubject);
        } else {
            request.getItems((IBase)item).forEach(childItem -> {
                if (!childItem.getExtension().stream().anyMatch(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse-isSubject"))) {
                    if (!request.getItems((IBase)childItem).isEmpty()) {
                        this.processGroupItem(request, (IBaseBackboneElement)childItem, questionnaireCodeMap, resources, groupSubject);
                    } else {
                        this.processItem(request, (IBaseBackboneElement)childItem, questionnaireCodeMap, resources, groupSubject);
                    }
                }
            });
        }
    }

    protected void processItem(ExtractRequest request, IBaseBackboneElement item, Map<String, List<IBaseCoding>> questionnaireCodeMap, List<IBaseResource> resources, IBaseReference subject) {
        try {
            this.processItem.processItem(request, item, questionnaireCodeMap, resources, subject);
        }
        catch (Exception e) {
            request.logException(e.getMessage());
            throw e;
        }
    }

    protected void processDefinitionItem(ExtractRequest request, IBaseBackboneElement item, List<IBaseResource> resources, IBaseReference subject) {
        try {
            this.processDefinitionItem.processDefinitionItem(request, item, resources, subject);
        }
        catch (ResolveExpressionException e) {
            request.logException(e.getMessage());
        }
    }
}

