/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.common.IQuestionnaireRequest;

public class ExtractRequest
implements IQuestionnaireRequest {
    private final IBaseResource questionnaireResponse;
    private final IBaseResource questionnaire;
    private final IIdType subjectId;
    private final IBaseParameters parameters;
    private final IBaseBundle bundle;
    private final LibraryEngine libraryEngine;
    private final ModelResolver modelResolver;
    private final FhirContext fhirContext;
    private final FhirVersionEnum fhirVersion;
    private final String defaultLibraryUrl;
    private IBaseOperationOutcome operationOutcome;

    public ExtractRequest(IBaseResource questionnaireResponse, IBaseResource questionnaire, IIdType subjectId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine, ModelResolver modelResolver, FhirContext fhirContext) {
        this.questionnaireResponse = questionnaireResponse;
        this.subjectId = subjectId;
        this.parameters = parameters;
        this.bundle = bundle;
        this.libraryEngine = libraryEngine;
        this.modelResolver = modelResolver;
        this.fhirContext = fhirContext;
        this.fhirVersion = fhirContext.getVersion().getVersion();
        this.questionnaire = questionnaire;
        this.defaultLibraryUrl = "";
    }

    public IBaseResource getQuestionnaireResponse() {
        return this.questionnaireResponse;
    }

    public Boolean hasQuestionnaire() {
        return this.questionnaire != null;
    }

    @Override
    public IBaseResource getQuestionnaire() {
        return this.questionnaire;
    }

    public IBaseExtension<?, ?> getItemExtractionContext() {
        IBaseExtension qrExt = this.getExtensions((IBase)this.questionnaireResponse).stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext")).findFirst().orElse(null);
        if (qrExt != null) {
            return qrExt;
        }
        return this.questionnaire == null ? null : (IBaseExtension)this.getExtensions((IBase)this.questionnaire).stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext")).findFirst().orElse(null);
    }

    public String getExtractId() {
        return "extract-" + this.questionnaireResponse.getIdElement().getIdPart();
    }

    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    @Override
    public String getOperationName() {
        return "extract";
    }

    @Override
    public IIdType getSubjectId() {
        return this.subjectId;
    }

    @Override
    public IBaseBundle getBundle() {
        return this.bundle;
    }

    @Override
    public IBaseParameters getParameters() {
        return this.parameters;
    }

    @Override
    public LibraryEngine getLibraryEngine() {
        return this.libraryEngine;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public String getDefaultLibraryUrl() {
        return this.defaultLibraryUrl;
    }

    @Override
    public IBaseOperationOutcome getOperationOutcome() {
        return this.operationOutcome;
    }

    @Override
    public void setOperationOutcome(IBaseOperationOutcome operationOutcome) {
        this.operationOutcome = operationOutcome;
    }
}

