/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract;

import ca.uhn.fhir.context.BaseRuntimeChildDatatypeDefinition;
import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildCompositeDatatypeDefinition;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.IdType;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.ItemValueTransformer;
import org.opencds.cqf.fhir.cr.common.ResolveExpressionException;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionItem {
    protected static final Logger logger = LoggerFactory.getLogger(ProcessDefinitionItem.class);
    final ExpressionProcessor expressionProcessor;

    public ProcessDefinitionItem() {
        this(new ExpressionProcessor());
    }

    private ProcessDefinitionItem(ExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
    }

    public void processDefinitionItem(ExtractRequest request, IBaseBackboneElement item, List<IBaseResource> resources, IBaseReference subject) throws ResolveExpressionException {
        this.processDefinitionItem(request, item, resources, subject, null);
    }

    public void processDefinitionItem(ExtractRequest request, IBaseBackboneElement item, List<IBaseResource> resources, IBaseReference subject, IBaseExtension<?, ?> contextExtension) throws ResolveExpressionException {
        List<BaseRuntimeChildDatatypeDefinition> dateDefs;
        IPrimitiveType dateAuthored;
        IBase authorValue;
        String authorPath;
        List<IBase> context;
        CqfExpression itemExtractionContext;
        String contextExtensionUrl = "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext";
        CqfExpression cqfExpression = itemExtractionContext = request.hasExtension((IBase)item, contextExtensionUrl) != false ? this.expressionProcessor.getCqfExpression(request, request.getExtensions((IBase)item), contextExtensionUrl) : this.expressionProcessor.getCqfExpression(request, request.getExtensions((IBase)request.getQuestionnaireResponse()), contextExtensionUrl);
        if (itemExtractionContext == null || (context = this.expressionProcessor.getExpressionResultForItem(request, itemExtractionContext, request.getItemLinkId(item))) == null || !context.isEmpty()) {
            // empty if block
        }
        String definition = request.resolvePathString((IBase)item, "definition");
        String resourceType = this.getDefinitionType(definition);
        IBaseResource resource = (IBaseResource)this.newValue(request, resourceType);
        BaseRuntimeElementDefinition resourceDefinition = request.getFhirContext().getElementDefinition(resource.getClass());
        resource.setId((IIdType)new IdType(resourceType, request.getExtractId() + "-" + request.getItemLinkId(item)));
        this.resolveMeta(resource, definition);
        String subjectPath = this.getSubjectPath(resourceDefinition);
        if (subjectPath != null) {
            request.getModelResolver().setValue((Object)resource, subjectPath, (Object)subject);
        }
        if ((authorPath = this.getAuthorPath(resourceDefinition)) != null && (authorValue = request.resolvePath((IBase)request.getQuestionnaireResponse(), "author")) != null) {
            request.getModelResolver().setValue((Object)resource, authorPath, (Object)authorValue);
        }
        if ((dateAuthored = request.resolvePath((IBase)request.getQuestionnaireResponse(), "authored", IPrimitiveType.class)) != null && (dateDefs = this.getDateDefs(resourceDefinition)) != null && !dateDefs.isEmpty()) {
            dateDefs.forEach(dateDef -> {
                try {
                    IBase authoredValue = (IBase)dateDef.getDatatype().getConstructor(String.class).newInstance(dateAuthored.getValueAsString());
                    request.getModelResolver().setValue((Object)resource, dateDef.getElementName(), (Object)authoredValue);
                }
                catch (Exception ex) {
                    String message = String.format("Error encountered attempting to set property (%s) on resource type (%s): %s", dateDef.getElementName(), resource.fhirType(), ex.getMessage());
                    logger.error(message);
                    request.logException(message);
                }
            });
        }
        List<IBaseBackboneElement> items = request.getItems((IBase)item);
        this.processChildren(request, resourceDefinition, resource, items);
        resources.add(resource);
    }

    private void processChildren(ExtractRequest request, BaseRuntimeElementDefinition<?> resourceDefinition, IBaseResource resource, List<IBaseBackboneElement> items) {
        items.forEach(childItem -> {
            String childDefinition = request.resolvePathString((IBase)childItem, "definition");
            if (childDefinition != null) {
                String path = childDefinition.split("#")[1];
                path = path.replace(resource.fhirType() + ".", "");
                List<IBaseBackboneElement> children = request.getItems((IBase)childItem);
                if (!children.isEmpty()) {
                    this.processChildren(request, resourceDefinition, resource, children);
                } else {
                    IBase answerValue;
                    List<IBaseBackboneElement> answers = request.resolvePathList((IBase)childItem, "answer", IBaseBackboneElement.class);
                    IBase iBase = answerValue = answers.isEmpty() ? null : request.resolvePath((IBase)answers.get(0), "value");
                    if (answerValue != null) {
                        BaseRuntimeDeclaredChildDefinition pathDefinition = (BaseRuntimeDeclaredChildDefinition)resourceDefinition.getChildByName(path);
                        if (pathDefinition instanceof RuntimeChildChoiceDefinition) {
                            List choices = ((RuntimeChildChoiceDefinition)pathDefinition).getChoices();
                            if (!choices.contains(answerValue.getClass())) {
                                answerValue = ItemValueTransformer.transformValueToResource(request.getFhirVersion(), answerValue);
                            }
                        } else if (pathDefinition instanceof RuntimeChildCompositeDatatypeDefinition && !pathDefinition.getField().getType().equals(answerValue.getClass())) {
                            answerValue = ItemValueTransformer.transformValueToResource(request.getFhirVersion(), answerValue);
                        }
                        request.getModelResolver().setValue((Object)resource, path, (Object)answerValue);
                    }
                }
            }
        });
    }

    private String getDefinitionType(String definition) {
        if (!definition.contains("#")) {
            throw new IllegalArgumentException(String.format("Unable to determine resource type from item definition: %s", definition));
        }
        return definition.split("#")[1];
    }

    private String getSubjectPath(BaseRuntimeElementDefinition<?> definition) {
        return definition.getChildByName("subject") != null ? "subject" : (definition.getChildByName("patient") != null ? "patient" : null);
    }

    private String getAuthorPath(BaseRuntimeElementDefinition<?> definition) {
        return definition.getChildByName("recorder") != null ? "recorder" : (definition.getName().equals("Observation") ? "performer" : null);
    }

    private List<BaseRuntimeChildDatatypeDefinition> getDateDefs(BaseRuntimeElementDefinition<?> definition) {
        ArrayList<BaseRuntimeChildDefinition> results = new ArrayList<BaseRuntimeChildDefinition>();
        results.add(definition.getChildByName("onset"));
        results.add(definition.getChildByName("issued"));
        results.add(definition.getChildByName("effective"));
        results.add(definition.getChildByName("recordDate"));
        return results.stream().filter(d -> d instanceof BaseRuntimeChildDatatypeDefinition).map(d -> (BaseRuntimeChildDatatypeDefinition)d).collect(Collectors.toList());
    }

    private void resolveMeta(IBaseResource resource, String definition) {
        IBaseMetaType meta = resource.getMeta();
        if (definition != null && !definition.isEmpty()) {
            meta.addProfile(definition.split("#")[0]);
        }
    }

    private IBase newValue(ExtractRequest request, String type) {
        try {
            return (IBase)Class.forName(String.format("org.hl7.fhir.%s.model.%s", request.getFhirVersion().toString().toLowerCase(), type)).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

