/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract.r4;

import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BaseDateTimeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractRequest;

public class ObservationResolver {
    public IBaseResource resolve(ExtractRequest request, IBaseBackboneElement baseAnswer, String linkId, IBaseReference subject, Map<String, List<IBaseCoding>> questionnaireCodeMap) {
        QuestionnaireResponse questionnaireResponse = (QuestionnaireResponse)request.getQuestionnaireResponse();
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent answer = (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent)baseAnswer;
        Observation obs = new Observation();
        obs.setId(request.getExtractId() + "." + linkId);
        obs.setBasedOn(questionnaireResponse.getBasedOn());
        obs.setPartOf(questionnaireResponse.getPartOf());
        obs.setStatus(Observation.ObservationStatus.FINAL);
        Coding qrCategoryCoding = new Coding();
        qrCategoryCoding.setCode("survey");
        qrCategoryCoding.setSystem("http://hl7.org/fhir/observation-category");
        obs.setCategory(Collections.singletonList(new CodeableConcept().addCoding(qrCategoryCoding)));
        obs.setCode(new CodeableConcept().setCoding(questionnaireCodeMap.get(linkId).stream().map(c -> (Coding)c).collect(Collectors.toList())));
        obs.setSubject((Reference)subject);
        obs.setEncounter(questionnaireResponse.getEncounter());
        DateTimeType authoredDate = new DateTimeType((questionnaireResponse.hasAuthored() ? questionnaireResponse.getAuthored().toInstant() : Instant.now()).toString());
        obs.setEffective((Type)authoredDate);
        obs.setIssuedElement(new InstantType((BaseDateTimeType)authoredDate));
        obs.setPerformer(Collections.singletonList(questionnaireResponse.getAuthor()));
        switch (answer.getValue().fhirType()) {
            case "Coding": {
                obs.setValue((Type)new CodeableConcept().addCoding(answer.getValueCoding()));
                break;
            }
            case "date": {
                obs.setValue((Type)new DateTimeType((Date)((DateType)answer.getValue()).getValue()));
                break;
            }
            default: {
                obs.setValue(answer.getValue());
            }
        }
        obs.setDerivedFrom(Collections.singletonList(new Reference((IAnyResource)questionnaireResponse)));
        Extension linkIdExtension = new Extension();
        linkIdExtension.setUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/derivedFromLinkId");
        Extension innerLinkIdExtension = new Extension();
        innerLinkIdExtension.setUrl("text");
        innerLinkIdExtension.setValue((Type)new StringType(linkId));
        linkIdExtension.setExtension(Collections.singletonList(innerLinkIdExtension));
        obs.addExtension(linkIdExtension);
        return obs;
    }
}

