/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.ExtensionResolver;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cql.engine.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyProcessor;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.IApplyProcessor;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.IRequestResolverFactory;
import org.opencds.cqf.fhir.cr.common.ResourceResolver;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.repository.Repositories;
import org.opencds.cqf.fhir.utility.repository.operations.IActivityDefinitionProcessor;

public class ActivityDefinitionProcessor
implements IActivityDefinitionProcessor {
    protected final ModelResolver modelResolver;
    protected final EvaluationSettings evaluationSettings;
    protected final FhirVersionEnum fhirVersion;
    protected final ResourceResolver resourceResolver;
    protected final IApplyProcessor applyProcessor;
    protected final IRequestResolverFactory requestResolverFactory;
    protected Repository repository;
    protected ExtensionResolver extensionResolver;

    public ActivityDefinitionProcessor(Repository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public ActivityDefinitionProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        this(repository, evaluationSettings, null, null);
    }

    public ActivityDefinitionProcessor(Repository repository, EvaluationSettings evaluationSettings, IApplyProcessor applyProcessor, IRequestResolverFactory requestResolverFactory) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.evaluationSettings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.resourceResolver = new ResourceResolver("ActivityDefinition", this.repository);
        this.fhirVersion = repository.fhirContext().getVersion().getVersion();
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)this.fhirVersion);
        this.requestResolverFactory = requestResolverFactory == null ? IRequestResolverFactory.getDefault(this.fhirVersion) : requestResolverFactory;
        this.applyProcessor = applyProcessor != null ? applyProcessor : new ApplyProcessor(this.repository, this.requestResolverFactory);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource apply(Either3<C, IIdType, R> activityDefinition, String subjectId, String encounterId, String practitionerId, String organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext) {
        return this.apply(activityDefinition, subjectId, encounterId, practitionerId, organizationId, userType, userLanguage, userTaskContext, setting, settingContext, null, (Boolean)true, null, (IBaseResource)null, null, null);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource apply(Either3<C, IIdType, R> activityDefinition, String subjectId, String encounterId, String practitionerId, String organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        return this.apply(activityDefinition, subjectId, encounterId, practitionerId, organizationId, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)dataEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)contentEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)terminologyEndpoint));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource apply(Either3<C, IIdType, R> activityDefinition, String subjectId, String encounterId, String practitionerId, String organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, Repository dataRepository, Repository contentRepository, Repository terminologyRepository) {
        this.repository = Repositories.proxy((Repository)this.repository, (Boolean)useServerData, (Repository)dataRepository, (Repository)contentRepository, (Repository)terminologyRepository);
        return this.apply(activityDefinition, subjectId, encounterId, practitionerId, organizationId, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource apply(Either3<C, IIdType, R> activityDefinition, String subjectId, String encounterId, String practitionerId, String organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, LibraryEngine libraryEngine) {
        if (StringUtils.isBlank((CharSequence)subjectId)) {
            throw new IllegalArgumentException("Missing required parameter: 'subject'");
        }
        ApplyRequest request = new ApplyRequest((IBaseResource)this.resolveActivityDefinition(activityDefinition), Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)subjectId, (String)"Patient")), encounterId == null ? null : Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)encounterId, (String)"Encounter")), practitionerId == null ? null : Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)practitionerId, (String)"Practitioner")), organizationId == null ? null : Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)organizationId, (String)"Organization")), userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, libraryEngine, this.modelResolver);
        return this.applyProcessor.apply(request);
    }

    protected <C extends IPrimitiveType<String>, R extends IBaseResource> R resolveActivityDefinition(Either3<C, IIdType, R> activityDefinition) {
        return this.resourceResolver.resolve(activityDefinition);
    }

    protected FhirContext fhirContext() {
        return this.repository.fhirContext();
    }
}

