/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.BooleanType;

public class ExtensionBuilders {
    public static final AbstractMap.SimpleEntry<String, String> QUESTIONNAIRE_RESPONSE_AUTHOR_EXTENSION = new AbstractMap.SimpleEntry<String, String>("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-author", "http://cqframework.org/fhir/Device/clinical-quality-language");

    private ExtensionBuilders() {
    }

    public static AbstractMap.SimpleEntry<String, String> prepopulateSubjectExtension(String patientCode, String patientId) {
        return new AbstractMap.SimpleEntry<String, CallSite>("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-prepopulate-subject", (CallSite)((Object)(patientCode + "/" + patientId)));
    }

    public static AbstractMap.SimpleEntry<String, String> crmiMessagesExtension(String operationOutcomeId) {
        return new AbstractMap.SimpleEntry<String, String>("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages", operationOutcomeId);
    }

    public static AbstractMap.SimpleEntry<String, String> dtrQuestionnaireResponseExtension(String questionnaireId) {
        return new AbstractMap.SimpleEntry<String, String>("http://hl7.org/fhir/us/davinci-dtr/StructureDefinition/dtr-questionnaireresponse-questionnaire", questionnaireId);
    }

    public static AbstractMap.SimpleEntry<String, String> pertainToGoalExtension(String goalId) {
        return new AbstractMap.SimpleEntry<String, String>("http://hl7.org/fhir/StructureDefinition/resource-pertainsToGoal", goalId);
    }

    public static AbstractMap.SimpleEntry<String, Boolean> sdcQuestionnaireHidden(Boolean value) {
        return new AbstractMap.SimpleEntry<String, Boolean>("http://hl7.org/fhir/StructureDefinition/questionnaire-hidden", value);
    }

    public static IBaseExtension buildReferenceExt(FhirVersionEnum fhirVersion, AbstractMap.SimpleEntry<String, String> entry, Boolean isContained) {
        IBaseReference value = ExtensionBuilders.buildReference(fhirVersion, entry.getValue(), isContained);
        switch (fhirVersion) {
            case DSTU3: {
                return new Extension(entry.getKey(), (IBaseDatatype)value);
            }
            case R4: {
                return new org.hl7.fhir.r4.model.Extension(entry.getKey(), (IBaseDatatype)value);
            }
            case R5: {
                return new org.hl7.fhir.r5.model.Extension(entry.getKey(), (IBaseDatatype)value);
            }
        }
        return null;
    }

    public static IBaseReference buildReference(FhirVersionEnum fhirVersion, String id) {
        return ExtensionBuilders.buildReference(fhirVersion, id, false);
    }

    public static IBaseReference buildReference(FhirVersionEnum fhirVersion, String id, Boolean isContained) {
        String reference = isContained != false ? "#".concat(id) : id;
        switch (fhirVersion) {
            case DSTU3: {
                return new org.hl7.fhir.dstu3.model.Reference(reference);
            }
            case R4: {
                return new Reference(reference);
            }
            case R5: {
                return new org.hl7.fhir.r5.model.Reference(reference);
            }
        }
        return null;
    }

    public static IBaseBooleanDatatype buildBooleanType(FhirVersionEnum fhirVersion, Boolean value) {
        switch (fhirVersion) {
            case DSTU3: {
                return new org.hl7.fhir.dstu3.model.BooleanType(value);
            }
            case R4: {
                return new org.hl7.fhir.r4.model.BooleanType(value);
            }
            case R5: {
                return new BooleanType(value);
            }
        }
        return null;
    }

    public static IBaseExtension buildBooleanExt(FhirVersionEnum fhirVersion, AbstractMap.SimpleEntry<String, Boolean> entry) {
        IBaseBooleanDatatype value = ExtensionBuilders.buildBooleanType(fhirVersion, entry.getValue());
        switch (fhirVersion) {
            case DSTU3: {
                return new Extension(entry.getKey(), (IBaseDatatype)value);
            }
            case R4: {
                return new org.hl7.fhir.r4.model.Extension(entry.getKey(), (IBaseDatatype)value);
            }
            case R5: {
                return new org.hl7.fhir.r5.model.Extension(entry.getKey(), (IBaseDatatype)value);
            }
        }
        return null;
    }
}

