/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Factory;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.measure.CareGapsProperties;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.constant.HtmlConstants;
import org.opencds.cqf.fhir.cr.measure.enumeration.CareGapsStatusCode;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureProcessor;
import org.opencds.cqf.fhir.cr.measure.r4.R4RepositorySubjectProvider;
import org.opencds.cqf.fhir.cr.measure.r4.utils.R4MeasureServiceUtils;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.builder.BundleBuilder;
import org.opencds.cqf.fhir.utility.builder.CodeableConceptSettings;
import org.opencds.cqf.fhir.utility.builder.CompositionBuilder;
import org.opencds.cqf.fhir.utility.builder.CompositionSectionComponentBuilder;
import org.opencds.cqf.fhir.utility.builder.DetectedIssueBuilder;
import org.opencds.cqf.fhir.utility.builder.NarrativeSettings;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.monad.Eithers;
import org.opencds.cqf.fhir.utility.search.Searches;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R4CareGapsService {
    private static final Logger ourLog = LoggerFactory.getLogger(R4CareGapsService.class);
    private static final Map<String, CodeableConceptSettings> CARE_GAPS_CODES = ImmutableMap.of((Object)"http://loinc.org/96315-7", (Object)new CodeableConceptSettings().add("http://loinc.org", "96315-7", "Gaps in care report"), (Object)"http://terminology.hl7.org/CodeSystem/v3-ActCode/CAREGAP", (Object)new CodeableConceptSettings().add("http://terminology.hl7.org/CodeSystem/v3-ActCode", "CAREGAP", "Care Gaps"));
    private final Repository repository;
    private final MeasureEvaluationOptions measureEvaluationOptions;
    private static final FhirContext fhirContext = FhirContext.forCached((FhirVersionEnum)FhirVersionEnum.R4);
    private CareGapsProperties careGapsProperties;
    private String serverBase;
    protected final Map<String, Resource> configuredResources = new HashMap<String, Resource>();

    public R4CareGapsService(CareGapsProperties careGapsProperties, Repository repository, MeasureEvaluationOptions measureEvaluationOptions, String serverBase) {
        this.repository = repository;
        this.careGapsProperties = careGapsProperties;
        this.measureEvaluationOptions = measureEvaluationOptions;
        this.serverBase = serverBase;
    }

    public Parameters getCareGapsReport(IPrimitiveType<Date> periodStart, IPrimitiveType<Date> periodEnd, List<String> topic, String subject, String practitioner, String organization, List<String> statuses, List<String> measureIds, List<String> measureIdentifiers, List<CanonicalType> measureUrls, List<String> programs) {
        this.validateConfiguration();
        List<Measure> measures = this.ensureMeasures(this.getMeasures(measureIds, measureIdentifiers, measureUrls));
        if (Strings.isNullOrEmpty((String)subject)) {
            throw new NotImplementedOperationException("Only the subject parameter has been implemented.");
        }
        List<Patient> patients = this.getPatientListFromSubject(subject);
        this.throwNotImplementIfPresent(practitioner, "practitioner");
        this.throwNotImplementIfPresent(organization, "organization");
        this.listThrowNotImplementIfPresent(measureIdentifiers, "measureIdentifier");
        this.listThrowNotImplementIfPresent(programs, "program");
        this.listThrowNotImplementIfPresent(topic, "topic");
        this.listThrowIllegalArgumentIfEmpty(statuses, "status");
        this.checkValidStatusCode(statuses);
        Parameters result = this.initializeResult();
        patients.forEach(patient -> {
            Parameters.ParametersParameterComponent patientReports = this.patientReports(periodStart.getValueAsString(), periodEnd.getValueAsString(), (Patient)patient, statuses, measures);
            if (patientReports != null) {
                result.addParameter(patientReports);
            }
        });
        return result;
    }

    protected void throwNotImplementIfPresent(Object value, String parameterName) {
        if (value != null) {
            throw new NotImplementedOperationException(parameterName + " parameter not implemented");
        }
    }

    protected void listThrowNotImplementIfPresent(List<String> value, String parameterName) {
        if (value != null && !value.isEmpty()) {
            throw new NotImplementedOperationException(parameterName + " parameter not implemented");
        }
    }

    protected void listThrowIllegalArgumentIfEmpty(List<String> value, String parameterName) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(parameterName + " parameter requires a value.");
        }
    }

    protected void validateConfiguration() {
        Preconditions.checkNotNull((Object)this.careGapsProperties, (Object)"Setting care-gaps properties are required for the $care-gaps operation.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.careGapsProperties.getCareGapsReporter()) ? 1 : 0) != 0, (Object)"Setting care-gaps properties.care_gaps_reporter setting is required for the $care-gaps operation.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.careGapsProperties.getCareGapsCompositionSectionAuthor()) ? 1 : 0) != 0, (Object)"Setting care-gaps properties.care_gaps_composition_section_author is required for the $care-gaps operation.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.serverBase) ? 1 : 0) != 0, (Object)"The fhirBaseUrl setting is required for the $care-gaps operation.");
        Organization configuredReporter = this.addConfiguredResource(Organization.class, this.careGapsProperties.getCareGapsReporter(), "care_gaps_reporter");
        Organization configuredAuthor = this.addConfiguredResource(Organization.class, this.careGapsProperties.getCareGapsCompositionSectionAuthor(), "care_gaps_composition_section_author");
        Preconditions.checkNotNull((Object)configuredReporter, (Object)String.format("The %s Resource is configured as the CareGapsProperties.care_gaps_reporter but the Resource could not be read.", this.careGapsProperties.getCareGapsReporter()));
        Preconditions.checkNotNull((Object)configuredAuthor, (Object)String.format("The %s Resource is configured as the CareGapsProperties.care_gaps_composition_section_author but the Resource could not be read.", this.careGapsProperties.getCareGapsCompositionSectionAuthor()));
    }

    protected List<Patient> getPatientListFromSubject(String subject) {
        if (subject.startsWith("Patient/")) {
            return Collections.singletonList(this.validatePatientExists(subject));
        }
        if (subject.startsWith("Group/")) {
            return this.getPatientListFromGroup(subject);
        }
        ourLog.warn("Subject member was not a Patient or a Group, so skipping. \n{}", (Object)subject);
        return Collections.emptyList();
    }

    protected List<Patient> getPatientListFromGroup(String subjectGroupId) {
        Group group;
        ArrayList<Patient> patientList = new ArrayList<Patient>();
        try {
            group = (Group)this.repository.read(Group.class, (IIdType)Factory.newId((String)subjectGroupId));
        }
        catch (ResourceNotFoundException e) {
            throw new IllegalArgumentException(Msg.code((int)2276) + "Could not find Group: " + subjectGroupId);
        }
        group.getMember().forEach(member -> {
            Reference reference = member.getEntity();
            if (reference.getReferenceElement().getResourceType().equals("Patient")) {
                Patient patient = this.validatePatientExists(reference.getReference());
                patientList.add(patient);
            } else if (reference.getReferenceElement().getResourceType().equals("Group")) {
                patientList.addAll(this.getPatientListFromGroup(reference.getReference()));
            } else {
                ourLog.info("Group member was not a Patient or a Group, so skipping. \n{}", (Object)reference.getReference());
            }
        });
        return patientList;
    }

    protected Patient validatePatientExists(String patientRef) {
        Patient patient;
        try {
            patient = (Patient)this.repository.read(Patient.class, (IIdType)new IdType(patientRef));
        }
        catch (ResourceNotFoundException e) {
            throw new IllegalArgumentException(Msg.code((int)2277) + "Could not find Patient: " + patientRef);
        }
        return patient;
    }

    protected List<Measure> getMeasures(List<String> measureIds, List<String> measureIdentifiers, List<CanonicalType> measureCanonicals) {
        boolean hasMeasureUrls;
        boolean hasMeasureIds = measureIds != null && !measureIds.isEmpty();
        boolean hasMeasureIdentifiers = measureIdentifiers != null && !measureIdentifiers.isEmpty();
        boolean bl = hasMeasureUrls = measureCanonicals != null && !measureCanonicals.isEmpty();
        if (!(hasMeasureIds || hasMeasureIdentifiers || hasMeasureUrls)) {
            return Collections.emptyList();
        }
        ArrayList<Measure> measureList = new ArrayList<Measure>();
        if (hasMeasureIds) {
            for (String measureId : measureIds) {
                Measure measureById = this.resolveById(new IdType("Measure", measureId));
                measureList.add(measureById);
            }
        }
        if (hasMeasureUrls) {
            for (CanonicalType measureCanonical : measureCanonicals) {
                Measure measureByUrl = this.resolveByUrl(measureCanonical);
                measureList.add(measureByUrl);
            }
        }
        if (hasMeasureIdentifiers) {
            throw new NotImplementedOperationException(Msg.code((int)2278) + "Measure identifiers have not yet been implemented.");
        }
        HashMap result = new HashMap();
        measureList.forEach(measure -> result.putIfAbsent(measure.getUrl(), measure));
        return new ArrayList<Measure>(result.values());
    }

    protected Measure resolveByUrl(CanonicalType url) {
        Canonicals.CanonicalParts parts = Canonicals.getParts((IPrimitiveType)url);
        Bundle result = (Bundle)this.repository.search(Bundle.class, Measure.class, Searches.byNameAndVersion((String)parts.idPart(), (String)parts.version()));
        return (Measure)result.getEntryFirstRep().getResource();
    }

    protected Measure resolveById(IdType id) {
        return (Measure)this.repository.read(Measure.class, (IIdType)id);
    }

    protected <T extends Resource> T addConfiguredResource(Class<T> resourceClass, String id, String key) {
        Resource resource = (Resource)this.repository.read(resourceClass, (IIdType)new IdType(id));
        this.configuredResources.put(key, resource);
        return (T)resource;
    }

    protected List<Measure> ensureMeasures(List<Measure> measures) {
        measures.forEach(measure -> {
            if (!measure.hasImprovementNotation()) {
                ourLog.info("Measure '{}' does not specify an improvement notation, defaulting to: '{}'.", (Object)measure.getId(), (Object)"increase");
            }
        });
        return measures;
    }

    protected Parameters.ParametersParameterComponent patientReports(String periodStart, String periodEnd, Patient patient, List<String> statuses, List<Measure> measures) {
        HashMap<String, Resource> evalPlusSDE;
        ArrayList<DetectedIssue> detectedIssues;
        Composition composition = this.getComposition(patient);
        List<MeasureReport> reports = this.getReports(periodStart, periodEnd, patient, statuses, measures, composition, detectedIssues = new ArrayList<DetectedIssue>(), evalPlusSDE = new HashMap<String, Resource>());
        if (reports.isEmpty()) {
            return null;
        }
        return this.initializePatientParameter(patient).setResource((Resource)this.addBundleEntries(this.serverBase, composition, detectedIssues, reports, evalPlusSDE));
    }

    protected List<MeasureReport> getReports(String periodStart, String periodEnd, Patient patient, List<String> statuses, List<Measure> measures, Composition composition, List<DetectedIssue> detectedIssues, Map<String, Resource> evalPlusSDEs) {
        ArrayList<MeasureReport> reports = new ArrayList<MeasureReport>();
        String reportType = MeasureReportType.INDIVIDUAL.toString();
        R4MeasureProcessor r4MeasureProcessor = new R4MeasureProcessor(this.repository, this.measureEvaluationOptions, new R4RepositorySubjectProvider());
        for (Measure measure : measures) {
            List<String> subjects = Collections.singletonList(Ids.simple((IBaseResource)patient));
            MeasureReport report = r4MeasureProcessor.evaluateMeasure((Either3<CanonicalType, IdType, Measure>)Eithers.forMiddle3((Object)measure.getIdElement()), periodStart, periodEnd, reportType, subjects, null, null);
            if (!report.hasGroup()) {
                ourLog.info("Report does not include a group so skipping.\nSubject: {}\nMeasure: {}", (Object)Ids.simple((IBaseResource)patient), (Object)Ids.simplePart((IBaseResource)measure));
                continue;
            }
            this.initializeReport(report);
            CareGapsStatusCode gapStatus = this.getGapStatus(measure, report);
            if (!statuses.contains(gapStatus.toString())) continue;
            DetectedIssue detectedIssue = this.getDetectedIssue(patient, report, gapStatus);
            detectedIssues.add(detectedIssue);
            composition.addSection(this.getSection(measure, report, detectedIssue, gapStatus));
            this.populateEvaluatedResources(report, evalPlusSDEs);
            this.populateSDEResources(report, evalPlusSDEs);
            reports.add(report);
        }
        return reports;
    }

    protected void initializeReport(MeasureReport measureReport) {
        if (Strings.isNullOrEmpty((String)measureReport.getId())) {
            IIdType id = Ids.newId(MeasureReport.class, (String)UUID.randomUUID().toString());
            measureReport.setId(id);
        }
        Reference reporter = new Reference().setReference(this.careGapsProperties.getCareGapsReporter());
        measureReport.setReporter(reporter);
        if (measureReport.hasMeta()) {
            measureReport.getMeta().addProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/indv-measurereport-deqm");
        } else {
            measureReport.setMeta(new Meta().addProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/indv-measurereport-deqm"));
        }
    }

    protected Parameters.ParametersParameterComponent initializePatientParameter(Patient patient) {
        Parameters.ParametersParameterComponent patientParameter = ((Parameters.ParametersParameterComponent)Resources.newBackboneElement(Parameters.ParametersParameterComponent.class)).setName("return");
        patientParameter.setId("subject-" + Ids.simplePart((IBaseResource)patient));
        return patientParameter;
    }

    protected Bundle addBundleEntries(String serverBase, Composition composition, List<DetectedIssue> detectedIssues, List<MeasureReport> measureReports, Map<String, Resource> evalPlusSDEs) {
        Bundle reportBundle = this.getBundle();
        reportBundle.addEntry(this.getBundleEntry(serverBase, (Resource)composition));
        measureReports.forEach(report -> reportBundle.addEntry(this.getBundleEntry(serverBase, (Resource)report)));
        detectedIssues.forEach(detectedIssue -> reportBundle.addEntry(this.getBundleEntry(serverBase, (Resource)detectedIssue)));
        this.configuredResources.values().forEach(resource -> reportBundle.addEntry(this.getBundleEntry(serverBase, (Resource)resource)));
        evalPlusSDEs.values().forEach(resource -> reportBundle.addEntry(this.getBundleEntry(serverBase, (Resource)resource)));
        return reportBundle;
    }

    protected CareGapsStatusCode getGapStatus(Measure measure, MeasureReport measureReport) {
        MutablePair inNumerator = new MutablePair((Object)"numerator", (Object)false);
        MutablePair inDenominator = new MutablePair((Object)"denominator", (Object)false);
        measureReport.getGroup().forEach(arg_0 -> R4CareGapsService.lambda$getGapStatus$9((Pair)inNumerator, (Pair)inDenominator, arg_0));
        boolean isPositive = true;
        if (measure.hasImprovementNotation()) {
            isPositive = measure.getImprovementNotation().hasCoding("http://terminology.hl7.org/CodeSystem/measure-improvement-notation", "increase");
        }
        if (Boolean.FALSE.equals(inDenominator.getValue())) {
            return CareGapsStatusCode.NOT_APPLICABLE;
        }
        if (Boolean.TRUE.equals(inDenominator.getValue()) && (isPositive && !((Boolean)inNumerator.getValue()).booleanValue() || !isPositive && ((Boolean)inNumerator.getValue()).booleanValue())) {
            return CareGapsStatusCode.OPEN_GAP;
        }
        return CareGapsStatusCode.CLOSED_GAP;
    }

    protected Bundle.BundleEntryComponent getBundleEntry(String serverBase, Resource resource) {
        return new Bundle.BundleEntryComponent().setResource(resource).setFullUrl(R4MeasureServiceUtils.getFullUrl(serverBase, (IBaseResource)resource));
    }

    protected Composition.SectionComponent getSection(Measure measure, MeasureReport measureReport, DetectedIssue detectedIssue, CareGapsStatusCode gapStatus) {
        String narrative = String.format(HtmlConstants.HTML_DIV_PARAGRAPH_CONTENT, gapStatus == CareGapsStatusCode.CLOSED_GAP ? "No detected issues." : String.format("Issues detected.  See %s for details.", Ids.simple((IBaseResource)detectedIssue)));
        return (Composition.SectionComponent)new CompositionSectionComponentBuilder(Composition.SectionComponent.class).withTitle(measure.hasTitle() ? measure.getTitle() : measure.getUrl()).withFocus(Ids.simple((IBaseResource)measureReport)).withText(new NarrativeSettings(narrative)).withEntry(Ids.simple((IBaseResource)detectedIssue)).build();
    }

    protected Bundle getBundle() {
        return (Bundle)((BundleBuilder)new BundleBuilder(Bundle.class).withProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/gaps-bundle-deqm")).withType(Bundle.BundleType.DOCUMENT.toString()).build();
    }

    protected Composition getComposition(Patient patient) {
        return (Composition)((CompositionBuilder)new CompositionBuilder(Composition.class).withProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/gaps-composition-deqm")).withType(CARE_GAPS_CODES.get("http://loinc.org/96315-7")).withStatus(Composition.CompositionStatus.FINAL.toString()).withTitle("Care Gap Report for " + Ids.simplePart((IBaseResource)patient)).withSubject(Ids.simple((IBaseResource)patient)).withAuthor(Ids.simple((IBaseResource)((IBaseResource)this.configuredResources.get("care_gaps_composition_section_author")))).build();
    }

    protected DetectedIssue getDetectedIssue(Patient patient, MeasureReport measureReport, CareGapsStatusCode careGapStatusCode) {
        return (DetectedIssue)((DetectedIssueBuilder)((DetectedIssueBuilder)new DetectedIssueBuilder(DetectedIssue.class).withProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/gaps-detectedissue-deqm")).withStatus(DetectedIssue.DetectedIssueStatus.FINAL.toString()).withCode(CARE_GAPS_CODES.get("http://terminology.hl7.org/CodeSystem/v3-ActCode/CAREGAP")).withPatient(Ids.simple((IBaseResource)patient)).withEvidenceDetail(Ids.simple((IBaseResource)measureReport)).withModifierExtension((Pair)new ImmutablePair((Object)"http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-gapStatus", (Object)new CodeableConceptSettings().add("http://hl7.org/fhir/us/davinci-deqm/CodeSystem/gaps-status", careGapStatusCode.toString(), careGapStatusCode.toDisplayString())))).build();
    }

    protected void populateEvaluatedResources(MeasureReport measureReport, Map<String, Resource> resources) {
        measureReport.getEvaluatedResource().forEach(evaluatedResource -> {
            IIdType resourceId = evaluatedResource.getReferenceElement();
            if (resourceId.getResourceType() == null || resources.containsKey(Ids.simple((IIdType)resourceId))) {
                return;
            }
            Class resourceType = ((IBaseResource)fhirContext.getResourceDefinition(resourceId.getResourceType()).newInstance()).getClass();
            IBaseResource resource = this.repository.read(resourceType, resourceId);
            if (resource instanceof Resource) {
                Resource resourceBase = (Resource)resource;
                resources.put(Ids.simple((IIdType)resourceId), resourceBase);
            }
        });
    }

    protected void populateSDEResources(MeasureReport measureReport, Map<String, Resource> resources) {
        if (measureReport.hasExtension()) {
            for (Extension extension : measureReport.getExtension()) {
                Class resourceType;
                IBaseResource resource;
                IdType sdeId;
                Reference sdeRef;
                if (!extension.hasUrl() || !extension.getUrl().equals("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData") || (sdeRef = extension.hasValue() && extension.getValue() instanceof Reference ? (Reference)extension.getValue() : null) == null || !sdeRef.hasReference() || sdeRef.getReference().startsWith("#") || resources.containsKey(Ids.simple((IIdType)(sdeId = new IdType(sdeRef.getReference())))) || !((resource = this.repository.read(resourceType = ((IBaseResource)fhirContext.getResourceDefinition(sdeId.getResourceType()).newInstance()).getClass(), (IIdType)sdeId)) instanceof Resource)) continue;
                Resource resourceBase = (Resource)resource;
                resources.put(Ids.simple((IIdType)sdeId), resourceBase);
            }
        }
    }

    protected Parameters initializeResult() {
        return (Parameters)Resources.newResource(Parameters.class, (String)("care-gaps-report-" + String.valueOf(UUID.randomUUID())));
    }

    protected void checkValidStatusCode(List<String> statuses) {
        for (String status : statuses) {
            if (status.equals(CareGapsStatusCode.CLOSED_GAP.toString()) || status.equals(CareGapsStatusCode.OPEN_GAP.toString()) || status.equals(CareGapsStatusCode.NOT_APPLICABLE.toString())) continue;
            throw new RuntimeException("CareGap status parameter: " + status + " is not an accepted value");
        }
    }

    private static /* synthetic */ void lambda$getGapStatus$9(Pair inNumerator, Pair inDenominator, MeasureReport.MeasureReportGroupComponent group) {
        group.getPopulation().forEach(population -> {
            if (population.hasCode() && population.getCode().hasCoding("http://terminology.hl7.org/CodeSystem/measure-population", (String)inNumerator.getKey()) && population.getCount() == 1) {
                inNumerator.setValue((Object)true);
            }
            if (population.hasCode() && population.getCode().hasCoding("http://terminology.hl7.org/CodeSystem/measure-population", (String)inDenominator.getKey()) && population.getCount() == 1) {
                inDenominator.setValue((Object)true);
            }
        });
    }
}

