/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import com.google.common.base.Strings;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureProcessor;
import org.opencds.cqf.fhir.cr.measure.r4.R4RepositorySubjectProvider;
import org.opencds.cqf.fhir.cr.measure.r4.utils.R4MeasureServiceUtils;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.builder.BundleBuilder;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.repository.Repositories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R4MultiMeasureService {
    private static final Logger log = LoggerFactory.getLogger(R4MultiMeasureService.class);
    private final Repository repository;
    private final MeasureEvaluationOptions measureEvaluationOptions;
    private String serverBase;

    public R4MultiMeasureService(Repository repository, MeasureEvaluationOptions measureEvaluationOptions, String serverBase) {
        this.repository = repository;
        this.measureEvaluationOptions = measureEvaluationOptions;
        this.serverBase = serverBase;
    }

    public Bundle evaluate(List<Either3<CanonicalType, IdType, Measure>> measures, String periodStart, String periodEnd, String reportType, String subjectId, Endpoint contentEndpoint, Endpoint terminologyEndpoint, Endpoint dataEndpoint, Bundle additionalData, Parameters parameters, String productLine, String practitioner, String reporter) {
        Repository repo = Repositories.proxy((Repository)this.repository, (Boolean)true, (IBaseResource)dataEndpoint, (IBaseResource)contentEndpoint, (IBaseResource)terminologyEndpoint);
        R4RepositorySubjectProvider subjectProvider = new R4RepositorySubjectProvider();
        R4MeasureProcessor processor = new R4MeasureProcessor(repo, this.measureEvaluationOptions, subjectProvider);
        R4MeasureServiceUtils r4MeasureServiceUtils = new R4MeasureServiceUtils(this.repository);
        r4MeasureServiceUtils.ensureSupplementalDataElementSearchParameter();
        log.info("multi-evaluate-measure, measures to evaluate: {}", (Object)measures.size());
        MeasureEvalType evalType = MeasureEvalType.fromCode(reportType).orElse(subjectId == null || subjectId.isEmpty() ? MeasureEvalType.POPULATION : MeasureEvalType.SUBJECT);
        List<String> subjects = this.getSubjects(subjectProvider, practitioner, subjectId, evalType);
        Bundle bundle = (Bundle)new BundleBuilder(Bundle.class).withType(Bundle.BundleType.SEARCHSET.toString()).build();
        for (Either3<CanonicalType, IdType, Measure> measure : measures) {
            MeasureReport measureReport = processor.evaluateMeasure(measure, periodStart, periodEnd, reportType, subjects, (IBaseBundle)additionalData, parameters, evalType);
            measureReport = r4MeasureServiceUtils.addProductLineExtension(measureReport, productLine);
            measureReport = r4MeasureServiceUtils.addSubjectReference(measureReport, practitioner, subjectId);
            if (reporter != null && !reporter.isEmpty()) {
                measureReport.setReporter(r4MeasureServiceUtils.getReporter(reporter));
            }
            this.initializeReport(measureReport);
            bundle.addEntry(this.getBundleEntry(this.serverBase, (Resource)measureReport));
            String measureUrl = measureReport.getMeasure();
            if (measureUrl.isEmpty()) continue;
            log.info("MeasureReport complete for Measure: {}", (Object)measureUrl);
        }
        return bundle;
    }

    protected List<String> getSubjects(R4RepositorySubjectProvider subjectProvider, String practitioner, String subjectId, MeasureEvalType evalType) {
        if (StringUtils.isNotBlank((CharSequence)practitioner)) {
            if (!practitioner.contains("/")) {
                practitioner = "Practitioner/".concat(practitioner);
            }
            subjectId = practitioner;
        }
        return subjectProvider.getSubjects(this.repository, evalType, subjectId).collect(Collectors.toList());
    }

    protected void initializeReport(MeasureReport measureReport) {
        if (Strings.isNullOrEmpty((String)measureReport.getId())) {
            IIdType id = Ids.newId(MeasureReport.class, (String)UUID.randomUUID().toString());
            measureReport.setId(id);
        }
    }

    protected Bundle.BundleEntryComponent getBundleEntry(String serverBase, Resource resource) {
        return new Bundle.BundleEntryComponent().setResource(resource).setFullUrl(R4MeasureServiceUtils.getFullUrl(serverBase, (IBaseResource)resource));
    }
}

