/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4.utils;

import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.util.BundleBuilder;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.constant.MeasureReportConstants;
import org.opencds.cqf.fhir.utility.Ids;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R4MeasureServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(R4MeasureServiceUtils.class);
    private final Repository repository;
    public static final List<ContactDetail> CQI_CONTACTDETAIL = Collections.singletonList(new ContactDetail().addTelecom(new ContactPoint().setSystem(ContactPoint.ContactPointSystem.URL).setValue("http://www.hl7.org/Special/committees/cqi/index.cfm")));
    public static final List<CodeableConcept> US_JURISDICTION_CODING = Collections.singletonList(new CodeableConcept().addCoding(new Coding("urn:iso:std:iso:3166", "US", "United States of America")));
    public static final SearchParameter SUPPLEMENTAL_DATA_SEARCHPARAMETER = (SearchParameter)new SearchParameter().setUrl("http://hl7.org/fhir/us/davinci-deqm/SearchParameter/measurereport-supplemental-data").setVersion("0.1.0").setName("DEQMMeasureReportSupplementalData").setStatus(Enumerations.PublicationStatus.ACTIVE).setDate((Date)MeasureReportConstants.MEASUREREPORT_SUPPLEMENTALDATA_SEARCHPARAMETER_DEFINITION_DATE).setPublisher("HL7 International - Clinical Quality Information Work Group").setContact(CQI_CONTACTDETAIL).setDescription(String.format("Returns resources (supplemental data) from references on extensions on the MeasureReport with urls matching %s.", "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData")).setJurisdiction(US_JURISDICTION_CODING).addBase("MeasureReport").setCode("supplemental-data").setType(Enumerations.SearchParamType.REFERENCE).setExpression(String.format("MeasureReport.extension('%s').value", "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData")).setXpath(String.format("f:MeasureReport/f:extension[@url='%s'].value", "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData")).setXpathUsage(SearchParameter.XPathUsageType.NORMAL).setTitle("Supplemental Data").setId("deqm-measurereport-supplemental-data");

    public R4MeasureServiceUtils(Repository repository) {
        this.repository = repository;
    }

    public MeasureReport addProductLineExtension(MeasureReport measureReport, String productLine) {
        if (productLine != null) {
            Extension ext = new Extension();
            ext.setUrl("http://hl7.org/fhir/us/cqframework/cqfmeasures/StructureDefinition/cqfm-productLine");
            ext.setValue((Type)new StringType(productLine));
            measureReport.addExtension(ext);
        }
        return measureReport;
    }

    public static String getFullUrl(String serverAddress, IBaseResource resource) {
        Preconditions.checkArgument((boolean)resource.getIdElement().hasIdPart(), (Object)"Cannot generate a fullUrl because the resource does not have an id.");
        return R4MeasureServiceUtils.getFullUrl(serverAddress, resource.fhirType(), Ids.simplePart((IBaseResource)resource));
    }

    public static String getFullUrl(String serverAddress, String fhirType, String elementId) {
        return String.format("%s%s/%s", serverAddress + (serverAddress.endsWith("/") ? "" : "/"), fhirType, elementId);
    }

    public void ensureSupplementalDataElementSearchParameter() {
        BundleBuilder builder = new BundleBuilder(this.repository.fhirContext());
        builder.addTransactionCreateEntry((IBaseResource)SUPPLEMENTAL_DATA_SEARCHPARAMETER).conditional("code=supplemental-data");
        try {
            this.repository.transaction(builder.getBundle());
        }
        catch (NotImplementedOperationException e) {
            log.warn("Error creating supplemental data search parameter. This may be due to the server not supporting transactions.", (Throwable)e);
        }
    }

    public MeasureReport addSubjectReference(MeasureReport measureReport, String practitioner, String subjectId) {
        if ((StringUtils.isNotBlank((CharSequence)practitioner) || StringUtils.isNotBlank((CharSequence)subjectId)) && (measureReport.getType().name().equals(MeasureReportType.SUMMARY.name()) || measureReport.getType().name().equals(MeasureReportType.SUBJECTLIST.name()))) {
            if (StringUtils.isNotBlank((CharSequence)practitioner)) {
                if (!practitioner.contains("/")) {
                    practitioner = "Practitioner/".concat(practitioner);
                }
                measureReport.setSubject(new Reference(practitioner));
            } else {
                if (!subjectId.contains("/")) {
                    subjectId = "Patient/".concat(subjectId);
                }
                measureReport.setSubject(new Reference(subjectId));
            }
        }
        return measureReport;
    }

    public Reference getReporter(String reporter) {
        if (!reporter.isEmpty() && !reporter.contains("/")) {
            throw new IllegalArgumentException("R4MultiMeasureService requires '[ResourceType]/[ResourceId]' format to set MeasureReport.reporter reference.");
        }
        Reference reference = null;
        if (!reporter.isEmpty()) {
            if (reporter.startsWith("PractitionerRole")) {
                reference = new Reference(Ids.ensureIdType((String)reporter, (String)"PractitionerRole"));
            } else if (reporter.startsWith("Practitioner")) {
                reference = new Reference(Ids.ensureIdType((String)reporter, (String)"Practitioner"));
            } else if (reporter.startsWith("Organization")) {
                reference = new Reference(Ids.ensureIdType((String)reporter, (String)"Organization"));
            } else if (reporter.startsWith("Location")) {
                reference = new Reference(Ids.ensureIdType((String)reporter, (String)"Location"));
            } else {
                throw new IllegalArgumentException("MeasureReport.reporter does not accept ResourceType: " + reporter);
            }
        }
        return reference;
    }
}

