/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.RequestGroup;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.RequestGroup;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cr.common.DynamicValueProcessor;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.ExtensionProcessor;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyProcessor;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ProcessDefinition;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessAction {
    private static final Logger logger = LoggerFactory.getLogger(ProcessAction.class);
    final Repository repository;
    final ProcessDefinition processDefinition;
    final GenerateProcessor generateProcessor;
    final ExtensionProcessor extensionProcessor;
    final ExpressionProcessor expressionProcessor;
    final DynamicValueProcessor dynamicValueProcessor;

    public ProcessAction(Repository repository, ApplyProcessor applyProcessor, GenerateProcessor generateProcessor) {
        this.repository = repository;
        this.generateProcessor = generateProcessor;
        this.processDefinition = new ProcessDefinition(repository, applyProcessor);
        this.extensionProcessor = new ExtensionProcessor();
        this.expressionProcessor = new ExpressionProcessor();
        this.dynamicValueProcessor = new DynamicValueProcessor();
    }

    public IBaseBackboneElement processAction(ApplyRequest request, IBaseResource requestOrchestration, Map<String, IBaseBackboneElement> metConditions, IBaseBackboneElement action) {
        if (request.hasExtension((IBase)request.getPlanDefinition(), "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-questionnaire-generate").booleanValue()) {
            this.addQuestionnaireItemForInput(request, action);
        }
        if (Boolean.TRUE.equals(this.meetsConditions(request, action, requestOrchestration))) {
            metConditions.put(request.resolvePathString((IBase)action, "id"), action);
            IBaseBackboneElement requestAction = this.generateRequestAction(request, action);
            this.extensionProcessor.processExtensions(request, (IBase)requestAction, (IElement)action, new ArrayList<String>());
            List<IBaseBackboneElement> childActions = request.resolvePathList((IBase)action, "action", IBaseBackboneElement.class);
            for (IBaseBackboneElement childAction : childActions) {
                request.getModelResolver().setValue((Object)requestAction, "action", Collections.singletonList(this.processAction(request, requestOrchestration, metConditions, childAction)));
            }
            IBaseResource resource = this.processDefinition.resolveDefinition(request, requestOrchestration, action, requestAction);
            this.dynamicValueProcessor.processDynamicValues(request, request.getPlanDefinition(), resource, (IElement)action, (IElement)requestAction);
            return requestAction;
        }
        return null;
    }

    protected void addQuestionnaireItemForInput(ApplyRequest request, IBaseBackboneElement action) {
        try {
            List<IElement> actionInput = request.resolvePathList((IBase)action, "input", IElement.class);
            for (IElement input : actionInput) {
                ICompositeType dataReqElement = this.getDataRequirementElement(request, input);
                List<IPrimitiveType> profiles = request.resolvePathList((IBase)dataReqElement, "profile", IPrimitiveType.class);
                if (profiles.isEmpty()) {
                    return;
                }
                IBaseResource profile = SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)profiles.get(0));
                GenerateRequest generateRequest = request.toGenerateRequest(profile);
                request.addQuestionnaireItem(this.generateProcessor.generateItem(generateRequest));
            }
        }
        catch (Exception e) {
            String message = String.format("An error occurred while generating Questionnaire items for action input: %s", e.getMessage());
            request.logException(message);
        }
    }

    protected ICompositeType getDataRequirementElement(ApplyRequest request, IElement input) {
        return (ICompositeType)(request.getFhirVersion().isEqualOrNewerThan(FhirVersionEnum.R5) ? request.resolvePath((IBase)input, "requirement") : input);
    }

    protected IBaseParameters resolveInputParameters(ApplyRequest request, IBaseBackboneElement action) {
        List<IElement> actionInput = request.resolvePathList((IBase)action, "input", IElement.class);
        return request.resolveInputParameters(actionInput.stream().map(input -> this.getDataRequirementElement(request, (IElement)input)).collect(Collectors.toList()));
    }

    protected Boolean meetsConditions(ApplyRequest request, IBaseBackboneElement action, IBaseResource requestOrchestration) {
        List<IBaseBackboneElement> conditions = request.resolvePathList((IBase)action, "condition", IBaseBackboneElement.class);
        if (conditions.isEmpty()) {
            return true;
        }
        IBaseParameters inputParams = this.resolveInputParameters(request, action);
        for (IBaseBackboneElement condition : conditions) {
            CqfExpression conditionExpression = this.expressionProcessor.getCqfExpressionForElement(request, condition);
            if (conditionExpression == null) continue;
            IBase result = null;
            try {
                result = this.expressionProcessor.getExpressionResult(request, conditionExpression, inputParams).get(0);
            }
            catch (Exception e) {
                String message = String.format("Condition expression %s encountered exception: %s", conditionExpression.getExpression(), e.getMessage());
                logger.error(message);
                request.logException(message);
            }
            if (result == null) {
                logger.warn("Condition expression {} returned null", (Object)conditionExpression.getExpression());
                return false;
            }
            if (!(result instanceof IBaseBooleanDatatype)) {
                logger.warn("Condition expression {} returned a non-boolean value: {}", (Object)conditionExpression.getExpression(), (Object)result.getClass().getSimpleName());
                return false;
            }
            if (!((Boolean)((IBaseBooleanDatatype)result).getValue()).booleanValue()) {
                logger.debug("The result of condition expression {} is false", (Object)conditionExpression.getExpression());
                return false;
            }
            logger.debug("The result of condition expression {} is true", (Object)conditionExpression.getExpression());
        }
        return true;
    }

    protected IBaseBackboneElement generateRequestAction(ApplyRequest request, IBaseBackboneElement action) {
        switch (request.getFhirVersion()) {
            case DSTU3: {
                return this.generateRequestActionDstu3(request, action);
            }
            case R4: {
                return this.generateRequestActionR4(request, action);
            }
            case R5: {
                return this.generateRequestActionR5(request, action);
            }
        }
        return null;
    }

    protected IBaseBackboneElement generateRequestActionDstu3(ApplyRequest request, IBaseBackboneElement a) {
        PlanDefinition.PlanDefinitionActionComponent action = (PlanDefinition.PlanDefinitionActionComponent)a;
        RequestGroup.RequestGroupActionComponent requestAction = new RequestGroup.RequestGroupActionComponent().setTitle(action.getTitle()).setDescription(action.getDescription()).setTextEquivalent(action.getTextEquivalent()).setCode(action.getCode()).setDocumentation(action.getDocumentation()).setTiming(action.getTiming()).setType(action.getType());
        requestAction.setId(action.getId());
        if (action.hasCondition()) {
            action.getCondition().forEach(c -> requestAction.addCondition(new RequestGroup.RequestGroupActionConditionComponent().setKind(RequestGroup.ActionConditionKind.fromCode((String)c.getKind().toCode())).setExpression(c.getExpression())));
        }
        if (action.hasRelatedAction()) {
            action.getRelatedAction().forEach(ra -> requestAction.addRelatedAction(new RequestGroup.RequestGroupActionRelatedActionComponent().setActionId(ra.getActionId()).setRelationship(RequestGroup.ActionRelationshipType.fromCode((String)ra.getRelationship().toCode())).setOffset(ra.getOffset())));
        }
        if (action.hasSelectionBehavior()) {
            requestAction.setSelectionBehavior(RequestGroup.ActionSelectionBehavior.fromCode((String)action.getSelectionBehavior().toCode()));
        }
        return requestAction;
    }

    protected IBaseBackboneElement generateRequestActionR4(ApplyRequest request, IBaseBackboneElement a) {
        PlanDefinition.PlanDefinitionActionComponent action = (PlanDefinition.PlanDefinitionActionComponent)a;
        RequestGroup.RequestGroupActionComponent requestAction = new RequestGroup.RequestGroupActionComponent().setTitle(action.getTitle()).setDescription(action.getDescription()).setTextEquivalent(action.getTextEquivalent()).setCode(action.getCode()).setDocumentation(action.getDocumentation()).setTiming(action.getTiming()).setType(action.getType());
        requestAction.setId(action.getId());
        if (action.hasCondition()) {
            action.getCondition().forEach(c -> requestAction.addCondition(new RequestGroup.RequestGroupActionConditionComponent().setKind(RequestGroup.ActionConditionKind.fromCode((String)c.getKind().toCode())).setExpression(c.getExpression())));
        }
        if (action.hasPriority()) {
            requestAction.setPriority(RequestGroup.RequestPriority.fromCode((String)action.getPriority().toCode()));
        }
        if (action.hasRelatedAction()) {
            action.getRelatedAction().forEach(ra -> requestAction.addRelatedAction(new RequestGroup.RequestGroupActionRelatedActionComponent().setActionId(ra.getActionId()).setRelationship(RequestGroup.ActionRelationshipType.fromCode((String)ra.getRelationship().toCode())).setOffset(ra.getOffset())));
        }
        if (action.hasSelectionBehavior()) {
            requestAction.setSelectionBehavior(RequestGroup.ActionSelectionBehavior.fromCode((String)action.getSelectionBehavior().toCode()));
        }
        return requestAction;
    }

    protected IBaseBackboneElement generateRequestActionR5(ApplyRequest request, IBaseBackboneElement a) {
        PlanDefinition.PlanDefinitionActionComponent action = (PlanDefinition.PlanDefinitionActionComponent)a;
        RequestOrchestration.RequestOrchestrationActionComponent requestAction = new RequestOrchestration.RequestOrchestrationActionComponent().setTitle(action.getTitle()).setDescription(action.getDescription()).setTextEquivalent(action.getTextEquivalent()).addCode(action.getCode()).setDocumentation(action.getDocumentation()).setTiming(action.getTiming()).setType(action.getType());
        requestAction.setId(action.getId());
        if (action.hasCondition()) {
            action.getCondition().forEach(c -> requestAction.addCondition(new RequestOrchestration.RequestOrchestrationActionConditionComponent().setKind(Enumerations.ActionConditionKind.fromCode((String)c.getKind().toCode())).setExpression(c.getExpression())));
        }
        if (action.hasPriority()) {
            requestAction.setPriority(Enumerations.RequestPriority.fromCode((String)action.getPriority().toCode()));
        }
        if (action.hasRelatedAction()) {
            action.getRelatedAction().forEach(ra -> requestAction.addRelatedAction(new RequestOrchestration.RequestOrchestrationActionRelatedActionComponent().setTargetId(ra.getTargetId()).setRelationship(Enumerations.ActionRelationshipType.fromCode((String)ra.getRelationship().toCode())).setOffset(ra.getOffset())));
        }
        if (action.hasSelectionBehavior()) {
            requestAction.setSelectionBehavior(Enumerations.ActionSelectionBehavior.fromCode((String)action.getSelectionBehavior().toCode()));
        }
        return requestAction;
    }
}

