/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cql.engine.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.cr.common.IPackageProcessor;
import org.opencds.cqf.fhir.cr.common.ResourceResolver;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.generate.IGenerateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.packages.PackageProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.populate.IPopulateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.repository.Repositories;

public class QuestionnaireProcessor {
    protected static final String SUBJECT_TYPE = "Patient";
    protected final ResourceResolver questionnaireResolver;
    protected final ResourceResolver structureDefResolver;
    protected final ModelResolver modelResolver;
    protected final EvaluationSettings evaluationSettings;
    protected final FhirVersionEnum fhirVersion;
    protected Repository repository;
    protected IGenerateProcessor generateProcessor;
    protected IPackageProcessor packageProcessor;
    protected IPopulateProcessor populateProcessor;

    public QuestionnaireProcessor(Repository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public QuestionnaireProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        this(repository, evaluationSettings, null, null, null);
    }

    public QuestionnaireProcessor(Repository repository, EvaluationSettings evaluationSettings, IGenerateProcessor generateProcessor, IPackageProcessor packageProcessor, IPopulateProcessor populateProcessor) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.evaluationSettings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.questionnaireResolver = new ResourceResolver("Questionnaire", this.repository);
        this.structureDefResolver = new ResourceResolver("StructureDefinition", this.repository);
        this.fhirVersion = this.repository.fhirContext().getVersion().getVersion();
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)this.fhirVersion);
        this.generateProcessor = generateProcessor != null ? generateProcessor : new GenerateProcessor(this.repository);
        this.packageProcessor = packageProcessor != null ? packageProcessor : new PackageProcessor(this.repository);
        this.populateProcessor = populateProcessor != null ? populateProcessor : new PopulateProcessor();
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> R resolveQuestionnaire(Either3<C, IIdType, R> questionnaire) {
        return this.questionnaireResolver.resolve(questionnaire);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> R resolveStructureDefinition(Either3<C, IIdType, R> structureDef) {
        return this.structureDefResolver.resolve(structureDef);
    }

    public IBaseResource generateQuestionnaire(String id) {
        return this.generateProcessor.generate(id);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource generateQuestionnaire(Either3<C, IIdType, R> profile) {
        return this.generateQuestionnaire(profile, false, true);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource generateQuestionnaire(Either3<C, IIdType, R> profile, Boolean supportedOnly, Boolean requiredOnly) {
        return this.generateQuestionnaire(profile, supportedOnly, requiredOnly, null, null, null, null, (IBaseResource)null, null, null, null);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource generateQuestionnaire(Either3<C, IIdType, R> profile, Boolean supportedOnly, Boolean requiredOnly, String subjectId, IBaseParameters parameters, IBaseBundle bundle, Boolean useServerData, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint, String id) {
        return this.generateQuestionnaire(profile, supportedOnly, requiredOnly, subjectId, parameters, bundle, useServerData, Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)dataEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)contentEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)terminologyEndpoint), id);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource generateQuestionnaire(Either3<C, IIdType, R> profile, Boolean supportedOnly, Boolean requiredOnly, String subjectId, IBaseParameters parameters, IBaseBundle bundle, Boolean useServerData, Repository dataRepository, Repository contentRepository, Repository terminologyRepository, String id) {
        this.repository = Repositories.proxy((Repository)this.repository, (Boolean)useServerData, (Repository)dataRepository, (Repository)contentRepository, (Repository)terminologyRepository);
        return this.generateQuestionnaire(profile, supportedOnly, requiredOnly, subjectId, parameters, bundle, new LibraryEngine(this.repository, this.evaluationSettings), id);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource generateQuestionnaire(Either3<C, IIdType, R> profile, Boolean supportedOnly, Boolean requiredOnly, String subjectId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine, String id) {
        GenerateRequest request = new GenerateRequest((IBaseResource)this.resolveStructureDefinition(profile), supportedOnly, requiredOnly, subjectId == null ? null : Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)subjectId, (String)SUBJECT_TYPE)), parameters, bundle, libraryEngine == null ? new LibraryEngine(this.repository, this.evaluationSettings) : libraryEngine, this.modelResolver);
        return this.generateQuestionnaire(request, id);
    }

    public IBaseResource generateQuestionnaire(GenerateRequest request, String id) {
        return this.generateProcessor.generate(request, id);
    }

    public <C extends IPrimitiveType<String>> IBaseBundle packageQuestionnaire(Either3<C, IIdType, IBaseResource> questionnaire) {
        return this.packageQuestionnaire(this.resolveQuestionnaire(questionnaire));
    }

    public IBaseBundle packageQuestionnaire(IBaseResource questionnaire) {
        return this.packageProcessor.packageResource(questionnaire);
    }

    public <C extends IPrimitiveType<String>> IBaseBundle packageQuestionnaire(Either3<C, IIdType, IBaseResource> questionnaire, boolean isPut) {
        return this.packageQuestionnaire(this.resolveQuestionnaire(questionnaire), isPut);
    }

    public IBaseBundle packageQuestionnaire(IBaseResource questionnaire, boolean isPut) {
        return this.packageProcessor.packageResource(questionnaire, isPut ? "PUT" : "POST");
    }

    public PopulateRequest buildPopulateRequest(String operationName, IBaseResource questionnaire, String subjectId, IBaseParameters parameters, IBaseBundle bundle, Boolean useServerData, LibraryEngine libraryEngine) {
        if (StringUtils.isBlank((CharSequence)subjectId)) {
            throw new IllegalArgumentException("Missing required parameter: 'subject'");
        }
        return new PopulateRequest(operationName, questionnaire, Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)subjectId, (String)SUBJECT_TYPE)), parameters, bundle, useServerData, libraryEngine != null ? libraryEngine : new LibraryEngine(this.repository, this.evaluationSettings), this.modelResolver);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> R prePopulate(Either3<C, IIdType, R> questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, Boolean useServerData, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        return this.prePopulate(questionnaire, patientId, parameters, bundle, useServerData, Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)dataEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)contentEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)terminologyEndpoint));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> R prePopulate(Either3<C, IIdType, R> questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, Boolean useServerData, Repository dataRepository, Repository contentRepository, Repository terminologyRepository) {
        this.repository = Repositories.proxy((Repository)this.repository, (Boolean)useServerData, (Repository)dataRepository, (Repository)contentRepository, (Repository)terminologyRepository);
        return this.prePopulate(questionnaire, patientId, parameters, bundle, useServerData, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> R prePopulate(Either3<C, IIdType, R> questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, Boolean useServerData, LibraryEngine libraryEngine) {
        return this.prePopulate((IBaseResource)this.resolveQuestionnaire(questionnaire), patientId, parameters, bundle, useServerData, libraryEngine);
    }

    public <R extends IBaseResource> R prePopulate(IBaseResource questionnaire, String subjectId, IBaseParameters parameters, IBaseBundle bundle, Boolean useServerData, LibraryEngine libraryEngine) {
        return this.prePopulate(this.buildPopulateRequest("prepopulate", questionnaire, subjectId, parameters, bundle, useServerData, libraryEngine));
    }

    public <R extends IBaseResource> R prePopulate(PopulateRequest request) {
        return this.populateProcessor.prePopulate(request);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource populate(Either3<C, IIdType, R> questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, Boolean useServerData, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        return this.populate(questionnaire, patientId, parameters, bundle, useServerData, Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)dataEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)contentEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)terminologyEndpoint));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource populate(Either3<C, IIdType, R> questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, Boolean useServerData, Repository dataRepository, Repository contentRepository, Repository terminologyRepository) {
        this.repository = Repositories.proxy((Repository)this.repository, (Boolean)useServerData, (Repository)dataRepository, (Repository)contentRepository, (Repository)terminologyRepository);
        return this.populate(questionnaire, patientId, parameters, bundle, useServerData, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource populate(Either3<C, IIdType, R> questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, Boolean useServerData, LibraryEngine libraryEngine) {
        return this.populate((IBaseResource)this.resolveQuestionnaire(questionnaire), patientId, parameters, bundle, useServerData, libraryEngine);
    }

    public IBaseResource populate(IBaseResource questionnaire, String subjectId, IBaseParameters parameters, IBaseBundle bundle, Boolean useServerData, LibraryEngine libraryEngine) {
        return this.populate(this.buildPopulateRequest("populate", questionnaire, subjectId, parameters, bundle, useServerData, libraryEngine));
    }

    public IBaseResource populate(PopulateRequest request) {
        return this.populateProcessor.populate(request);
    }
}

