/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.generate.dstu3;

import java.util.List;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.dstu3.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionnaireTypeIsChoice {
    protected static final Logger logger = LoggerFactory.getLogger(QuestionnaireTypeIsChoice.class);
    protected Repository repository;

    public QuestionnaireTypeIsChoice(Repository repository) {
        this.repository = repository;
    }

    public Questionnaire.QuestionnaireItemComponent addProperties(ElementDefinition element, Questionnaire.QuestionnaireItemComponent item) {
        ValueSet valueSet = this.getValueSet(element);
        if (valueSet != null) {
            if (valueSet.hasExpansion()) {
                this.addAnswerOptionsForValueSetWithExpansionComponent(valueSet, item);
            } else {
                this.addAnswerOptionsForValueSetWithComposeComponent(valueSet, item);
            }
        }
        return item;
    }

    protected void addAnswerOptionsForValueSetWithExpansionComponent(ValueSet valueSet, Questionnaire.QuestionnaireItemComponent item) {
        List expansionList = valueSet.getExpansion().getContains();
        expansionList.forEach(expansion -> {
            Coding coding = this.getCoding((ValueSet.ValueSetExpansionContainsComponent)expansion);
            item.addOption().setValue((Type)coding);
        });
    }

    protected void addAnswerOptionsForValueSetWithComposeComponent(ValueSet valueSet, Questionnaire.QuestionnaireItemComponent item) {
        List systems = valueSet.getCompose().getInclude();
        systems.forEach(system -> system.getConcept().forEach(concept -> {
            Coding coding = this.getCoding((ValueSet.ConceptReferenceComponent)concept, system.getSystem());
            item.addOption().setValue((Type)coding);
        }));
    }

    protected Coding getCoding(ValueSet.ConceptReferenceComponent code, String systemUri) {
        return new Coding().setCode(code.getCode()).setSystem(systemUri).setDisplay(code.getDisplay());
    }

    protected Coding getCoding(ValueSet.ValueSetExpansionContainsComponent code) {
        return new Coding().setCode(code.getCode()).setSystem(code.getSystem()).setDisplay(code.getDisplay());
    }

    protected ValueSet getValueSet(ElementDefinition element) {
        if (element.hasBinding()) {
            try {
                PrimitiveType valueSetUrl = new StringType().setValue((Object)element.getBinding().getValueSet().primitiveValue());
                return (ValueSet)SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)valueSetUrl);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return null;
    }
}

