/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.extract;

import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.ExtractRequest;
import org.opencds.cqf.fhir.cr.questionnaireresponse.extract.dstu3.ObservationResolver;

public class ProcessItem {
    public void processItem(ExtractRequest request, IBaseBackboneElement item, Map<String, List<IBaseCoding>> questionnaireCodeMap, List<IBaseResource> resources, IBaseReference subject) {
        if (questionnaireCodeMap == null || questionnaireCodeMap.isEmpty()) {
            throw new IllegalArgumentException("Unable to retrieve Questionnaire code map for Observation based extraction");
        }
        IBaseExtension<?, ?> categoryExt = request.getExtensionByUrl((IBase)item, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observation-extract-category");
        List<IBaseBackboneElement> answers = request.resolvePathList((IBase)item, "answer", IBaseBackboneElement.class);
        if (!answers.isEmpty()) {
            answers.forEach(answer -> {
                List<IBaseBackboneElement> answerItems = request.getItems((IBase)answer);
                if (!answerItems.isEmpty()) {
                    answerItems.forEach(answerItem -> this.processItem(request, (IBaseBackboneElement)answerItem, questionnaireCodeMap, resources, subject));
                } else {
                    String linkId = request.resolvePathString((IBase)item, "linkId");
                    if (questionnaireCodeMap.get(linkId) != null && !((List)questionnaireCodeMap.get(linkId)).isEmpty()) {
                        resources.add(this.createObservationFromItemAnswer(request, (IBaseBackboneElement)answer, linkId, subject, questionnaireCodeMap, categoryExt));
                    }
                }
            });
        }
    }

    private IBaseResource createObservationFromItemAnswer(ExtractRequest request, IBaseBackboneElement answer, String linkId, IBaseReference subject, Map<String, List<IBaseCoding>> questionnaireCodeMap, IBaseExtension<?, ?> categoryExt) {
        switch (request.getFhirVersion()) {
            case DSTU3: {
                return new ObservationResolver().resolve(request, answer, linkId, subject, questionnaireCodeMap, categoryExt);
            }
            case R4: {
                return new org.opencds.cqf.fhir.cr.questionnaireresponse.extract.r4.ObservationResolver().resolve(request, answer, linkId, subject, questionnaireCodeMap, categoryExt);
            }
            case R5: {
                return new org.opencds.cqf.fhir.cr.questionnaireresponse.extract.r5.ObservationResolver().resolve(request, answer, linkId, subject, questionnaireCodeMap, categoryExt);
            }
        }
        return null;
    }
}

